import request from '@/utils/request'

// 查询设备报警-风险计算列表
export function listEquipBj(query) {
  return request({
    url: '/business/equipBj/list',
    method: 'get',
    params: query
  })
}

// 查询设备报警-风险计算所有列表
export function listAllEquipBj(query) {
  return request({
    url: '/business/equipBj/listAll',
    method: 'get',
    params: query
  })
}

// 查询设备报警-风险计算详细
export function getEquipBj(id) {
  return request({
    url: '/business/equipBj/getInfo/' + id,
    method: 'get'
  })
}

// 新增设备报警-风险计算
export function addEquipBj(data) {
  return request({
    url: '/business/equipBj/add',
    method: 'post',
    data: data
  })
}

// 修改设备报警-风险计算
export function updateEquipBj(data) {
  return request({
    url: '/business/equipBj/edit',
    method: 'post',
    data: data
  })
}

// 删除设备报警-风险计算
export function delEquipBj(id) {
  return request({
    url: '/business/equipBj/remove/' + id,
    method: 'get'
  })
}