import request from '@/utils/request'

// 查询水质数据列表
export function listSzData(query) {
  return request({
    url: '/business/szData/list',
    method: 'get',
    params: query
  })
}

// 查询水质数据所有列表
export function listAllSzData(query) {
  return request({
    url: '/business/szData/listAll',
    method: 'get',
    params: query
  })
}

// 查询水质数据详细
export function getSzData(id) {
  return request({
    url: '/business/szData/getInfo/' + id,
    method: 'get'
  })
}

// 新增水质数据
export function addSzData(data) {
  return request({
    url: '/business/szData/add',
    method: 'post',
    data: data
  })
}

// 修改水质数据
export function updateSzData(data) {
  return request({
    url: '/business/szData/edit',
    method: 'post',
    data: data
  })
}

// 删除水质数据
export function delSzData(id) {
  return request({
    url: '/business/szData/remove/' + id,
    method: 'get'
  })
}