import request from '@/utils/request'

// 内部位移 实时数据
export function displacementreal() {
  return request({
    url: '/slope/displacement/real',
    method: 'get',
  })
}
// 内部位移 历史数据
export function displacementhistory(params) {
  return request({
    url: '/slope/displacement/history',
    method: 'get',
    params
  })
}
// 内部位移 图表数据
export function displacementimage() {
  return request({
    url: '/slope/displacement/image',
    method: 'get',
  })
}
// 表面位移 实时数据
export function surDisplacementreal() {
  return request({
    url: '/slope/surDisplacement/real',
    method: 'get',
  })
}
// 表面位移 图表数据
export function surDisplacementimage() {
  return request({
    url: '/slope/surDisplacement/image',
    method: 'get',
  })
}
// 表面位移 历史数据
export function surDisplacementhistory(params) {
  return request({
    url: '/slope/surDisplacement/history',
    method: 'get',
    params
  })
}
// 数据监测: 报警管理  报警记录
// 监测类型 1:表面位移 2:内部位移 3:地表裂缝 4: 地面隆起 5: 支护结构 6: 土(墙)体土压力 7: 地下水位 8: 渗水压力 9 爆破振动 10:智能监测机器人 11:降雨量
export function dataAlarm(params) {
  return request({
    url: '/slope/alarm/alarm',
    method: 'get',
    params
  })
}
export function dataAlarmreal(params) {
  return request({
    url: '/slope/alarm/real',
    method: 'get',
    params
  })
}
// 数据监测: 设备管理
//1:表面位移 2:内部位移 3:地表裂缝 4: 地面隆起 5: 支护结构 6: 土(墙)体土压力 7: 地下水位 8: 渗水压力 9 爆破振动 10:智能监测机器人 11:降雨量
export function monDic(params) {
  return request({
    url: '/slope/eq/monDic',
    method: 'get',
    params
  })
}

// 爆破震动 历史数据
export function blastinghistory(params) {
  return request({
    url: '/slope/blasting/hsitory',
    method: 'get',
    params
  })
}


// 智能机器人 实时数据
export function intelligencereal() {
  return request({
    url: '/slope/intelligence/real',
    method: 'get',
  })
}
// 智能机器人 图表数据
export function intelligenceimage() {
  return request({
    url: '/slope/intelligence/image',
    method: 'get',
  })
}
// 智能机器人 历史数据
export function intelligencehistory(params) {
  return request({
    url: '/slope/intelligence/history',
    method: 'get',
    params
  })
}

// 降雨量 历史数据
export function rainfallhistory(params) {
  return request({
    url: '/slope/rainfall/history',
    method: 'get',
    params
  })
}
// 降雨量 图表数据 (近24小时的降雨量)
export function rainfallImage(params) {
  return request({
    url: '/slope/rainfall/nearForTyImage',
    method: 'get',
    params
  })
}
// 降雨量 图表数据 (近一周的降雨量)
export function nearlyWeekImage(params) {
  return request({
    url: '/slope/rainfall/nearlyWeekImage',
    method: 'get',
    params
  })
}

// 地面隆起 实时数据 4: 地面隆起
export function upliftreal() {
  return request({
    url: '/slope/uplift/real',
    method: 'get',
  })
}
// 地面隆起 图表数据
export function upliftimage() {
  return request({
    url: '/slope/uplift/image',
    method: 'get',
  })
}
// 地面隆起 历史数据
export function uplifthistory(params) {
  return request({
    url: '/slope/uplift/history',
    method: 'get',
    params
  })
}

// 支护结构 实时数据  5: 支护结构
export function stressreal() {
  return request({
    url: '/slope/stress/real',
    method: 'get',
  })
}
// 支护结构 图表数据
export function stressimage() {
  return request({
    url: '/slope/stress/image',
    method: 'get',
  })
}
// 支护结构 历史数据
export function stresshistory(params) {
  return request({
    url: '/slope/stress/history',
    method: 'get',
    params
  })
}

// 地表裂缝 实时数据  3:地表裂缝
export function fracturereal() {
  return request({
    url: '/slope/fracture/real',
    method: 'get',
  })
}
// 地表裂缝 图表数据
export function fractureimage() {
  return request({
    url: '/slope/fracture/image',
    method: 'get',
  })
}
// 地表裂缝 历史数据
export function fracturehistory(params) {
  return request({
    url: '/slope/fracture/history',
    method: 'get',
    params
  })
}


// 渗水压力 实时数据  8: 渗水压力
export function seepagereal() {
  return request({
    url: '/slope/seepage/real',
    method: 'get',
  })
}
// 渗水压力 图表数据
export function seepageimage() {
  return request({
    url: '/slope/seepage/image',
    method: 'get',
  })
}
// 渗水压力 历史数据
export function seepagehistory(params) {
  return request({
    url: '/slope/seepage/history',
    method: 'get',
    params
  })
}



// 土(墙)体土压力 实时数据  6: 土(墙)体土压力
export function wallreal() {
  return request({
    url: '/slope/wall/real',
    method: 'get',
  })
}
// 土(墙)体土压力 图表数据
export function wallimage() {
  return request({
    url: '/slope/wall/image',
    method: 'get',
  })
}
// 土(墙)体土压力 历史数据
export function wallhistory(params) {
  return request({
    url: '/slope/wall/history',
    method: 'get',
    params
  })
}

// 地下水位 实时数据  7: 地下水位
export function waterreal() {
  return request({
    url: '/slope/water/real',
    method: 'get',
  })
}
// 地下水位 图表数据
export function waterimage() {
  return request({
    url: '/slope/water/image',
    method: 'get',
  })
}
// 地下水位 历史数据
export function waterhistory(params) {
  return request({
    url: '/slope/water/history',
    method: 'get',
    params
  })
}


// 气象预警 实时数据  12: 气象预警
export function meteorologicalreal() {
  return request({
    url: '/slope/meteorological/real',
    method: 'get',
  })
}
// 气象预警 图表数据
export function meteorologicalimage() {
  return request({
    url: '/slope/meteorological/image',
    method: 'get',
  })
}
// 气象预警 历史数据
export function meteorologicalhistory(params) {
  return request({
    url: '/slope/meteorological/history',
    method: 'get',
    params
  })
}

//天气
export function getWeather(params) {
  return request({
    url: 'http://60.212.188.152:12001/weather',
    // url: 'http://192.168.0.233:83/weather',
    // url: 'http://192.168.3.216/weather',
    method: 'post',
    params
  })
}