import request from '@/utils/request'

// 微震数据列表
export function getWeizhen(query) {
  return request({
    url: '/business/monBlasting/getWeizhen',
    method: 'get',
		params: query
  })
}

//感知基础信息管理表格
export function perceTable(query) {
  return request({
    url: '/business/microseismequipment/list',
    method: 'get',
		params: query
  })
}

//感知基础信息管理新增
export function perceAdd(data) {
  return request({
    url: '/business/microseismequipment/add',
    method: 'post',
	data,
  })
}

// 感知基础信息管理编辑
export function perceEdit(data) {
  return request({
	url: '/business/microseismequipment/edit',
	method: 'post',
	data,
  })
}
// 感知基础信息管理删除
export function perceDel(data) {
  return request({
	url:'/business/microseismequipment',
	method: 'delete',
	data,
  })
}
//微震事件表格
export function wzTable(query) {
  return request({
    url: '/business/monBlasting/list',
    method: 'get',
	  params: query
  })
}
//微震事件波形图
export function waveForm(query) {
  return request({
    url: '/business/monBlasting/data',
    method: 'get',
	params: query
  })
}
//微震事件编辑
export function waveEdit(data) {
  return request({
    url: '/business/monBlasting/edit',
    method: 'post',
	data
  })
}
//灵敏度获取
export function getSens(query) {
  return request({
    url:"/business/microseismequipment/sensitivity",
    method: 'get',
	params: query
  })
}
//灵敏度保存
export function saveSens(data) {
  return request({
    url:"/business/microseismequipment/sensitivity",
    method: 'put',
	data,
  })
}
//钻孔应力设备管理表格
export function drillequTable(query) {
  return request({
    url: '/business/stressequipment/list',
    method: 'get',
	params: query
  })
}
//钻孔应力设备管理新增
export function drillequAdd(data) {
  return request({
    url: '/business/stressequipment/add',
    method: 'post',
	data,
  })
}

// 钻孔应力设备管理编辑
export function drillequEdit(data) {
  return request({
	url: '/business/stressequipment/edit',
	method: 'post',
	data,
  })
}
//  钻孔应力设备管理删除
export function drillequDel(data) {
  return request({
	url:"/business/stressequipment",
	method: 'delete',
	data,
  })
}
//钻孔应力设备管理设备名称下拉
export function drillequselect(query) {
  return request({
    url: '/business/stressequipment/listAll',
    method: 'get',
	params: query
  })
}
//钻孔应力历史数据
export function drillhisTable(query) {
  return request({
    url: '/business/data/list',
    method: 'get',
	params: query
  })
}
//钻孔应力历史数据设备名称下拉
export function drillhisselect(query) {
  return request({
	url: '/business/data/listAll',
	method: 'get',
	params: query
  })
}

//钻孔应力值监测----查询断面名称
export function getsecName(query) {
  return request({
    url: '/business/stressequipment/listSectionName',
    method: 'get',
	params: query
  })
}
//钻孔应力值监测----折线图
export function foldline(query) {
  return request({
    url:"/business/data/image",
    method: 'get',
	params: query
  })
}



//巷道表面位移设备管理----表格
export function tunnelTable(query) {
  return request({
    url: '/business/tunnelequipment/list',
    method: 'get',
	params: query
  })
}
//巷道表面位移设备管理设备名称下拉
export function tunnelselect(query) {
  return request({
	url: '/business/tunnelequipment/listAll',
	method: 'get',
	params: query
  })
}
//巷道表面位移设备管理---新增
export function tunnelAdd(data) {
  return request({
    url: '/business/tunnelequipment/add',
    method: 'post',
	data,
  })
}
//巷道表面位移设备管理---编辑
export function tunnelEdit(data) {
  return request({
	url: '/business/tunnelequipment/edit',
	method: 'post',
	data,
  })
}
//巷道表面位移设备管理---删除
export function tunnelDel(data) {
  return request({
	url:'/business/tunnelequipment',
	method: 'delete',
	data,
  })
}

//巷道表面位移历史数据
export function tunnelhisTable(query) {
  return request({
    url: '/business/tun/data/list',
    method: 'get',
	params: query
  })
}
//巷道表面位移历史数据设备名称下拉
export function tunnelhisselect(query) {
  return request({
	url: '/business/tun/data/listAll',
	method: 'get',
	params: query
  })
}

//巷道表面位移数据分析----查询断面名称
export function getanaName(query) {
  return request({
    url:"/business/tunnelequipment/listSectionName",
    method: 'get',
	params: query
  })
}
//巷道表面位移数据分析----查询曲线
export function analine(query) {
  return request({
    url:"/business/tun/data/image",
    method:'get',
	params: query
  })
}
//报警管理---查询表格
export function policeTable(query) {
  return request({
    url: '/business/abnormal/list',
    method: 'get',
	params: query
  })
}
//报警管理---设备名称下拉
export function policeselect(query) {
  return request({
	url: '/business/abnormal/listAll',
	method: 'get',
	params: query
  })
}
//报警管理---解除报警
export function policeEdit(data) {
  return request({
    url: '/business/abnormal/edit',
    method: 'post',
	data
  })
}

// //首页---微震事件
export function wzEvent(query) {
  return request({
    url: '/business/monBlasting/list',
	method: 'get',
	params: query
  })
}

//微震实时数据下拉
export function microseismequipmentGetName() {
  return request({
	url: '/business/microseismequipment/getName',
	method: 'get',
  })
}

//实时曲线接口
export function monBlastingCurve(seneorname) {
  return request({
    url: '/business/monBlasting/curve',
	method: 'get',
	params: {seneorname}
  })
}