/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["exports","./Transforms-a48d25e5","./Matrix2-c339372d","./ComponentDatatype-1b227f17","./defaultValue-65031fc5","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./GeometryOffsetAttribute-026030ef","./IndexDatatype-53de8b23"],(function(t,i,e,n,a,o,r,s,u){"use strict";const m=new e.Cartesian3(1,1,1),f=Math.cos,l=Math.sin;function c(t){t=a.defaultValue(t,a.defaultValue.EMPTY_OBJECT);const i=a.defaultValue(t.radii,m),o=a.defaultValue(t.innerRadii,i),r=a.defaultValue(t.minimumClock,0),s=a.defaultValue(t.maximumClock,n.CesiumMath.TWO_PI),u=a.defaultValue(t.minimumCone,0),f=a.defaultValue(t.maximumCone,n.CesiumMath.PI),l=Math.round(a.defaultValue(t.stackPartitions,10)),c=Math.round(a.defaultValue(t.slicePartitions,8)),d=Math.round(a.defaultValue(t.subdivisions,128));this._radii=e.Cartesian3.clone(i),this._innerRadii=e.Cartesian3.clone(o),this._minimumClock=r,this._maximumClock=s,this._minimumCone=u,this._maximumCone=f,this._stackPartitions=l,this._slicePartitions=c,this._subdivisions=d,this._offsetAttribute=t.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}c.packedLength=2*e.Cartesian3.packedLength+8,c.pack=function(t,i,n){return n=a.defaultValue(n,0),e.Cartesian3.pack(t._radii,i,n),n+=e.Cartesian3.packedLength,e.Cartesian3.pack(t._innerRadii,i,n),n+=e.Cartesian3.packedLength,i[n++]=t._minimumClock,i[n++]=t._maximumClock,i[n++]=t._minimumCone,i[n++]=t._maximumCone,i[n++]=t._stackPartitions,i[n++]=t._slicePartitions,i[n++]=t._subdivisions,i[n]=a.defaultValue(t._offsetAttribute,-1),i};const d=new e.Cartesian3,C=new e.Cartesian3,_={radii:d,innerRadii:C,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};c.unpack=function(t,i,n){i=a.defaultValue(i,0);const o=e.Cartesian3.unpack(t,i,d);i+=e.Cartesian3.packedLength;const r=e.Cartesian3.unpack(t,i,C);i+=e.Cartesian3.packedLength;const s=t[i++],u=t[i++],m=t[i++],f=t[i++],l=t[i++],p=t[i++],h=t[i++],y=t[i];return a.defined(n)?(n._radii=e.Cartesian3.clone(o,n._radii),n._innerRadii=e.Cartesian3.clone(r,n._innerRadii),n._minimumClock=s,n._maximumClock=u,n._minimumCone=m,n._maximumCone=f,n._stackPartitions=l,n._slicePartitions=p,n._subdivisions=h,n._offsetAttribute=-1===y?void 0:y,n):(_.minimumClock=s,_.maximumClock=u,_.minimumCone=m,_.maximumCone=f,_.stackPartitions=l,_.slicePartitions=p,_.subdivisions=h,_.offsetAttribute=-1===y?void 0:y,new c(_))},c.createGeometry=function(t){const m=t._radii;if(m.x<=0||m.y<=0||m.z<=0)return;const c=t._innerRadii;if(c.x<=0||c.y<=0||c.z<=0)return;const d=t._minimumClock,C=t._maximumClock,_=t._minimumCone,p=t._maximumCone,h=t._subdivisions,y=e.Ellipsoid.fromCartesian3(m);let b=t._slicePartitions+1,k=t._stackPartitions+1;b=Math.round(b*Math.abs(C-d)/n.CesiumMath.TWO_PI),k=Math.round(k*Math.abs(p-_)/n.CesiumMath.PI),b<2&&(b=2),k<2&&(k=2);let x=0,A=1;const P=c.x!==m.x||c.y!==m.y||c.z!==m.z;let v=!1,M=!1;P&&(A=2,_>0&&(v=!0,x+=b),p<Math.PI&&(M=!0,x+=b));const w=h*A*(k+b),V=new Float64Array(3*w),g=2*(w+x-(b+k)*A),G=u.IndexDatatype.createTypedArray(w,g);let E,O,D,I,T=0;const z=new Array(k),L=new Array(k);for(E=0;E<k;E++)I=_+E*(p-_)/(k-1),z[E]=l(I),L[E]=f(I);const R=new Array(h),N=new Array(h);for(E=0;E<h;E++)D=d+E*(C-d)/(h-1),R[E]=l(D),N[E]=f(D);for(E=0;E<k;E++)for(O=0;O<h;O++)V[T++]=m.x*z[E]*N[O],V[T++]=m.y*z[E]*R[O],V[T++]=m.z*L[E];if(P)for(E=0;E<k;E++)for(O=0;O<h;O++)V[T++]=c.x*z[E]*N[O],V[T++]=c.y*z[E]*R[O],V[T++]=c.z*L[E];for(z.length=h,L.length=h,E=0;E<h;E++)I=_+E*(p-_)/(h-1),z[E]=l(I),L[E]=f(I);for(R.length=b,N.length=b,E=0;E<b;E++)D=d+E*(C-d)/(b-1),R[E]=l(D),N[E]=f(D);for(E=0;E<h;E++)for(O=0;O<b;O++)V[T++]=m.x*z[E]*N[O],V[T++]=m.y*z[E]*R[O],V[T++]=m.z*L[E];if(P)for(E=0;E<h;E++)for(O=0;O<b;O++)V[T++]=c.x*z[E]*N[O],V[T++]=c.y*z[E]*R[O],V[T++]=c.z*L[E];for(T=0,E=0;E<k*A;E++){const t=E*h;for(O=0;O<h-1;O++)G[T++]=t+O,G[T++]=t+O+1}let B=k*h*A;for(E=0;E<b;E++)for(O=0;O<h-1;O++)G[T++]=B+E+O*b,G[T++]=B+E+(O+1)*b;if(P)for(B=k*h*A+b*h,E=0;E<b;E++)for(O=0;O<h-1;O++)G[T++]=B+E+O*b,G[T++]=B+E+(O+1)*b;if(P){let t=k*h*A,i=t+h*b;if(v)for(E=0;E<b;E++)G[T++]=t+E,G[T++]=i+E;if(M)for(t+=h*b-b,i+=h*b-b,E=0;E<b;E++)G[T++]=t+E,G[T++]=i+E}const S=new r.GeometryAttributes({position:new o.GeometryAttribute({componentDatatype:n.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:V})});if(a.defined(t._offsetAttribute)){const i=V.length,e=t._offsetAttribute===s.GeometryOffsetAttribute.NONE?0:1,a=new Uint8Array(i/3).fill(e);S.applyOffset=new o.GeometryAttribute({componentDatatype:n.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:a})}return new o.Geometry({attributes:S,indices:G,primitiveType:o.PrimitiveType.LINES,boundingSphere:i.BoundingSphere.fromEllipsoid(y),offsetAttribute:t._offsetAttribute})},t.EllipsoidOutlineGeometry=c}));
