/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./defaultValue-65031fc5","./Matrix2-c339372d","./ArcType-84fe1b78","./arrayRemoveDuplicates-235b23d8","./Transforms-a48d25e5","./Color-72bab6c2","./ComponentDatatype-1b227f17","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./IndexDatatype-53de8b23","./PolylinePipeline-78c6adf0","./VertexFormat-2b3ad79f","./RuntimeError-23f4777c","./combine-96aed74b","./WebGLConstants-f5c279b9","./EllipsoidGeodesic-14d277c6","./EllipsoidRhumbLine-0df6bb40","./IntersectionTests-87344d12","./Plane-3d182a08"],(function(e,t,o,n,r,a,i,l,s,c,p,d,u,y,m,f,h,C,g){"use strict";const b=[];function _(e,t,o,n,r){const i=b;let l;i.length=r;const s=o.red,c=o.green,p=o.blue,d=o.alpha,u=n.red,y=n.green,m=n.blue,f=n.alpha;if(a.Color.equals(o,n)){for(l=0;l<r;l++)i[l]=a.Color.clone(o);return i}const h=(u-s)/r,C=(y-c)/r,g=(m-p)/r,_=(f-d)/r;for(l=0;l<r;l++)i[l]=new a.Color(s+l*h,c+l*C,p+l*g,d+l*_);return i}function A(n){const r=(n=e.defaultValue(n,e.defaultValue.EMPTY_OBJECT)).positions,l=n.colors,s=e.defaultValue(n.width,1),c=e.defaultValue(n.colorsPerVertex,!1);this._positions=r,this._colors=l,this._width=s,this._colorsPerVertex=c,this._vertexFormat=d.VertexFormat.clone(e.defaultValue(n.vertexFormat,d.VertexFormat.DEFAULT)),this._arcType=e.defaultValue(n.arcType,o.ArcType.GEODESIC),this._granularity=e.defaultValue(n.granularity,i.CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=t.Ellipsoid.clone(e.defaultValue(n.ellipsoid,t.Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";let p=1+r.length*t.Cartesian3.packedLength;p+=e.defined(l)?1+l.length*a.Color.packedLength:1,this.packedLength=p+t.Ellipsoid.packedLength+d.VertexFormat.packedLength+4}A.pack=function(o,n,r){let i;r=e.defaultValue(r,0);const l=o._positions;let s=l.length;for(n[r++]=s,i=0;i<s;++i,r+=t.Cartesian3.packedLength)t.Cartesian3.pack(l[i],n,r);const c=o._colors;for(s=e.defined(c)?c.length:0,n[r++]=s,i=0;i<s;++i,r+=a.Color.packedLength)a.Color.pack(c[i],n,r);return t.Ellipsoid.pack(o._ellipsoid,n,r),r+=t.Ellipsoid.packedLength,d.VertexFormat.pack(o._vertexFormat,n,r),r+=d.VertexFormat.packedLength,n[r++]=o._width,n[r++]=o._colorsPerVertex?1:0,n[r++]=o._arcType,n[r]=o._granularity,n};const E=t.Ellipsoid.clone(t.Ellipsoid.UNIT_SPHERE),P=new d.VertexFormat,w={positions:void 0,colors:void 0,ellipsoid:E,vertexFormat:P,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};A.unpack=function(o,n,r){let i;n=e.defaultValue(n,0);let l=o[n++];const s=new Array(l);for(i=0;i<l;++i,n+=t.Cartesian3.packedLength)s[i]=t.Cartesian3.unpack(o,n);l=o[n++];const c=l>0?new Array(l):void 0;for(i=0;i<l;++i,n+=a.Color.packedLength)c[i]=a.Color.unpack(o,n);const p=t.Ellipsoid.unpack(o,n,E);n+=t.Ellipsoid.packedLength;const u=d.VertexFormat.unpack(o,n,P);n+=d.VertexFormat.packedLength;const y=o[n++],m=1===o[n++],f=o[n++],h=o[n];return e.defined(r)?(r._positions=s,r._colors=c,r._ellipsoid=t.Ellipsoid.clone(p,r._ellipsoid),r._vertexFormat=d.VertexFormat.clone(u,r._vertexFormat),r._width=y,r._colorsPerVertex=m,r._arcType=f,r._granularity=h,r):(w.positions=s,w.colors=c,w.width=y,w.colorsPerVertex=m,w.arcType=f,w.granularity=h,new A(w))};const x=new t.Cartesian3,T=new t.Cartesian3,D=new t.Cartesian3,k=new t.Cartesian3;return A.createGeometry=function(d){const u=d._width,y=d._vertexFormat;let m=d._colors;const f=d._colorsPerVertex,h=d._arcType,C=d._granularity,g=d._ellipsoid;let A,E,P;const w=[];let V=n.arrayRemoveDuplicates(d._positions,t.Cartesian3.equalsEpsilon,!1,w);if(e.defined(m)&&w.length>0){let e=0,t=w[0];m=m.filter((function(o,n){let r=!1;return r=f?n===t||0===n&&1===t:n+1===t,!r||(e++,t=w[e],!1)}))}let v=V.length;if(v<2||u<=0)return;if(h===o.ArcType.GEODESIC||h===o.ArcType.RHUMB){let t,n;h===o.ArcType.GEODESIC?(t=i.CesiumMath.chordLength(C,g.maximumRadius),n=p.PolylinePipeline.numberOfPoints):(t=C,n=p.PolylinePipeline.numberOfPointsRhumbLine);const r=p.PolylinePipeline.extractHeights(V,g);if(e.defined(m)){let e=1;for(A=0;A<v-1;++A)e+=n(V[A],V[A+1],t);const o=new Array(e);let r=0;for(A=0;A<v-1;++A){const i=V[A],l=V[A+1],s=m[A],c=n(i,l,t);if(f&&A<e){const e=_(0,0,s,m[A+1],c),t=e.length;for(E=0;E<t;++E)o[r++]=e[E]}else for(E=0;E<c;++E)o[r++]=a.Color.clone(s)}o[r]=a.Color.clone(m[m.length-1]),m=o,b.length=0}V=h===o.ArcType.GEODESIC?p.PolylinePipeline.generateCartesianArc({positions:V,minDistance:t,ellipsoid:g,height:r}):p.PolylinePipeline.generateCartesianRhumbArc({positions:V,granularity:t,ellipsoid:g,height:r})}v=V.length;const L=4*v-4,F=new Float64Array(3*L),G=new Float64Array(3*L),O=new Float64Array(3*L),R=new Float32Array(2*L),I=y.st?new Float32Array(2*L):void 0,S=e.defined(m)?new Uint8Array(4*L):void 0;let B,U=0,N=0,M=0,H=0;for(E=0;E<v;++E){let o,n;0===E?(B=x,t.Cartesian3.subtract(V[0],V[1],B),t.Cartesian3.add(V[0],B,B)):B=V[E-1],t.Cartesian3.clone(B,D),t.Cartesian3.clone(V[E],T),E===v-1?(B=x,t.Cartesian3.subtract(V[v-1],V[v-2],B),t.Cartesian3.add(V[v-1],B,B)):B=V[E+1],t.Cartesian3.clone(B,k),e.defined(S)&&(o=0===E||f?m[E]:m[E-1],E!==v-1&&(n=m[E]));const r=E===v-1?2:4;for(P=0===E?2:0;P<r;++P){t.Cartesian3.pack(T,F,U),t.Cartesian3.pack(D,G,U),t.Cartesian3.pack(k,O,U),U+=3;const r=P-2<0?-1:1;if(R[N++]=P%2*2-1,R[N++]=r*u,y.st&&(I[M++]=E/(v-1),I[M++]=Math.max(R[N-2],0)),e.defined(S)){const e=P<2?o:n;S[H++]=a.Color.floatToByte(e.red),S[H++]=a.Color.floatToByte(e.green),S[H++]=a.Color.floatToByte(e.blue),S[H++]=a.Color.floatToByte(e.alpha)}}}const W=new s.GeometryAttributes;W.position=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:F}),W.prevPosition=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:G}),W.nextPosition=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:O}),W.expandAndWidth=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:R}),y.st&&(W.st=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:I})),e.defined(S)&&(W.color=new l.GeometryAttribute({componentDatatype:i.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:4,values:S,normalize:!0}));const Y=c.IndexDatatype.createTypedArray(L,6*v-6);let q=0,z=0;const J=v-1;for(E=0;E<J;++E)Y[z++]=q,Y[z++]=q+2,Y[z++]=q+1,Y[z++]=q+1,Y[z++]=q+2,Y[z++]=q+3,q+=4;return new l.Geometry({attributes:W,indices:Y,primitiveType:l.PrimitiveType.TRIANGLES,boundingSphere:r.BoundingSphere.fromPoints(V),geometryType:l.GeometryType.POLYLINES})},function(o,n){return e.defined(n)&&(o=A.unpack(o,n)),o._ellipsoid=t.Ellipsoid.clone(o._ellipsoid),A.createGeometry(o)}}));
