/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./defaultValue-65031fc5","./Matrix2-c339372d","./arrayRemoveDuplicates-235b23d8","./BoundingRectangle-ef4c3611","./Transforms-a48d25e5","./ComponentDatatype-1b227f17","./PolylineVolumeGeometryLibrary-b3408464","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./GeometryPipeline-7e799ed5","./IndexDatatype-53de8b23","./PolygonPipeline-d06990ae","./VertexFormat-2b3ad79f","./RuntimeError-23f4777c","./combine-96aed74b","./WebGLConstants-f5c279b9","./EllipsoidTangentPlane-1f1eb3e6","./AxisAlignedBoundingBox-f07e0e43","./IntersectionTests-87344d12","./Plane-3d182a08","./PolylinePipeline-78c6adf0","./EllipsoidGeodesic-14d277c6","./EllipsoidRhumbLine-0df6bb40","./AttributeCompression-9d180a12","./EncodedCartesian3-4e907eba"],(function(e,t,n,o,i,a,r,l,s,p,c,d,u,m,y,g,f,h,b,P,E,_,k,v,V){"use strict";function L(n){const o=(n=e.defaultValue(n,e.defaultValue.EMPTY_OBJECT)).polylinePositions,i=n.shapePositions;this._positions=o,this._shape=i,this._ellipsoid=t.Ellipsoid.clone(e.defaultValue(n.ellipsoid,t.Ellipsoid.WGS84)),this._cornerType=e.defaultValue(n.cornerType,r.CornerType.ROUNDED),this._vertexFormat=u.VertexFormat.clone(e.defaultValue(n.vertexFormat,u.VertexFormat.DEFAULT)),this._granularity=e.defaultValue(n.granularity,a.CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";let l=1+o.length*t.Cartesian3.packedLength;l+=1+i.length*t.Cartesian2.packedLength,this.packedLength=l+t.Ellipsoid.packedLength+u.VertexFormat.packedLength+2}L.pack=function(n,o,i){let a;i=e.defaultValue(i,0);const r=n._positions;let l=r.length;for(o[i++]=l,a=0;a<l;++a,i+=t.Cartesian3.packedLength)t.Cartesian3.pack(r[a],o,i);const s=n._shape;for(l=s.length,o[i++]=l,a=0;a<l;++a,i+=t.Cartesian2.packedLength)t.Cartesian2.pack(s[a],o,i);return t.Ellipsoid.pack(n._ellipsoid,o,i),i+=t.Ellipsoid.packedLength,u.VertexFormat.pack(n._vertexFormat,o,i),i+=u.VertexFormat.packedLength,o[i++]=n._cornerType,o[i]=n._granularity,o};const x=t.Ellipsoid.clone(t.Ellipsoid.UNIT_SPHERE),C=new u.VertexFormat,F={polylinePositions:void 0,shapePositions:void 0,ellipsoid:x,vertexFormat:C,cornerType:void 0,granularity:void 0};L.unpack=function(n,o,i){let a;o=e.defaultValue(o,0);let r=n[o++];const l=new Array(r);for(a=0;a<r;++a,o+=t.Cartesian3.packedLength)l[a]=t.Cartesian3.unpack(n,o);r=n[o++];const s=new Array(r);for(a=0;a<r;++a,o+=t.Cartesian2.packedLength)s[a]=t.Cartesian2.unpack(n,o);const p=t.Ellipsoid.unpack(n,o,x);o+=t.Ellipsoid.packedLength;const c=u.VertexFormat.unpack(n,o,C);o+=u.VertexFormat.packedLength;const d=n[o++],m=n[o];return e.defined(i)?(i._positions=l,i._shape=s,i._ellipsoid=t.Ellipsoid.clone(p,i._ellipsoid),i._vertexFormat=u.VertexFormat.clone(c,i._vertexFormat),i._cornerType=d,i._granularity=m,i):(F.polylinePositions=l,F.shapePositions=s,F.cornerType=d,F.granularity=m,new L(F))};const A=new o.BoundingRectangle;return L.createGeometry=function(e){const u=e._positions,m=n.arrayRemoveDuplicates(u,t.Cartesian3.equalsEpsilon);let y=e._shape;if(y=r.PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(y),m.length<2||y.length<3)return;d.PolygonPipeline.computeWindingOrder2D(y)===d.WindingOrder.CLOCKWISE&&y.reverse();const g=o.BoundingRectangle.fromPoints(y,A);return function(e,t,n,o){const u=new s.GeometryAttributes;o.position&&(u.position=new l.GeometryAttribute({componentDatatype:a.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:e}));const m=t.length,y=e.length/3,g=(y-2*m)/(2*m),f=d.PolygonPipeline.triangulate(t),h=(g-1)*m*6+2*f.length,b=c.IndexDatatype.createTypedArray(y,h);let P,E,_,k,v,V;const L=2*m;let x=0;for(P=0;P<g-1;P++){for(E=0;E<m-1;E++)_=2*E+P*m*2,V=_+L,k=_+1,v=k+L,b[x++]=k,b[x++]=_,b[x++]=v,b[x++]=v,b[x++]=_,b[x++]=V;_=2*m-2+P*m*2,k=_+1,v=k+L,V=_+L,b[x++]=k,b[x++]=_,b[x++]=v,b[x++]=v,b[x++]=_,b[x++]=V}if(o.st||o.tangent||o.bitangent){const e=new Float32Array(2*y),o=1/(g-1),i=1/n.height,r=n.height/2;let s,p,c=0;for(P=0;P<g;P++){for(s=P*o,p=i*(t[0].y+r),e[c++]=s,e[c++]=p,E=1;E<m;E++)p=i*(t[E].y+r),e[c++]=s,e[c++]=p,e[c++]=s,e[c++]=p;p=i*(t[0].y+r),e[c++]=s,e[c++]=p}for(E=0;E<m;E++)s=0,p=i*(t[E].y+r),e[c++]=s,e[c++]=p;for(E=0;E<m;E++)s=(g-1)*o,p=i*(t[E].y+r),e[c++]=s,e[c++]=p;u.st=new l.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:new Float32Array(e)})}const C=y-2*m;for(P=0;P<f.length;P+=3){const e=f[P]+C,t=f[P+1]+C,n=f[P+2]+C;b[x++]=e,b[x++]=t,b[x++]=n,b[x++]=n+m,b[x++]=t+m,b[x++]=e+m}let F=new l.Geometry({attributes:u,indices:b,boundingSphere:i.BoundingSphere.fromVertices(e),primitiveType:l.PrimitiveType.TRIANGLES});if(o.normal&&(F=p.GeometryPipeline.computeNormal(F)),o.tangent||o.bitangent){try{F=p.GeometryPipeline.computeTangentAndBitangent(F)}catch(e){r.oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}o.tangent||(F.attributes.tangent=void 0),o.bitangent||(F.attributes.bitangent=void 0),o.st||(F.attributes.st=void 0)}return F}(r.PolylineVolumeGeometryLibrary.computePositions(m,y,g,e,!0),y,g,e._vertexFormat)},function(n,o){return e.defined(o)&&(n=L.unpack(n,o)),n._ellipsoid=t.Ellipsoid.clone(n._ellipsoid),L.createGeometry(n)}}));
