/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./AxisAlignedBoundingBox-f07e0e43","./Transforms-a48d25e5","./Matrix2-c339372d","./defaultValue-65031fc5","./TerrainEncoding-5ceb0ee9","./ComponentDatatype-1b227f17","./OrientedBoundingBox-59c958d0","./RuntimeError-23f4777c","./WebMercatorProjection-b33ee193","./createTaskProcessorWorker","./combine-96aed74b","./AttributeCompression-9d180a12","./WebGLConstants-f5c279b9","./EllipsoidTangentPlane-1f1eb3e6","./IntersectionTests-87344d12","./Plane-3d182a08"],(function(t,e,n,i,o,r,a,s,c,u,h,d,l,g,m,p){"use strict";const I=Uint16Array.BYTES_PER_ELEMENT,f=Int32Array.BYTES_PER_ELEMENT,E=Uint32Array.BYTES_PER_ELEMENT,T=Float32Array.BYTES_PER_ELEMENT,C=Float64Array.BYTES_PER_ELEMENT;function M(t,e,n){n=i.defaultValue(n,r.CesiumMath);const o=t.length;for(let i=0;i<o;++i)if(n.equalsEpsilon(t[i],e,r.CesiumMath.EPSILON12))return i;return-1}const x=new n.Cartographic,N=new n.Cartesian3,b=new n.Cartesian3,S=new n.Cartesian3,w=new n.Matrix4;function B(t,e,o,a,s,c,u,h,d,l,g){const m=h.length;for(let p=0;p<m;++p){const I=h[p],f=I.cartographic,E=I.index,T=t.length,C=f.longitude;let M=f.latitude;M=r.CesiumMath.clamp(M,-r.CesiumMath.PI_OVER_TWO,r.CesiumMath.PI_OVER_TWO);const b=f.height-u.skirtHeight;u.hMin=Math.min(u.hMin,b),n.Cartographic.fromRadians(C,M,b,x),l&&(x.longitude+=d),l?p===m-1?x.latitude+=g:0===p&&(x.latitude-=g):x.latitude+=d;const S=u.ellipsoid.cartographicToCartesian(x);t.push(S),e.push(b),o.push(n.Cartesian2.clone(o[E])),a.length>0&&a.push(a[E]),s.length>0&&s.push(s[E]),n.Matrix4.multiplyByPoint(u.toENU,S,N);const w=u.minimum,B=u.maximum;n.Cartesian3.minimumByComponent(N,w,w),n.Cartesian3.maximumByComponent(N,B,B);const P=u.lastBorderPoint;if(i.defined(P)){const t=P.index;c.push(t,T-1,T,T,E,t)}u.lastBorderPoint=I}}return u((function(u,h){u.ellipsoid=n.Ellipsoid.clone(u.ellipsoid),u.rectangle=n.Rectangle.clone(u.rectangle);const d=function(u,h,d,l,g,m,p,P,A,y,R){let _,W,v,F,O,V;i.defined(l)?(_=l.west,W=l.south,v=l.east,F=l.north,O=l.width,V=l.height):(_=r.CesiumMath.toRadians(g.west),W=r.CesiumMath.toRadians(g.south),v=r.CesiumMath.toRadians(g.east),F=r.CesiumMath.toRadians(g.north),O=r.CesiumMath.toRadians(l.width),V=r.CesiumMath.toRadians(l.height));const Y=[W,F],U=[_,v],k=e.Transforms.eastNorthUpToFixedFrame(h,d),H=n.Matrix4.inverseTransformation(k,w);let L,D;A&&(L=c.WebMercatorProjection.geodeticLatitudeToMercatorAngle(W),D=1/(c.WebMercatorProjection.geodeticLatitudeToMercatorAngle(F)-L));const G=1!==m,j=new DataView(u);let z=Number.POSITIVE_INFINITY,q=Number.NEGATIVE_INFINITY;const J=b;J.x=Number.POSITIVE_INFINITY,J.y=Number.POSITIVE_INFINITY,J.z=Number.POSITIVE_INFINITY;const K=S;K.x=Number.NEGATIVE_INFINITY,K.y=Number.NEGATIVE_INFINITY,K.z=Number.NEGATIVE_INFINITY;let Q,X,Z=0,$=0,tt=0;for(X=0;X<4;++X){let t=Z;Q=j.getUint32(t,!0),t+=E;const e=r.CesiumMath.toRadians(180*j.getFloat64(t,!0));t+=C,-1===M(U,e)&&U.push(e);const n=r.CesiumMath.toRadians(180*j.getFloat64(t,!0));t+=C,-1===M(Y,n)&&Y.push(n),t+=2*C;let i=j.getInt32(t,!0);t+=f,$+=i,i=j.getInt32(t,!0),tt+=3*i,Z+=Q+E}const et=[],nt=[],it=new Array($),ot=new Array($),rt=new Array($),at=A?new Array($):[],st=G?new Array($):[],ct=new Array(tt),ut=[],ht=[],dt=[],lt=[];let gt=0,mt=0;for(Z=0,X=0;X<4;++X){Q=j.getUint32(Z,!0),Z+=E;const t=Z,e=r.CesiumMath.toRadians(180*j.getFloat64(Z,!0));Z+=C;const i=r.CesiumMath.toRadians(180*j.getFloat64(Z,!0));Z+=C;const o=r.CesiumMath.toRadians(180*j.getFloat64(Z,!0)),a=.5*o;Z+=C;const u=r.CesiumMath.toRadians(180*j.getFloat64(Z,!0)),h=.5*u;Z+=C;const l=j.getInt32(Z,!0);Z+=f;const g=j.getInt32(Z,!0);Z+=f,Z+=f;const m=new Array(l);for(let t=0;t<l;++t){const s=e+j.getUint8(Z++)*o;x.longitude=s;const l=i+j.getUint8(Z++)*u;x.latitude=l;let g=j.getFloat32(Z,!0);if(Z+=T,0!==g&&g<R&&(g*=-Math.pow(2,y)),g*=6371010,x.height=g,-1!==M(U,s)||-1!==M(Y,l)){const e=M(et,x,n.Cartographic);if(-1!==e){m[t]=nt[e];continue}et.push(n.Cartographic.clone(x)),nt.push(gt)}m[t]=gt,Math.abs(s-_)<a?ut.push({index:gt,cartographic:n.Cartographic.clone(x)}):Math.abs(s-v)<a?dt.push({index:gt,cartographic:n.Cartographic.clone(x)}):Math.abs(l-W)<h?ht.push({index:gt,cartographic:n.Cartographic.clone(x)}):Math.abs(l-F)<h&&lt.push({index:gt,cartographic:n.Cartographic.clone(x)}),z=Math.min(g,z),q=Math.max(g,q),rt[gt]=g;const p=d.cartographicToCartesian(x);if(it[gt]=p,A&&(at[gt]=(c.WebMercatorProjection.geodeticLatitudeToMercatorAngle(l)-L)*D),G){const t=d.geodeticSurfaceNormal(p);st[gt]=t}n.Matrix4.multiplyByPoint(H,p,N),n.Cartesian3.minimumByComponent(N,J,J),n.Cartesian3.maximumByComponent(N,K,K);let I=(s-_)/(v-_);I=r.CesiumMath.clamp(I,0,1);let f=(l-W)/(F-W);f=r.CesiumMath.clamp(f,0,1),ot[gt]=new n.Cartesian2(I,f),++gt}const p=3*g;for(let t=0;t<p;++t,++mt)ct[mt]=m[j.getUint16(Z,!0)],Z+=I;if(Q!==Z-t)throw new s.RuntimeError("Invalid terrain tile.")}it.length=gt,ot.length=gt,rt.length=gt,A&&(at.length=gt);G&&(st.length=gt);const pt=gt,It=mt,ft={hMin:z,lastBorderPoint:void 0,skirtHeight:P,toENU:H,ellipsoid:d,minimum:J,maximum:K};ut.sort((function(t,e){return e.cartographic.latitude-t.cartographic.latitude})),ht.sort((function(t,e){return t.cartographic.longitude-e.cartographic.longitude})),dt.sort((function(t,e){return t.cartographic.latitude-e.cartographic.latitude})),lt.sort((function(t,e){return e.cartographic.longitude-t.cartographic.longitude}));const Et=1e-5;if(B(it,rt,ot,at,st,ct,ft,ut,-Et*O,!0,-Et*V),B(it,rt,ot,at,st,ct,ft,ht,-Et*V,!1),B(it,rt,ot,at,st,ct,ft,dt,Et*O,!0,Et*V),B(it,rt,ot,at,st,ct,ft,lt,Et*V,!1),ut.length>0&&lt.length>0){const t=ut[0].index,e=pt,n=lt[lt.length-1].index,i=it.length-1;ct.push(n,i,e,e,t,n)}$=it.length;const Tt=e.BoundingSphere.fromPoints(it);let Ct;i.defined(l)&&(Ct=a.OrientedBoundingBox.fromRectangle(l,z,q,d));const Mt=new o.EllipsoidalOccluder(d).computeHorizonCullingPointPossiblyUnderEllipsoid(h,it,z),xt=new t.AxisAlignedBoundingBox(J,K,h),Nt=new o.TerrainEncoding(h,xt,ft.hMin,q,k,!1,A,G,m,p),bt=new Float32Array($*Nt.stride);let St=0;for(let t=0;t<$;++t)St=Nt.encode(bt,St,it[t],ot[t],rt[t],void 0,at[t],st[t]);const wt=ut.map((function(t){return t.index})).reverse(),Bt=ht.map((function(t){return t.index})).reverse(),Pt=dt.map((function(t){return t.index})).reverse(),At=lt.map((function(t){return t.index})).reverse();return Bt.unshift(Pt[Pt.length-1]),Bt.push(wt[0]),At.unshift(wt[wt.length-1]),At.push(Pt[0]),{vertices:bt,indices:new Uint16Array(ct),maximumHeight:q,minimumHeight:z,encoding:Nt,boundingSphere3D:Tt,orientedBoundingBox:Ct,occludeePointInScaledSpace:Mt,vertexCountWithoutSkirts:pt,indexCountWithoutSkirts:It,westIndicesSouthToNorth:wt,southIndicesEastToWest:Bt,eastIndicesNorthToSouth:Pt,northIndicesWestToEast:At}}(u.buffer,u.relativeToCenter,u.ellipsoid,u.rectangle,u.nativeRectangle,u.exaggeration,u.exaggerationRelativeHeight,u.skirtHeight,u.includeWebMercatorT,u.negativeAltitudeExponentBias,u.negativeElevationThreshold),l=d.vertices;h.push(l.buffer);const g=d.indices;return h.push(g.buffer),{vertices:l.buffer,indices:g.buffer,numberOfAttributes:d.encoding.stride,minimumHeight:d.minimumHeight,maximumHeight:d.maximumHeight,boundingSphere3D:d.boundingSphere3D,orientedBoundingBox:d.orientedBoundingBox,occludeePointInScaledSpace:d.occludeePointInScaledSpace,encoding:d.encoding,vertexCountWithoutSkirts:d.vertexCountWithoutSkirts,indexCountWithoutSkirts:d.indexCountWithoutSkirts,westIndicesSouthToNorth:d.westIndicesSouthToNorth,southIndicesEastToWest:d.southIndicesEastToWest,eastIndicesNorthToSouth:d.eastIndicesNorthToSouth,northIndicesWestToEast:d.northIndicesWestToEast}}))}));
