/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./defaultValue-65031fc5","./Matrix2-c339372d","./Transforms-a48d25e5","./ComponentDatatype-1b227f17","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./GeometryOffsetAttribute-026030ef","./IndexDatatype-53de8b23","./PolygonPipeline-d06990ae","./RectangleGeometryLibrary-f26d5ef8","./RuntimeError-23f4777c","./combine-96aed74b","./WebGLConstants-f5c279b9","./EllipsoidRhumbLine-0df6bb40"],(function(e,t,i,n,o,a,r,l,s,u,c,d,p,f){"use strict";const g=new i.BoundingSphere,h=new i.BoundingSphere,y=new t.Cartesian3,m=new t.Rectangle;function b(e,t){const i=e._ellipsoid,r=t.height,s=t.width,c=t.northCap,d=t.southCap;let p=r,f=2,g=0,h=4;c&&(f-=1,p-=1,g+=1,h-=2),d&&(f-=1,p-=1,g+=1,h-=2),g+=f*s+2*p-h;const m=new Float64Array(3*g);let b,_=0,E=0;const A=y;if(c)u.RectangleGeometryLibrary.computePosition(t,i,!1,E,0,A),m[_++]=A.x,m[_++]=A.y,m[_++]=A.z;else for(b=0;b<s;b++)u.RectangleGeometryLibrary.computePosition(t,i,!1,E,b,A),m[_++]=A.x,m[_++]=A.y,m[_++]=A.z;for(b=s-1,E=1;E<r;E++)u.RectangleGeometryLibrary.computePosition(t,i,!1,E,b,A),m[_++]=A.x,m[_++]=A.y,m[_++]=A.z;if(E=r-1,!d)for(b=s-2;b>=0;b--)u.RectangleGeometryLibrary.computePosition(t,i,!1,E,b,A),m[_++]=A.x,m[_++]=A.y,m[_++]=A.z;for(b=0,E=r-2;E>0;E--)u.RectangleGeometryLibrary.computePosition(t,i,!1,E,b,A),m[_++]=A.x,m[_++]=A.y,m[_++]=A.z;const G=m.length/3*2,R=l.IndexDatatype.createTypedArray(m.length/3,G);let P=0;for(let e=0;e<m.length/3-1;e++)R[P++]=e,R[P++]=e+1;R[P++]=m.length/3-1,R[P++]=0;const L=new o.Geometry({attributes:new a.GeometryAttributes,primitiveType:o.PrimitiveType.LINES});return L.attributes.position=new o.GeometryAttribute({componentDatatype:n.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:m}),L.indices=R,L}function _(i){const o=(i=e.defaultValue(i,e.defaultValue.EMPTY_OBJECT)).rectangle,a=e.defaultValue(i.granularity,n.CesiumMath.RADIANS_PER_DEGREE),r=e.defaultValue(i.ellipsoid,t.Ellipsoid.WGS84),l=e.defaultValue(i.rotation,0),s=e.defaultValue(i.height,0),u=e.defaultValue(i.extrudedHeight,s);this._rectangle=t.Rectangle.clone(o),this._granularity=a,this._ellipsoid=r,this._surfaceHeight=Math.max(s,u),this._rotation=l,this._extrudedHeight=Math.min(s,u),this._offsetAttribute=i.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}_.packedLength=t.Rectangle.packedLength+t.Ellipsoid.packedLength+5,_.pack=function(i,n,o){return o=e.defaultValue(o,0),t.Rectangle.pack(i._rectangle,n,o),o+=t.Rectangle.packedLength,t.Ellipsoid.pack(i._ellipsoid,n,o),o+=t.Ellipsoid.packedLength,n[o++]=i._granularity,n[o++]=i._surfaceHeight,n[o++]=i._rotation,n[o++]=i._extrudedHeight,n[o]=e.defaultValue(i._offsetAttribute,-1),n};const E=new t.Rectangle,A=t.Ellipsoid.clone(t.Ellipsoid.UNIT_SPHERE),G={rectangle:E,ellipsoid:A,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};_.unpack=function(i,n,o){n=e.defaultValue(n,0);const a=t.Rectangle.unpack(i,n,E);n+=t.Rectangle.packedLength;const r=t.Ellipsoid.unpack(i,n,A);n+=t.Ellipsoid.packedLength;const l=i[n++],s=i[n++],u=i[n++],c=i[n++],d=i[n];return e.defined(o)?(o._rectangle=t.Rectangle.clone(a,o._rectangle),o._ellipsoid=t.Ellipsoid.clone(r,o._ellipsoid),o._surfaceHeight=s,o._rotation=u,o._extrudedHeight=c,o._offsetAttribute=-1===d?void 0:d,o):(G.granularity=l,G.height=s,G.rotation=u,G.extrudedHeight=c,G.offsetAttribute=-1===d?void 0:d,new _(G))};const R=new t.Cartographic;return _.createGeometry=function(t){const a=t._rectangle,c=t._ellipsoid,d=u.RectangleGeometryLibrary.computeOptions(a,t._granularity,t._rotation,0,m,R);let p,f;if(n.CesiumMath.equalsEpsilon(a.north,a.south,n.CesiumMath.EPSILON10)||n.CesiumMath.equalsEpsilon(a.east,a.west,n.CesiumMath.EPSILON10))return;const y=t._surfaceHeight,_=t._extrudedHeight;let E;if(!n.CesiumMath.equalsEpsilon(y,_,0,n.CesiumMath.EPSILON2)){if(p=function(e,t){const i=e._surfaceHeight,n=e._extrudedHeight,o=e._ellipsoid,a=n,r=i,u=b(e,t),c=t.height,d=t.width,p=s.PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,r,o,!1);let f=p.length;const g=new Float64Array(2*f);g.set(p);const h=s.PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,a,o);g.set(h,f),u.attributes.position.values=g;const y=t.northCap,m=t.southCap;let _=4;y&&(_-=1),m&&(_-=1);const E=2*(g.length/3+_),A=l.IndexDatatype.createTypedArray(g.length/3,E);f=g.length/6;let G,R=0;for(let e=0;e<f-1;e++)A[R++]=e,A[R++]=e+1,A[R++]=e+f,A[R++]=e+f+1;if(A[R++]=f-1,A[R++]=0,A[R++]=f+f-1,A[R++]=f,A[R++]=0,A[R++]=f,y)G=c-1;else{const e=d-1;A[R++]=e,A[R++]=e+f,G=d+c-2}if(A[R++]=G,A[R++]=G+f,!m){const e=d+G-1;A[R++]=e,A[R]=e+f}return u.indices=A,u}(t,d),e.defined(t._offsetAttribute)){const e=p.attributes.position.values.length/3;let i=new Uint8Array(e);t._offsetAttribute===r.GeometryOffsetAttribute.TOP?i=i.fill(1,0,e/2):(E=t._offsetAttribute===r.GeometryOffsetAttribute.NONE?0:1,i=i.fill(E)),p.attributes.applyOffset=new o.GeometryAttribute({componentDatatype:n.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}const u=i.BoundingSphere.fromRectangle3D(a,c,y,h),m=i.BoundingSphere.fromRectangle3D(a,c,_,g);f=i.BoundingSphere.union(u,m)}else{if(p=b(t,d),p.attributes.position.values=s.PolygonPipeline.scaleToGeodeticHeight(p.attributes.position.values,y,c,!1),e.defined(t._offsetAttribute)){const e=p.attributes.position.values.length;E=t._offsetAttribute===r.GeometryOffsetAttribute.NONE?0:1;const i=new Uint8Array(e/3).fill(E);p.attributes.applyOffset=new o.GeometryAttribute({componentDatatype:n.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}f=i.BoundingSphere.fromRectangle3D(a,c,y)}return new o.Geometry({attributes:p.attributes,indices:p.indices,primitiveType:o.PrimitiveType.LINES,boundingSphere:f,offsetAttribute:t._offsetAttribute})},function(i,n){return e.defined(n)&&(i=_.unpack(i,n)),i._ellipsoid=t.Ellipsoid.clone(i._ellipsoid),i._rectangle=t.Rectangle.clone(i._rectangle),_.createGeometry(i)}}));
