/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./defaultValue-65031fc5","./Matrix2-c339372d","./Transforms-a48d25e5","./ComponentDatatype-1b227f17","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./IndexDatatype-53de8b23","./VertexFormat-2b3ad79f","./WallGeometryLibrary-5dbb88fb","./RuntimeError-23f4777c","./combine-96aed74b","./WebGLConstants-f5c279b9","./arrayRemoveDuplicates-235b23d8","./PolylinePipeline-78c6adf0","./EllipsoidGeodesic-14d277c6","./EllipsoidRhumbLine-0df6bb40","./IntersectionTests-87344d12","./Plane-3d182a08"],(function(e,t,n,i,a,o,r,s,l,m,u,d,p,c,f,y,g,h){"use strict";const b=new t.Cartesian3,C=new t.Cartesian3,x=new t.Cartesian3,A=new t.Cartesian3,_=new t.Cartesian3,E=new t.Cartesian3,w=new t.Cartesian3;function F(n){const a=(n=e.defaultValue(n,e.defaultValue.EMPTY_OBJECT)).positions,o=n.maximumHeights,r=n.minimumHeights,l=e.defaultValue(n.vertexFormat,s.VertexFormat.DEFAULT),m=e.defaultValue(n.granularity,i.CesiumMath.RADIANS_PER_DEGREE),u=e.defaultValue(n.ellipsoid,t.Ellipsoid.WGS84);this._positions=a,this._minimumHeights=r,this._maximumHeights=o,this._vertexFormat=s.VertexFormat.clone(l),this._granularity=m,this._ellipsoid=t.Ellipsoid.clone(u),this._workerName="createWallGeometry";let d=1+a.length*t.Cartesian3.packedLength+2;e.defined(r)&&(d+=r.length),e.defined(o)&&(d+=o.length),this.packedLength=d+t.Ellipsoid.packedLength+s.VertexFormat.packedLength+1}F.pack=function(n,i,a){let o;a=e.defaultValue(a,0);const r=n._positions;let l=r.length;for(i[a++]=l,o=0;o<l;++o,a+=t.Cartesian3.packedLength)t.Cartesian3.pack(r[o],i,a);const m=n._minimumHeights;if(l=e.defined(m)?m.length:0,i[a++]=l,e.defined(m))for(o=0;o<l;++o)i[a++]=m[o];const u=n._maximumHeights;if(l=e.defined(u)?u.length:0,i[a++]=l,e.defined(u))for(o=0;o<l;++o)i[a++]=u[o];return t.Ellipsoid.pack(n._ellipsoid,i,a),a+=t.Ellipsoid.packedLength,s.VertexFormat.pack(n._vertexFormat,i,a),i[a+=s.VertexFormat.packedLength]=n._granularity,i};const v=t.Ellipsoid.clone(t.Ellipsoid.UNIT_SPHERE),L=new s.VertexFormat,V={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:v,vertexFormat:L,granularity:void 0};return F.unpack=function(n,i,a){let o;i=e.defaultValue(i,0);let r=n[i++];const l=new Array(r);for(o=0;o<r;++o,i+=t.Cartesian3.packedLength)l[o]=t.Cartesian3.unpack(n,i);let m,u;if(r=n[i++],r>0)for(m=new Array(r),o=0;o<r;++o)m[o]=n[i++];if(r=n[i++],r>0)for(u=new Array(r),o=0;o<r;++o)u[o]=n[i++];const d=t.Ellipsoid.unpack(n,i,v);i+=t.Ellipsoid.packedLength;const p=s.VertexFormat.unpack(n,i,L),c=n[i+=s.VertexFormat.packedLength];return e.defined(a)?(a._positions=l,a._minimumHeights=m,a._maximumHeights=u,a._ellipsoid=t.Ellipsoid.clone(d,a._ellipsoid),a._vertexFormat=s.VertexFormat.clone(p,a._vertexFormat),a._granularity=c,a):(V.positions=l,V.minimumHeights=m,V.maximumHeights=u,V.granularity=c,new F(V))},F.fromConstantHeights=function(t){const n=(t=e.defaultValue(t,e.defaultValue.EMPTY_OBJECT)).positions;let i,a;const o=t.minimumHeight,r=t.maximumHeight,s=e.defined(o),l=e.defined(r);if(s||l){const e=n.length;i=s?new Array(e):void 0,a=l?new Array(e):void 0;for(let t=0;t<e;++t)s&&(i[t]=o),l&&(a[t]=r)}return new F({positions:n,maximumHeights:a,minimumHeights:i,ellipsoid:t.ellipsoid,vertexFormat:t.vertexFormat})},F.createGeometry=function(s){const m=s._positions,u=s._minimumHeights,d=s._maximumHeights,p=s._vertexFormat,c=s._granularity,f=s._ellipsoid,y=l.WallGeometryLibrary.computePositions(f,m,d,u,c,!0);if(!e.defined(y))return;const g=y.bottomPositions,h=y.topPositions,F=y.numCorners;let v=h.length,L=2*v;const V=p.position?new Float64Array(L):void 0,k=p.normal?new Float32Array(L):void 0,H=p.tangent?new Float32Array(L):void 0,G=p.bitangent?new Float32Array(L):void 0,D=p.st?new Float32Array(L/3*2):void 0;let P,T=0,z=0,O=0,R=0,S=0,I=w,N=E,M=_,W=!0;v/=3;let B=0;const U=1/(v-F-1);for(P=0;P<v;++P){const e=3*P,n=t.Cartesian3.fromArray(h,e,b),a=t.Cartesian3.fromArray(g,e,C);if(p.position&&(V[T++]=a.x,V[T++]=a.y,V[T++]=a.z,V[T++]=n.x,V[T++]=n.y,V[T++]=n.z),p.st&&(D[S++]=B,D[S++]=0,D[S++]=B,D[S++]=1),p.normal||p.tangent||p.bitangent){let a=t.Cartesian3.clone(t.Cartesian3.ZERO,A);const o=t.Cartesian3.subtract(n,f.geodeticSurfaceNormal(n,C),C);if(P+1<v&&(a=t.Cartesian3.fromArray(h,e+3,A)),W){const e=t.Cartesian3.subtract(a,n,x),i=t.Cartesian3.subtract(o,n,b);I=t.Cartesian3.normalize(t.Cartesian3.cross(i,e,I),I),W=!1}t.Cartesian3.equalsEpsilon(n,a,i.CesiumMath.EPSILON10)?W=!0:(B+=U,p.tangent&&(N=t.Cartesian3.normalize(t.Cartesian3.subtract(a,n,N),N)),p.bitangent&&(M=t.Cartesian3.normalize(t.Cartesian3.cross(I,N,M),M))),p.normal&&(k[z++]=I.x,k[z++]=I.y,k[z++]=I.z,k[z++]=I.x,k[z++]=I.y,k[z++]=I.z),p.tangent&&(H[R++]=N.x,H[R++]=N.y,H[R++]=N.z,H[R++]=N.x,H[R++]=N.y,H[R++]=N.z),p.bitangent&&(G[O++]=M.x,G[O++]=M.y,G[O++]=M.z,G[O++]=M.x,G[O++]=M.y,G[O++]=M.z)}}const q=new o.GeometryAttributes;p.position&&(q.position=new a.GeometryAttribute({componentDatatype:i.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:V})),p.normal&&(q.normal=new a.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:k})),p.tangent&&(q.tangent=new a.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:H})),p.bitangent&&(q.bitangent=new a.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:G})),p.st&&(q.st=new a.GeometryAttribute({componentDatatype:i.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:D}));const J=L/3;L-=6*(F+1);const Y=r.IndexDatatype.createTypedArray(J,L);let Z=0;for(P=0;P<J-2;P+=2){const e=P,n=P+2,a=t.Cartesian3.fromArray(V,3*e,b),o=t.Cartesian3.fromArray(V,3*n,C);if(t.Cartesian3.equalsEpsilon(a,o,i.CesiumMath.EPSILON10))continue;const r=P+1,s=P+3;Y[Z++]=r,Y[Z++]=e,Y[Z++]=s,Y[Z++]=s,Y[Z++]=e,Y[Z++]=n}return new a.Geometry({attributes:q,indices:Y,primitiveType:a.PrimitiveType.TRIANGLES,boundingSphere:new n.BoundingSphere.fromVertices(V)})},function(n,i){return e.defined(i)&&(n=F.unpack(n,i)),n._ellipsoid=t.Ellipsoid.clone(n._ellipsoid),F.createGeometry(n)}}));
