/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./arrayRemoveDuplicates-235b23d8","./Transforms-a48d25e5","./Matrix2-c339372d","./ComponentDatatype-1b227f17","./PolylineVolumeGeometryLibrary-b3408464","./CorridorGeometryLibrary-ada59ce8","./defaultValue-65031fc5","./GeometryAttribute-5db26912","./GeometryAttributes-f9b563d6","./GeometryOffsetAttribute-026030ef","./IndexDatatype-53de8b23","./PolygonPipeline-d06990ae","./VertexFormat-2b3ad79f","./combine-96aed74b","./RuntimeError-23f4777c","./WebGLConstants-f5c279b9","./EllipsoidTangentPlane-1f1eb3e6","./AxisAlignedBoundingBox-f07e0e43","./IntersectionTests-87344d12","./Plane-3d182a08","./PolylinePipeline-78c6adf0","./EllipsoidGeodesic-14d277c6","./EllipsoidRhumbLine-0df6bb40"],(function(t,e,r,a,i,o,n,s,l,d,u,m,c,f,y,p,g,h,b,C,A,_,w){"use strict";const v=new r.Cartesian3,T=new r.Cartesian3,G=new r.Cartesian3,E=new r.Cartesian3,V=new r.Cartesian3,x=new r.Cartesian3,L=new r.Cartesian3,P=new r.Cartesian3;function F(t,e){for(let r=0;r<t.length;r++)t[r]=e.scaleToGeodeticSurface(t[r],t[r]);return t}function N(t,e,a,i,n,s){const l=t.normals,d=t.tangents,u=t.bitangents,m=r.Cartesian3.normalize(r.Cartesian3.cross(a,e,L),L);s.normal&&o.CorridorGeometryLibrary.addAttribute(l,e,i,n),s.tangent&&o.CorridorGeometryLibrary.addAttribute(d,m,i,n),s.bitangent&&o.CorridorGeometryLibrary.addAttribute(u,a,i,n)}function D(t,e,i){const d=t.positions,m=t.corners,c=t.endPositions,f=t.lefts,y=t.normals,p=new l.GeometryAttributes;let g,h,b,C=0,A=0,_=0;for(h=0;h<d.length;h+=2)b=d[h].length-3,C+=b,_+=2*b,A+=d[h+1].length-3;for(C+=3,A+=3,h=0;h<m.length;h++){g=m[h];const t=m[h].leftPositions;n.defined(t)?(b=t.length,C+=b,_+=b):(b=m[h].rightPositions.length,A+=b,_+=b)}const w=n.defined(c);let V;w&&(V=c[0].length-3,C+=V,A+=V,V/=3,_+=6*V);const F=C+A,D=new Float64Array(F),M={normals:e.normal?new Float32Array(F):void 0,tangents:e.tangent?new Float32Array(F):void 0,bitangents:e.bitangent?new Float32Array(F):void 0};let O,I,S,R,k,H,z=0,B=F-1,U=v,Y=T;const W=V/2,q=u.IndexDatatype.createTypedArray(F/3,_);let J=0;if(w){H=G,k=E;const t=c[0];for(U=r.Cartesian3.fromArray(y,0,U),Y=r.Cartesian3.fromArray(f,0,Y),h=0;h<W;h++)H=r.Cartesian3.fromArray(t,3*(W-1-h),H),k=r.Cartesian3.fromArray(t,3*(W+h),k),o.CorridorGeometryLibrary.addAttribute(D,k,z),o.CorridorGeometryLibrary.addAttribute(D,H,void 0,B),N(M,U,Y,z,B,e),I=z/3,R=I+1,O=(B-2)/3,S=O-1,q[J++]=O,q[J++]=I,q[J++]=S,q[J++]=S,q[J++]=I,q[J++]=R,z+=3,B-=3}let j,K,Q=0,X=0,Z=d[Q++],$=d[Q++];for(D.set(Z,z),D.set($,B-$.length+1),Y=r.Cartesian3.fromArray(f,X,Y),b=$.length-3,h=0;h<b;h+=3)j=i.geodeticSurfaceNormal(r.Cartesian3.fromArray(Z,h,L),L),K=i.geodeticSurfaceNormal(r.Cartesian3.fromArray($,b-h,P),P),U=r.Cartesian3.normalize(r.Cartesian3.add(j,K,U),U),N(M,U,Y,z,B,e),I=z/3,R=I+1,O=(B-2)/3,S=O-1,q[J++]=O,q[J++]=I,q[J++]=S,q[J++]=S,q[J++]=I,q[J++]=R,z+=3,B-=3;for(j=i.geodeticSurfaceNormal(r.Cartesian3.fromArray(Z,b,L),L),K=i.geodeticSurfaceNormal(r.Cartesian3.fromArray($,b,P),P),U=r.Cartesian3.normalize(r.Cartesian3.add(j,K,U),U),X+=3,h=0;h<m.length;h++){let t;g=m[h];const a=g.leftPositions,s=g.rightPositions;let l,u,c=x,p=G,C=E;if(U=r.Cartesian3.fromArray(y,X,U),n.defined(a)){for(N(M,U,Y,void 0,B,e),B-=3,l=R,u=S,t=0;t<a.length/3;t++)c=r.Cartesian3.fromArray(a,3*t,c),q[J++]=l,q[J++]=u-t-1,q[J++]=u-t,o.CorridorGeometryLibrary.addAttribute(D,c,void 0,B),p=r.Cartesian3.fromArray(D,3*(u-t-1),p),C=r.Cartesian3.fromArray(D,3*l,C),Y=r.Cartesian3.normalize(r.Cartesian3.subtract(p,C,Y),Y),N(M,U,Y,void 0,B,e),B-=3;c=r.Cartesian3.fromArray(D,3*l,c),p=r.Cartesian3.subtract(r.Cartesian3.fromArray(D,3*u,p),c,p),C=r.Cartesian3.subtract(r.Cartesian3.fromArray(D,3*(u-t),C),c,C),Y=r.Cartesian3.normalize(r.Cartesian3.add(p,C,Y),Y),N(M,U,Y,z,void 0,e),z+=3}else{for(N(M,U,Y,z,void 0,e),z+=3,l=S,u=R,t=0;t<s.length/3;t++)c=r.Cartesian3.fromArray(s,3*t,c),q[J++]=l,q[J++]=u+t,q[J++]=u+t+1,o.CorridorGeometryLibrary.addAttribute(D,c,z),p=r.Cartesian3.fromArray(D,3*l,p),C=r.Cartesian3.fromArray(D,3*(u+t),C),Y=r.Cartesian3.normalize(r.Cartesian3.subtract(p,C,Y),Y),N(M,U,Y,z,void 0,e),z+=3;c=r.Cartesian3.fromArray(D,3*l,c),p=r.Cartesian3.subtract(r.Cartesian3.fromArray(D,3*(u+t),p),c,p),C=r.Cartesian3.subtract(r.Cartesian3.fromArray(D,3*u,C),c,C),Y=r.Cartesian3.normalize(r.Cartesian3.negate(r.Cartesian3.add(C,p,Y),Y),Y),N(M,U,Y,void 0,B,e),B-=3}for(Z=d[Q++],$=d[Q++],Z.splice(0,3),$.splice($.length-3,3),D.set(Z,z),D.set($,B-$.length+1),b=$.length-3,X+=3,Y=r.Cartesian3.fromArray(f,X,Y),t=0;t<$.length;t+=3)j=i.geodeticSurfaceNormal(r.Cartesian3.fromArray(Z,t,L),L),K=i.geodeticSurfaceNormal(r.Cartesian3.fromArray($,b-t,P),P),U=r.Cartesian3.normalize(r.Cartesian3.add(j,K,U),U),N(M,U,Y,z,B,e),R=z/3,I=R-1,S=(B-2)/3,O=S+1,q[J++]=O,q[J++]=I,q[J++]=S,q[J++]=S,q[J++]=I,q[J++]=R,z+=3,B-=3;z-=3,B+=3}if(U=r.Cartesian3.fromArray(y,y.length-3,U),N(M,U,Y,z,B,e),w){z+=3,B-=3,H=G,k=E;const t=c[1];for(h=0;h<W;h++)H=r.Cartesian3.fromArray(t,3*(V-h-1),H),k=r.Cartesian3.fromArray(t,3*h,k),o.CorridorGeometryLibrary.addAttribute(D,H,void 0,B),o.CorridorGeometryLibrary.addAttribute(D,k,z),N(M,U,Y,z,B,e),R=z/3,I=R-1,S=(B-2)/3,O=S+1,q[J++]=O,q[J++]=I,q[J++]=S,q[J++]=S,q[J++]=I,q[J++]=R,z+=3,B-=3}if(p.position=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:D}),e.st){const t=new Float32Array(F/3*2);let e,r,i=0;if(w){C/=3,A/=3;const o=Math.PI/(V+1);let n;r=1/(C-V+1),e=1/(A-V+1);const s=V/2;for(h=s+1;h<V+1;h++)n=a.CesiumMath.PI_OVER_TWO+o*h,t[i++]=e*(1+Math.cos(n)),t[i++]=.5*(1+Math.sin(n));for(h=1;h<A-V+1;h++)t[i++]=h*e,t[i++]=0;for(h=V;h>s;h--)n=a.CesiumMath.PI_OVER_TWO-h*o,t[i++]=1-e*(1+Math.cos(n)),t[i++]=.5*(1+Math.sin(n));for(h=s;h>0;h--)n=a.CesiumMath.PI_OVER_TWO-o*h,t[i++]=1-r*(1+Math.cos(n)),t[i++]=.5*(1+Math.sin(n));for(h=C-V;h>0;h--)t[i++]=h*r,t[i++]=1;for(h=1;h<s+1;h++)n=a.CesiumMath.PI_OVER_TWO+o*h,t[i++]=r*(1+Math.cos(n)),t[i++]=.5*(1+Math.sin(n))}else{for(C/=3,A/=3,r=1/(C-1),e=1/(A-1),h=0;h<A;h++)t[i++]=h*e,t[i++]=0;for(h=C;h>0;h--)t[i++]=(h-1)*r,t[i++]=1}p.st=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:t})}return e.normal&&(p.normal=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:M.normals})),e.tangent&&(p.tangent=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:M.tangents})),e.bitangent&&(p.bitangent=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:M.bitangents})),{attributes:p,indices:q}}function M(t,e,r){r[e++]=t[0],r[e++]=t[1],r[e++]=t[2];for(let a=3;a<t.length;a+=3){const i=t[a],o=t[a+1],n=t[a+2];r[e++]=i,r[e++]=o,r[e++]=n,r[e++]=i,r[e++]=o,r[e++]=n}return r[e++]=t[0],r[e++]=t[1],r[e++]=t[2],r}function O(t,e){const i=new c.VertexFormat({position:e.position,normal:e.normal||e.bitangent||t.shadowVolume,tangent:e.tangent,bitangent:e.normal||e.bitangent,st:e.st}),l=t.ellipsoid,f=D(o.CorridorGeometryLibrary.computePositions(t),i,l),y=t.height,p=t.extrudedHeight;let g=f.attributes;const h=f.indices;let b=g.position.values,C=b.length;const A=new Float64Array(6*C);let _=new Float64Array(C);_.set(b);let w,L=new Float64Array(4*C);b=m.PolygonPipeline.scaleToGeodeticHeight(b,y,l),L=M(b,0,L),_=m.PolygonPipeline.scaleToGeodeticHeight(_,p,l),L=M(_,2*C,L),A.set(b),A.set(_,C),A.set(L,2*C),g.position.values=A,g=function(t,e){if(!(e.normal||e.tangent||e.bitangent||e.st))return t;const a=t.position.values;let i,n;(e.normal||e.bitangent)&&(i=t.normal.values,n=t.bitangent.values);const s=t.position.values.length/18,l=3*s,d=2*s,u=2*l;let m;if(e.normal||e.bitangent||e.tangent){const s=e.normal?new Float32Array(6*l):void 0,d=e.tangent?new Float32Array(6*l):void 0,c=e.bitangent?new Float32Array(6*l):void 0;let f=v,y=T,p=G,g=E,h=V,b=x,C=u;for(m=0;m<l;m+=3){const t=C+u;f=r.Cartesian3.fromArray(a,m,f),y=r.Cartesian3.fromArray(a,m+l,y),p=r.Cartesian3.fromArray(a,(m+3)%l,p),y=r.Cartesian3.subtract(y,f,y),p=r.Cartesian3.subtract(p,f,p),g=r.Cartesian3.normalize(r.Cartesian3.cross(y,p,g),g),e.normal&&(o.CorridorGeometryLibrary.addAttribute(s,g,t),o.CorridorGeometryLibrary.addAttribute(s,g,t+3),o.CorridorGeometryLibrary.addAttribute(s,g,C),o.CorridorGeometryLibrary.addAttribute(s,g,C+3)),(e.tangent||e.bitangent)&&(b=r.Cartesian3.fromArray(i,m,b),e.bitangent&&(o.CorridorGeometryLibrary.addAttribute(c,b,t),o.CorridorGeometryLibrary.addAttribute(c,b,t+3),o.CorridorGeometryLibrary.addAttribute(c,b,C),o.CorridorGeometryLibrary.addAttribute(c,b,C+3)),e.tangent&&(h=r.Cartesian3.normalize(r.Cartesian3.cross(b,g,h),h),o.CorridorGeometryLibrary.addAttribute(d,h,t),o.CorridorGeometryLibrary.addAttribute(d,h,t+3),o.CorridorGeometryLibrary.addAttribute(d,h,C),o.CorridorGeometryLibrary.addAttribute(d,h,C+3))),C+=6}if(e.normal){for(s.set(i),m=0;m<l;m+=3)s[m+l]=-i[m],s[m+l+1]=-i[m+1],s[m+l+2]=-i[m+2];t.normal.values=s}else t.normal=void 0;if(e.bitangent?(c.set(n),c.set(n,l),t.bitangent.values=c):t.bitangent=void 0,e.tangent){const e=t.tangent.values;d.set(e),d.set(e,l),t.tangent.values=d}}if(e.st){const e=t.st.values,r=new Float32Array(6*d);r.set(e),r.set(e,d);let a=2*d;for(let t=0;t<2;t++){for(r[a++]=e[0],r[a++]=e[1],m=2;m<d;m+=2){const t=e[m],i=e[m+1];r[a++]=t,r[a++]=i,r[a++]=t,r[a++]=i}r[a++]=e[0],r[a++]=e[1]}t.st.values=r}return t}(g,e);const P=C/3;if(t.shadowVolume){const t=g.normal.values;C=t.length;let r=new Float32Array(6*C);for(w=0;w<C;w++)t[w]=-t[w];r.set(t,C),r=M(t,4*C,r),g.extrudeDirection=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:r}),e.normal||(g.normal=void 0)}if(n.defined(t.offsetAttribute)){let e=new Uint8Array(6*P);if(t.offsetAttribute===d.GeometryOffsetAttribute.TOP)e=e.fill(1,0,P).fill(1,2*P,4*P);else{const r=t.offsetAttribute===d.GeometryOffsetAttribute.NONE?0:1;e=e.fill(r)}g.applyOffset=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}const F=h.length,N=P+P,O=u.IndexDatatype.createTypedArray(A.length/3,2*F+3*N);O.set(h);let I,S,R,k,H=F;for(w=0;w<F;w+=3){const t=h[w],e=h[w+1],r=h[w+2];O[H++]=r+P,O[H++]=e+P,O[H++]=t+P}for(w=0;w<N;w+=2)I=w+N,S=I+N,R=I+1,k=S+1,O[H++]=I,O[H++]=S,O[H++]=R,O[H++]=R,O[H++]=S,O[H++]=k;return{attributes:g,indices:O}}const I=new r.Cartesian3,S=new r.Cartesian3,R=new r.Cartographic;function k(t,e,a,i,o,n){const s=r.Cartesian3.subtract(e,t,I);r.Cartesian3.normalize(s,s);const l=a.geodeticSurfaceNormal(t,S),d=r.Cartesian3.cross(s,l,I);r.Cartesian3.multiplyByScalar(d,i,d);let u=o.latitude,m=o.longitude,c=n.latitude,f=n.longitude;r.Cartesian3.add(t,d,S),a.cartesianToCartographic(S,R);let y=R.latitude,p=R.longitude;u=Math.min(u,y),m=Math.min(m,p),c=Math.max(c,y),f=Math.max(f,p),r.Cartesian3.subtract(t,d,S),a.cartesianToCartographic(S,R),y=R.latitude,p=R.longitude,u=Math.min(u,y),m=Math.min(m,p),c=Math.max(c,y),f=Math.max(f,p),o.latitude=u,o.longitude=m,n.latitude=c,n.longitude=f}const H=new r.Cartesian3,z=new r.Cartesian3,B=new r.Cartographic,U=new r.Cartographic;function Y(e,a,o,s,l){e=F(e,a);const d=t.arrayRemoveDuplicates(e,r.Cartesian3.equalsEpsilon),u=d.length;if(u<2||o<=0)return new r.Rectangle;const m=.5*o;let c,f;if(B.latitude=Number.POSITIVE_INFINITY,B.longitude=Number.POSITIVE_INFINITY,U.latitude=Number.NEGATIVE_INFINITY,U.longitude=Number.NEGATIVE_INFINITY,s===i.CornerType.ROUNDED){const t=d[0];r.Cartesian3.subtract(t,d[1],H),r.Cartesian3.normalize(H,H),r.Cartesian3.multiplyByScalar(H,m,H),r.Cartesian3.add(t,H,z),a.cartesianToCartographic(z,R),c=R.latitude,f=R.longitude,B.latitude=Math.min(B.latitude,c),B.longitude=Math.min(B.longitude,f),U.latitude=Math.max(U.latitude,c),U.longitude=Math.max(U.longitude,f)}for(let t=0;t<u-1;++t)k(d[t],d[t+1],a,m,B,U);const y=d[u-1];r.Cartesian3.subtract(y,d[u-2],H),r.Cartesian3.normalize(H,H),r.Cartesian3.multiplyByScalar(H,m,H),r.Cartesian3.add(y,H,z),k(y,z,a,m,B,U),s===i.CornerType.ROUNDED&&(a.cartesianToCartographic(z,R),c=R.latitude,f=R.longitude,B.latitude=Math.min(B.latitude,c),B.longitude=Math.min(B.longitude,f),U.latitude=Math.max(U.latitude,c),U.longitude=Math.max(U.longitude,f));const p=n.defined(l)?l:new r.Rectangle;return p.north=U.latitude,p.south=B.latitude,p.east=U.longitude,p.west=B.longitude,p}function W(t){const e=(t=n.defaultValue(t,n.defaultValue.EMPTY_OBJECT)).positions,o=t.width,s=n.defaultValue(t.height,0),l=n.defaultValue(t.extrudedHeight,s);this._positions=e,this._ellipsoid=r.Ellipsoid.clone(n.defaultValue(t.ellipsoid,r.Ellipsoid.WGS84)),this._vertexFormat=c.VertexFormat.clone(n.defaultValue(t.vertexFormat,c.VertexFormat.DEFAULT)),this._width=o,this._height=Math.max(s,l),this._extrudedHeight=Math.min(s,l),this._cornerType=n.defaultValue(t.cornerType,i.CornerType.ROUNDED),this._granularity=n.defaultValue(t.granularity,a.CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=n.defaultValue(t.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=t.offsetAttribute,this._rectangle=void 0,this.packedLength=1+e.length*r.Cartesian3.packedLength+r.Ellipsoid.packedLength+c.VertexFormat.packedLength+7}W.pack=function(t,e,a){a=n.defaultValue(a,0);const i=t._positions,o=i.length;e[a++]=o;for(let t=0;t<o;++t,a+=r.Cartesian3.packedLength)r.Cartesian3.pack(i[t],e,a);return r.Ellipsoid.pack(t._ellipsoid,e,a),a+=r.Ellipsoid.packedLength,c.VertexFormat.pack(t._vertexFormat,e,a),a+=c.VertexFormat.packedLength,e[a++]=t._width,e[a++]=t._height,e[a++]=t._extrudedHeight,e[a++]=t._cornerType,e[a++]=t._granularity,e[a++]=t._shadowVolume?1:0,e[a]=n.defaultValue(t._offsetAttribute,-1),e};const q=r.Ellipsoid.clone(r.Ellipsoid.UNIT_SPHERE),J=new c.VertexFormat,j={positions:void 0,ellipsoid:q,vertexFormat:J,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};return W.unpack=function(t,e,a){e=n.defaultValue(e,0);const i=t[e++],o=new Array(i);for(let a=0;a<i;++a,e+=r.Cartesian3.packedLength)o[a]=r.Cartesian3.unpack(t,e);const s=r.Ellipsoid.unpack(t,e,q);e+=r.Ellipsoid.packedLength;const l=c.VertexFormat.unpack(t,e,J);e+=c.VertexFormat.packedLength;const d=t[e++],u=t[e++],m=t[e++],f=t[e++],y=t[e++],p=1===t[e++],g=t[e];return n.defined(a)?(a._positions=o,a._ellipsoid=r.Ellipsoid.clone(s,a._ellipsoid),a._vertexFormat=c.VertexFormat.clone(l,a._vertexFormat),a._width=d,a._height=u,a._extrudedHeight=m,a._cornerType=f,a._granularity=y,a._shadowVolume=p,a._offsetAttribute=-1===g?void 0:g,a):(j.positions=o,j.width=d,j.height=u,j.extrudedHeight=m,j.cornerType=f,j.granularity=y,j.shadowVolume=p,j.offsetAttribute=-1===g?void 0:g,new W(j))},W.computeRectangle=function(t,e){const a=(t=n.defaultValue(t,n.defaultValue.EMPTY_OBJECT)).positions,o=t.width;return Y(a,n.defaultValue(t.ellipsoid,r.Ellipsoid.WGS84),o,n.defaultValue(t.cornerType,i.CornerType.ROUNDED),e)},W.createGeometry=function(i){let l=i._positions;const u=i._width,c=i._ellipsoid;l=F(l,c);const f=t.arrayRemoveDuplicates(l,r.Cartesian3.equalsEpsilon);if(f.length<2||u<=0)return;const y=i._height,p=i._extrudedHeight,g=!a.CesiumMath.equalsEpsilon(y,p,0,a.CesiumMath.EPSILON2),h=i._vertexFormat,b={ellipsoid:c,positions:f,width:u,cornerType:i._cornerType,granularity:i._granularity,saveAttributes:!0};let C;if(g)b.height=y,b.extrudedHeight=p,b.shadowVolume=i._shadowVolume,b.offsetAttribute=i._offsetAttribute,C=O(b,h);else{if(C=D(o.CorridorGeometryLibrary.computePositions(b),h,c),C.attributes.position.values=m.PolygonPipeline.scaleToGeodeticHeight(C.attributes.position.values,y,c),n.defined(i._offsetAttribute)){const t=i._offsetAttribute===d.GeometryOffsetAttribute.NONE?0:1,e=C.attributes.position.values.length,r=new Uint8Array(e/3).fill(t);C.attributes.applyOffset=new s.GeometryAttribute({componentDatatype:a.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}}const A=C.attributes,_=e.BoundingSphere.fromVertices(A.position.values,void 0,3);return h.position||(C.attributes.position.values=void 0),new s.Geometry({attributes:A,indices:C.indices,primitiveType:s.PrimitiveType.TRIANGLES,boundingSphere:_,offsetAttribute:i._offsetAttribute})},W.createShadowVolume=function(t,e,r){const a=t._granularity,i=t._ellipsoid,o=e(a,i),n=r(a,i);return new W({positions:t._positions,width:t._width,cornerType:t._cornerType,ellipsoid:i,granularity:a,extrudedHeight:o,height:n,vertexFormat:c.VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(W.prototype,{rectangle:{get:function(){return n.defined(this._rectangle)||(this._rectangle=Y(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}}),function(t,e){return n.defined(e)&&(t=W.unpack(t,e)),t._ellipsoid=r.Ellipsoid.clone(t._ellipsoid),W.createGeometry(t)}}));
