/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./Transforms-a48d25e5","./Matrix2-c339372d","./defaultValue-65031fc5","./ComponentDatatype-1b227f17","./ArcType-84fe1b78","./arrayRemoveDuplicates-235b23d8","./EllipsoidGeodesic-14d277c6","./EllipsoidRhumbLine-0df6bb40","./EncodedCartesian3-4e907eba","./GeometryAttribute-5db26912","./IntersectionTests-87344d12","./Plane-3d182a08","./WebMercatorProjection-b33ee193","./combine-96aed74b","./RuntimeError-23f4777c","./WebGLConstants-f5c279b9"],(function(e,t,a,n,i,r,s,o,l,c,u,C,p,d,h,g){"use strict";function f(n){n=a.defaultValue(n,a.defaultValue.EMPTY_OBJECT),this._ellipsoid=a.defaultValue(n.ellipsoid,t.Ellipsoid.WGS84),this._rectangle=a.defaultValue(n.rectangle,t.Rectangle.MAX_VALUE),this._projection=new e.GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=a.defaultValue(n.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=a.defaultValue(n.numberOfLevelZeroTilesY,1)}Object.defineProperties(f.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),f.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},f.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},f.prototype.rectangleToNativeRectangle=function(e,i){const r=n.CesiumMath.toDegrees(e.west),s=n.CesiumMath.toDegrees(e.south),o=n.CesiumMath.toDegrees(e.east),l=n.CesiumMath.toDegrees(e.north);return a.defined(i)?(i.west=r,i.south=s,i.east=o,i.north=l,i):new t.Rectangle(r,s,o,l)},f.prototype.tileXYToNativeRectangle=function(e,t,a,i){const r=this.tileXYToRectangle(e,t,a,i);return r.west=n.CesiumMath.toDegrees(r.west),r.south=n.CesiumMath.toDegrees(r.south),r.east=n.CesiumMath.toDegrees(r.east),r.north=n.CesiumMath.toDegrees(r.north),r},f.prototype.tileXYToRectangle=function(e,n,i,r){const s=this._rectangle,o=this.getNumberOfXTilesAtLevel(i),l=this.getNumberOfYTilesAtLevel(i),c=s.width/o,u=e*c+s.west,C=(e+1)*c+s.west,p=s.height/l,d=s.north-n*p,h=s.north-(n+1)*p;return a.defined(r)||(r=new t.Rectangle(u,h,C,d)),r.west=u,r.south=h,r.east=C,r.north=d,r},f.prototype.positionToTileXY=function(e,i,r){const s=this._rectangle;if(!t.Rectangle.contains(s,e))return;const o=this.getNumberOfXTilesAtLevel(i),l=this.getNumberOfYTilesAtLevel(i),c=s.width/o,u=s.height/l;let C=e.longitude;s.east<s.west&&(C+=n.CesiumMath.TWO_PI);let p=(C-s.west)/c|0;p>=o&&(p=o-1);let d=(s.north-e.latitude)/u|0;return d>=l&&(d=l-1),a.defined(r)?(r.x=p,r.y=d,r):new t.Cartesian2(p,d)};const m=new t.Cartesian3,w=new t.Cartesian3,y=new t.Cartographic,M=new t.Cartesian3,T=new t.Cartesian3,E=new e.BoundingSphere,_=new f,O=[new t.Cartographic,new t.Cartographic,new t.Cartographic,new t.Cartographic],b=new t.Cartesian2,P={};function A(e){t.Cartographic.fromRadians(e.east,e.north,0,O[0]),t.Cartographic.fromRadians(e.west,e.north,0,O[1]),t.Cartographic.fromRadians(e.east,e.south,0,O[2]),t.Cartographic.fromRadians(e.west,e.south,0,O[3]);let a=0,n=0,i=0,r=0;const s=P._terrainHeightsMaxLevel;let o;for(o=0;o<=s;++o){let e=!1;for(let t=0;t<4;++t){const a=O[t];if(_.positionToTileXY(a,o,b),0===t)i=b.x,r=b.y;else if(i!==b.x||r!==b.y){e=!0;break}}if(e)break;a=i,n=r}if(0!==o)return{x:a,y:n,level:o>s?s:o-1}}P.initialize=function(){let t=P._initPromise;return a.defined(t)||(t=e.Resource.fetchJson(e.buildModuleUrl("Assets/approximateTerrainHeights.json")).then((function(e){P._terrainHeights=e})),P._initPromise=t),t},P.getMinimumMaximumHeights=function(e,n){n=a.defaultValue(n,t.Ellipsoid.WGS84);const i=A(e);let r=P._defaultMinTerrainHeight,s=P._defaultMaxTerrainHeight;if(a.defined(i)){const o=`${i.level}-${i.x}-${i.y}`,l=P._terrainHeights[o];a.defined(l)&&(r=l[0],s=l[1]),n.cartographicToCartesian(t.Rectangle.northeast(e,y),m),n.cartographicToCartesian(t.Rectangle.southwest(e,y),w),t.Cartesian3.midpoint(w,m,M);const c=n.scaleToGeodeticSurface(M,T);if(a.defined(c)){const e=t.Cartesian3.distance(M,c);r=Math.min(r,-e)}else r=P._defaultMinTerrainHeight}return r=Math.max(P._defaultMinTerrainHeight,r),{minimumTerrainHeight:r,maximumTerrainHeight:s}},P.getBoundingSphere=function(n,i){i=a.defaultValue(i,t.Ellipsoid.WGS84);const r=A(n);let s=P._defaultMaxTerrainHeight;if(a.defined(r)){const e=`${r.level}-${r.x}-${r.y}`,t=P._terrainHeights[e];a.defined(t)&&(s=t[1])}const o=e.BoundingSphere.fromRectangle3D(n,i,0);return e.BoundingSphere.fromRectangle3D(n,i,s,E),e.BoundingSphere.union(o,E,o)},P._terrainHeightsMaxLevel=6,P._defaultMaxTerrainHeight=9e3,P._defaultMinTerrainHeight=-1e5,P._terrainHeights=void 0,P._initPromise=void 0,Object.defineProperties(P,{initialized:{get:function(){return a.defined(P._terrainHeights)}}});var k=P;const L=[e.GeographicProjection,p.WebMercatorProjection],S=L.length,x=Math.cos(n.CesiumMath.toRadians(30)),I=Math.cos(n.CesiumMath.toRadians(150));function N(e){const n=(e=a.defaultValue(e,a.defaultValue.EMPTY_OBJECT)).positions;this.width=a.defaultValue(e.width,1),this._positions=n,this.granularity=a.defaultValue(e.granularity,9999),this.loop=a.defaultValue(e.loop,!1),this.arcType=a.defaultValue(e.arcType,i.ArcType.GEODESIC),this._ellipsoid=t.Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(N.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+t.Ellipsoid.packedLength+1+1}}}),N.setProjectionAndEllipsoid=function(e,t){let a=0;for(let e=0;e<S;e++)if(t instanceof L[e]){a=e;break}e._projectionIndex=a,e._ellipsoid=t.ellipsoid};const R=new t.Cartesian3,D=new t.Cartesian3,v=new t.Cartesian3;function z(e,a,n,i,r){const s=F(i,e,0,R),o=F(i,e,n,D),l=F(i,a,0,v),c=q(o,s,D),u=q(l,s,v);return t.Cartesian3.cross(u,c,r),t.Cartesian3.normalize(r,r)}const H=new t.Cartographic,B=new t.Cartesian3,V=new t.Cartesian3,j=new t.Cartesian3;function G(e,a,n,r,l,c,u,C,p,d,h){if(0===l)return;let g;c===i.ArcType.GEODESIC?g=new s.EllipsoidGeodesic(e,a,u):c===i.ArcType.RHUMB&&(g=new o.EllipsoidRhumbLine(e,a,u));const f=g.surfaceDistance;if(f<l)return;const m=z(e,a,r,u,j),w=Math.ceil(f/l),y=f/w;let M=y;const T=w-1;let E=C.length;for(let e=0;e<T;e++){const e=g.interpolateUsingSurfaceDistance(M,H),a=F(u,e,n,B),i=F(u,e,r,V);t.Cartesian3.pack(m,C,E),t.Cartesian3.pack(a,p,E),t.Cartesian3.pack(i,d,E),h.push(e.latitude),h.push(e.longitude),E+=3,M+=y}}const Y=new t.Cartographic;function F(e,a,n,i){return t.Cartographic.clone(a,Y),Y.height=n,t.Cartographic.toCartesian(Y,e,i)}function q(e,a,n){return t.Cartesian3.subtract(e,a,n),t.Cartesian3.normalize(n,n),n}function X(e,a,n,i){return i=q(e,a,i),i=t.Cartesian3.cross(i,n,i),i=t.Cartesian3.normalize(i,i),i=t.Cartesian3.cross(n,i,i)}N.pack=function(e,n,i){let r=a.defaultValue(i,0);const s=e._positions,o=s.length;n[r++]=o;for(let e=0;e<o;++e){const a=s[e];t.Cartesian3.pack(a,n,r),r+=3}return n[r++]=e.granularity,n[r++]=e.loop?1:0,n[r++]=e.arcType,t.Ellipsoid.pack(e._ellipsoid,n,r),r+=t.Ellipsoid.packedLength,n[r++]=e._projectionIndex,n[r++]=e._scene3DOnly?1:0,n},N.unpack=function(e,n,i){let r=a.defaultValue(n,0);const s=e[r++],o=new Array(s);for(let a=0;a<s;a++)o[a]=t.Cartesian3.unpack(e,r),r+=3;const l=e[r++],c=1===e[r++],u=e[r++],C=t.Ellipsoid.unpack(e,r);r+=t.Ellipsoid.packedLength;const p=e[r++],d=1===e[r++];return a.defined(i)||(i=new N({positions:o})),i._positions=o,i.granularity=l,i.loop=c,i.arcType=u,i._ellipsoid=C,i._projectionIndex=p,i._scene3DOnly=d,i};const W=new t.Cartesian3,U=new t.Cartesian3,Z=new t.Cartesian3,$=new t.Cartesian3;function J(e,a,i,r,s){const o=q(i,a,$),l=X(e,a,o,W),c=X(r,a,o,U);if(n.CesiumMath.equalsEpsilon(t.Cartesian3.dot(l,c),-1,n.CesiumMath.EPSILON5))return s=t.Cartesian3.cross(o,l,s),s=t.Cartesian3.normalize(s,s);s=t.Cartesian3.add(c,l,s),s=t.Cartesian3.normalize(s,s);const u=t.Cartesian3.cross(o,s,Z);return t.Cartesian3.dot(c,u)<0&&(s=t.Cartesian3.negate(s,s)),s}const Q=C.Plane.fromPointNormal(t.Cartesian3.ZERO,t.Cartesian3.UNIT_Y),K=new t.Cartesian3,ee=new t.Cartesian3,te=new t.Cartesian3,ae=new t.Cartesian3,ne=new t.Cartesian3,ie=new t.Cartesian3,re=new t.Cartographic,se=new t.Cartographic,oe=new t.Cartographic;N.createGeometry=function(s){const C=!s._scene3DOnly;let p=s.loop;const d=s._ellipsoid,h=s.granularity,g=s.arcType,f=new L[s._projectionIndex](d),m=1e3;let w,y;const M=s._positions,T=M.length;let E,_,O,b;2===T&&(p=!1);const P=new o.EllipsoidRhumbLine(void 0,void 0,d);let A,S,I;const N=[M[0]];for(y=0;y<T-1;y++)E=M[y],_=M[y+1],A=u.IntersectionTests.lineSegmentPlane(E,_,Q,ie),!a.defined(A)||t.Cartesian3.equalsEpsilon(A,E,n.CesiumMath.EPSILON7)||t.Cartesian3.equalsEpsilon(A,_,n.CesiumMath.EPSILON7)||(s.arcType===i.ArcType.GEODESIC?N.push(t.Cartesian3.clone(A)):s.arcType===i.ArcType.RHUMB&&(I=d.cartesianToCartographic(A,re).longitude,O=d.cartesianToCartographic(E,re),b=d.cartesianToCartographic(_,se),P.setEndPoints(O,b),S=P.findIntersectionWithLongitude(I,oe),A=d.cartographicToCartesian(S,ie),!a.defined(A)||t.Cartesian3.equalsEpsilon(A,E,n.CesiumMath.EPSILON7)||t.Cartesian3.equalsEpsilon(A,_,n.CesiumMath.EPSILON7)||N.push(t.Cartesian3.clone(A)))),N.push(_);p&&(E=M[T-1],_=M[0],A=u.IntersectionTests.lineSegmentPlane(E,_,Q,ie),!a.defined(A)||t.Cartesian3.equalsEpsilon(A,E,n.CesiumMath.EPSILON7)||t.Cartesian3.equalsEpsilon(A,_,n.CesiumMath.EPSILON7)||(s.arcType===i.ArcType.GEODESIC?N.push(t.Cartesian3.clone(A)):s.arcType===i.ArcType.RHUMB&&(I=d.cartesianToCartographic(A,re).longitude,O=d.cartesianToCartographic(E,re),b=d.cartesianToCartographic(_,se),P.setEndPoints(O,b),S=P.findIntersectionWithLongitude(I,oe),A=d.cartographicToCartesian(S,ie),!a.defined(A)||t.Cartesian3.equalsEpsilon(A,E,n.CesiumMath.EPSILON7)||t.Cartesian3.equalsEpsilon(A,_,n.CesiumMath.EPSILON7)||N.push(t.Cartesian3.clone(A)))));let R=N.length,D=new Array(R);for(y=0;y<R;y++){const e=t.Cartographic.fromCartesian(N[y],d);e.height=0,D[y]=e}if(D=r.arrayRemoveDuplicates(D,t.Cartographic.equalsEpsilon),R=D.length,R<2)return;const v=[],H=[],B=[],V=[];let j=K,Y=ee,X=te,W=ae,U=ne;const Z=D[0],$=D[1];for(j=F(d,D[R-1],0,j),W=F(d,$,0,W),Y=F(d,Z,0,Y),X=F(d,Z,m,X),U=p?J(j,Y,X,W,U):z(Z,$,m,d,U),t.Cartesian3.pack(U,H,0),t.Cartesian3.pack(Y,B,0),t.Cartesian3.pack(X,V,0),v.push(Z.latitude),v.push(Z.longitude),G(Z,$,0,m,h,g,d,H,B,V,v),y=1;y<R-1;++y){j=t.Cartesian3.clone(Y,j),Y=t.Cartesian3.clone(W,Y);const e=D[y];F(d,e,m,X),F(d,D[y+1],0,W),J(j,Y,X,W,U),w=H.length,t.Cartesian3.pack(U,H,w),t.Cartesian3.pack(Y,B,w),t.Cartesian3.pack(X,V,w),v.push(e.latitude),v.push(e.longitude),G(D[y],D[y+1],0,m,h,g,d,H,B,V,v)}const le=D[R-1],ce=D[R-2];if(Y=F(d,le,0,Y),X=F(d,le,m,X),p){const e=D[0];j=F(d,ce,0,j),W=F(d,e,0,W),U=J(j,Y,X,W,U)}else U=z(ce,le,m,d,U);if(w=H.length,t.Cartesian3.pack(U,H,w),t.Cartesian3.pack(Y,B,w),t.Cartesian3.pack(X,V,w),v.push(le.latitude),v.push(le.longitude),p){for(G(le,Z,0,m,h,g,d,H,B,V,v),w=H.length,y=0;y<3;++y)H[w+y]=H[y],B[w+y]=B[y],V[w+y]=V[y];v.push(Z.latitude),v.push(Z.longitude)}return function(a,i,r,s,o,u,C){let p,d;const h=i._ellipsoid,g=r.length/3-1,f=8*g,m=4*f,w=36*g,y=f>65535?new Uint32Array(w):new Uint16Array(w),M=new Float64Array(3*f),T=new Float32Array(m),E=new Float32Array(m),_=new Float32Array(m),O=new Float32Array(m),b=new Float32Array(m);let P,A,L,S;C&&(P=new Float32Array(m),A=new Float32Array(m),L=new Float32Array(m),S=new Float32Array(2*f));const I=u.length/2;let N=0;const R=Ee;R.height=0;const D=_e;D.height=0;let v=Oe,z=be;if(C)for(d=0,p=1;p<I;p++)R.latitude=u[d],R.longitude=u[d+1],D.latitude=u[d+2],D.longitude=u[d+3],v=i.project(R,v),z=i.project(D,z),N+=t.Cartesian3.distance(v,z),d+=2;const H=s.length/3;z=t.Cartesian3.unpack(s,0,z);let B,V=0;for(d=3,p=1;p<H;p++)v=t.Cartesian3.clone(z,v),z=t.Cartesian3.unpack(s,d,z),V+=t.Cartesian3.distance(v,z),d+=3;d=3;let j=0,G=0,Y=0,F=0,X=!1,W=t.Cartesian3.unpack(r,0,Ae),U=t.Cartesian3.unpack(s,0,be),Z=t.Cartesian3.unpack(o,0,Le);if(a){Ce(Z,t.Cartesian3.unpack(r,r.length-6,Pe),W,U)&&(Z=t.Cartesian3.negate(Z,Z))}let $=0,J=0,Q=0;for(p=0;p<g;p++){const e=t.Cartesian3.clone(W,Pe),a=t.Cartesian3.clone(U,Oe);let c,p,g,f,m=t.Cartesian3.clone(Z,ke);if(X&&(m=t.Cartesian3.negate(m,m)),W=t.Cartesian3.unpack(r,d,Ae),U=t.Cartesian3.unpack(s,d,be),Z=t.Cartesian3.unpack(o,d,Le),X=Ce(Z,e,W,U),R.latitude=u[j],R.longitude=u[j+1],D.latitude=u[j+2],D.longitude=u[j+3],C){const e=Te(R,D);c=i.project(R,ve),p=i.project(D,ze);const a=q(p,c,Ue);a.y=Math.abs(a.y),g=He,f=Be,0===e||t.Cartesian3.dot(a,t.Cartesian3.UNIT_Y)>x?(g=ge(i,R,m,c,He),f=ge(i,D,Z,p,Be)):1===e?(f=ge(i,D,Z,p,Be),g.x=0,g.y=n.CesiumMath.sign(R.longitude-Math.abs(D.longitude)),g.z=0):(g=ge(i,R,m,c,He),f.x=0,f.y=n.CesiumMath.sign(R.longitude-D.longitude),f.z=0)}const w=t.Cartesian3.distance(a,U),y=l.EncodedCartesian3.fromCartesian(e,Xe),I=t.Cartesian3.subtract(W,e,Ve),v=t.Cartesian3.normalize(I,Ye);let z=t.Cartesian3.subtract(a,e,je);z=t.Cartesian3.normalize(z,z);let H=t.Cartesian3.cross(v,z,Ye);H=t.Cartesian3.normalize(H,H);let K=t.Cartesian3.cross(z,m,Fe);K=t.Cartesian3.normalize(K,K);let ee=t.Cartesian3.subtract(U,W,Ge);ee=t.Cartesian3.normalize(ee,ee);let te=t.Cartesian3.cross(Z,ee,qe);te=t.Cartesian3.normalize(te,te);const ae=w/V,ne=$/V;let ie,re,se,oe=0,le=0,ce=0;if(C){oe=t.Cartesian3.distance(c,p),ie=l.EncodedCartesian3.fromCartesian(c,We),re=t.Cartesian3.subtract(p,c,Ue),se=t.Cartesian3.normalize(re,Ze);const e=se.x;se.x=se.y,se.y=-e,le=oe/N,ce=J/N}for(B=0;B<8;B++){const e=F+4*B,a=G+2*B,n=e+3,i=B<4?1:-1,r=2===B||3===B||6===B||7===B?1:-1;t.Cartesian3.pack(y.high,T,e),T[n]=I.x,t.Cartesian3.pack(y.low,E,e),E[n]=I.y,t.Cartesian3.pack(K,_,e),_[n]=I.z,t.Cartesian3.pack(te,O,e),O[n]=ae*i,t.Cartesian3.pack(H,b,e);let s=ne*r;0===s&&r<0&&(s=9),b[n]=s,C&&(P[e]=ie.high.x,P[e+1]=ie.high.y,P[e+2]=ie.low.x,P[e+3]=ie.low.y,L[e]=-g.y,L[e+1]=g.x,L[e+2]=f.y,L[e+3]=-f.x,A[e]=re.x,A[e+1]=re.y,A[e+2]=se.x,A[e+3]=se.y,S[a]=le*i,s=ce*r,0===s&&r<0&&(s=9),S[a+1]=s)}const ue=Re,pe=De,de=Ie,he=Ne,fe=t.Rectangle.fromCartographicArray(Se,xe),me=k.getMinimumMaximumHeights(fe,h),ye=me.minimumTerrainHeight,Ee=me.maximumTerrainHeight;Q+=ye,Q+=Ee,we(e,a,ye,Ee,ue,de),we(W,U,ye,Ee,pe,he);let _e=t.Cartesian3.multiplyByScalar(H,n.CesiumMath.EPSILON5,$e);t.Cartesian3.add(ue,_e,ue),t.Cartesian3.add(pe,_e,pe),t.Cartesian3.add(de,_e,de),t.Cartesian3.add(he,_e,he),Me(ue,pe),Me(de,he),t.Cartesian3.pack(ue,M,Y),t.Cartesian3.pack(pe,M,Y+3),t.Cartesian3.pack(he,M,Y+6),t.Cartesian3.pack(de,M,Y+9),_e=t.Cartesian3.multiplyByScalar(H,-2*n.CesiumMath.EPSILON5,$e),t.Cartesian3.add(ue,_e,ue),t.Cartesian3.add(pe,_e,pe),t.Cartesian3.add(de,_e,de),t.Cartesian3.add(he,_e,he),Me(ue,pe),Me(de,he),t.Cartesian3.pack(ue,M,Y+12),t.Cartesian3.pack(pe,M,Y+15),t.Cartesian3.pack(he,M,Y+18),t.Cartesian3.pack(de,M,Y+21),j+=2,d+=3,G+=16,Y+=24,F+=32,$+=w,J+=oe}d=0;let K=0;for(p=0;p<g;p++){for(B=0;B<Ke;B++)y[d+B]=Qe[B]+K;K+=8,d+=Ke}const ee=Je;e.BoundingSphere.fromVertices(r,t.Cartesian3.ZERO,3,ee[0]),e.BoundingSphere.fromVertices(s,t.Cartesian3.ZERO,3,ee[1]);const te=e.BoundingSphere.fromBoundingSpheres(ee);te.radius+=Q/(2*g);const ae={position:new c.GeometryAttribute({componentDatatype:n.ComponentDatatype.DOUBLE,componentsPerAttribute:3,normalize:!1,values:M}),startHiAndForwardOffsetX:et(T),startLoAndForwardOffsetY:et(E),startNormalAndForwardOffsetZ:et(_),endNormalAndTextureCoordinateNormalizationX:et(O),rightNormalAndTextureCoordinateNormalizationY:et(b)};C&&(ae.startHiLo2D=et(P),ae.offsetAndRight2D=et(A),ae.startEndNormals2D=et(L),ae.texcoordNormalization2D=new c.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:2,normalize:!1,values:S}));return new c.Geometry({attributes:ae,indices:y,boundingSphere:te})}(p,f,B,V,H,v,C)};const le=new t.Cartesian3,ce=new t.Matrix3,ue=new e.Quaternion;function Ce(a,i,r,s){const o=q(r,i,le),l=t.Cartesian3.dot(o,a);if(l>x||l<I){const i=q(s,r,$),o=l<I?n.CesiumMath.PI_OVER_TWO:-n.CesiumMath.PI_OVER_TWO,c=e.Quaternion.fromAxisAngle(i,o,ue),u=t.Matrix3.fromQuaternion(c,ce);return t.Matrix3.multiplyByVector(u,a,a),!0}return!1}const pe=new t.Cartographic,de=new t.Cartesian3,he=new t.Cartesian3;function ge(e,a,i,r,s){const o=t.Cartographic.toCartesian(a,e._ellipsoid,de);let l=t.Cartesian3.add(o,i,he),c=!1;const u=e._ellipsoid;let C=u.cartesianToCartographic(l,pe);Math.abs(a.longitude-C.longitude)>n.CesiumMath.PI_OVER_TWO&&(c=!0,l=t.Cartesian3.subtract(o,i,he),C=u.cartesianToCartographic(l,pe)),C.height=0;const p=e.project(C,s);return(s=t.Cartesian3.subtract(p,r,s)).z=0,s=t.Cartesian3.normalize(s,s),c&&t.Cartesian3.negate(s,s),s}const fe=new t.Cartesian3,me=new t.Cartesian3;function we(e,a,n,i,r,s){const o=t.Cartesian3.subtract(a,e,fe);t.Cartesian3.normalize(o,o);const l=n-0;let c=t.Cartesian3.multiplyByScalar(o,l,me);t.Cartesian3.add(e,c,r);const u=i-1e3;c=t.Cartesian3.multiplyByScalar(o,u,me),t.Cartesian3.add(a,c,s)}const ye=new t.Cartesian3;function Me(e,a){const i=C.Plane.getPointDistance(Q,e),r=C.Plane.getPointDistance(Q,a);let s=ye;n.CesiumMath.equalsEpsilon(i,0,n.CesiumMath.EPSILON2)?(s=q(a,e,s),t.Cartesian3.multiplyByScalar(s,n.CesiumMath.EPSILON2,s),t.Cartesian3.add(e,s,e)):n.CesiumMath.equalsEpsilon(r,0,n.CesiumMath.EPSILON2)&&(s=q(e,a,s),t.Cartesian3.multiplyByScalar(s,n.CesiumMath.EPSILON2,s),t.Cartesian3.add(a,s,a))}function Te(e,t){const a=Math.abs(e.longitude),i=Math.abs(t.longitude);if(n.CesiumMath.equalsEpsilon(a,n.CesiumMath.PI,n.CesiumMath.EPSILON11)){const i=n.CesiumMath.sign(t.longitude);return e.longitude=i*(a-n.CesiumMath.EPSILON11),1}if(n.CesiumMath.equalsEpsilon(i,n.CesiumMath.PI,n.CesiumMath.EPSILON11)){const a=n.CesiumMath.sign(e.longitude);return t.longitude=a*(i-n.CesiumMath.EPSILON11),2}return 0}const Ee=new t.Cartographic,_e=new t.Cartographic,Oe=new t.Cartesian3,be=new t.Cartesian3,Pe=new t.Cartesian3,Ae=new t.Cartesian3,ke=new t.Cartesian3,Le=new t.Cartesian3,Se=[Ee,_e],xe=new t.Rectangle,Ie=new t.Cartesian3,Ne=new t.Cartesian3,Re=new t.Cartesian3,De=new t.Cartesian3,ve=new t.Cartesian3,ze=new t.Cartesian3,He=new t.Cartesian3,Be=new t.Cartesian3,Ve=new t.Cartesian3,je=new t.Cartesian3,Ge=new t.Cartesian3,Ye=new t.Cartesian3,Fe=new t.Cartesian3,qe=new t.Cartesian3,Xe=new l.EncodedCartesian3,We=new l.EncodedCartesian3,Ue=new t.Cartesian3,Ze=new t.Cartesian3,$e=new t.Cartesian3,Je=[new e.BoundingSphere,new e.BoundingSphere],Qe=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],Ke=Qe.length;function et(e){return new c.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}return N._projectNormal=ge,function(e,t){return k.initialize().then((function(){return a.defined(t)&&(e=N.unpack(e,t)),N.createGeometry(e)}))}}));
