/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./defaultValue-65031fc5","./Matrix2-c339372d","./ArcType-84fe1b78","./BoundingRectangle-ef4c3611","./Transforms-a48d25e5","./ComponentDatatype-1b227f17","./EllipsoidGeodesic-14d277c6","./EllipsoidTangentPlane-1f1eb3e6","./GeometryAttribute-5db26912","./GeometryInstance-ee0e4b25","./GeometryOffsetAttribute-026030ef","./GeometryPipeline-7e799ed5","./IndexDatatype-53de8b23","./PolygonGeometryLibrary-fdf44447","./PolygonPipeline-d06990ae","./VertexFormat-2b3ad79f","./RuntimeError-23f4777c","./combine-96aed74b","./WebGLConstants-f5c279b9","./AxisAlignedBoundingBox-f07e0e43","./IntersectionTests-87344d12","./Plane-3d182a08","./AttributeCompression-9d180a12","./EncodedCartesian3-4e907eba","./arrayRemoveDuplicates-235b23d8","./EllipsoidRhumbLine-0df6bb40","./GeometryAttributes-f9b563d6"],(function(e,t,o,i,r,n,a,s,l,u,c,d,p,y,m,g,h,f,b,_,P,C,x,w,T,I,A){"use strict";const v=new t.Cartographic,E=new t.Cartographic;function G(e,t,o,i){const r=i.cartesianToCartographic(e,v).height,n=i.cartesianToCartographic(t,E);n.height=r,i.cartographicToCartesian(n,t);const a=i.cartesianToCartographic(o,E);a.height=r-100,i.cartographicToCartesian(a,o)}const O=new i.BoundingRectangle,L=new t.Cartesian3,V=new t.Cartesian3,H=new t.Cartesian3,D=new t.Cartesian3,N=new t.Cartesian3,F=new t.Cartesian3;let R=new t.Cartesian3,M=new t.Cartesian3,S=new t.Cartesian3;const B=new t.Cartesian2,k=new t.Cartesian2,z=new t.Cartesian3,W=new r.Quaternion,Y=new t.Matrix3,U=new t.Matrix3;function j(o){const i=o.vertexFormat,a=o.geometry,s=o.shadowVolume,u=a.attributes.position.values,d=e.defined(a.attributes.st)?a.attributes.st.values:void 0;let p=u.length;const y=o.wall,m=o.top||y,g=o.bottom||y;if(i.st||i.normal||i.tangent||i.bitangent||s){const c=o.boundingRectangle,h=o.tangentPlane,f=o.ellipsoid,b=o.stRotation,_=o.perPositionHeight,P=B;P.x=c.x,P.y=c.y;const C=i.st?new Float32Array(p/3*2):void 0;let x;i.normal&&(x=_&&m&&!y?a.attributes.normal.values:new Float32Array(p));const w=i.tangent?new Float32Array(p):void 0,T=i.bitangent?new Float32Array(p):void 0,I=s?new Float32Array(p):void 0;let A=0,v=0,E=V,O=H,j=D,Q=!0,q=Y,K=U;if(0!==b){let e=r.Quaternion.fromAxisAngle(h._plane.normal,b,W);q=t.Matrix3.fromQuaternion(e,q),e=r.Quaternion.fromAxisAngle(h._plane.normal,-b,W),K=t.Matrix3.fromQuaternion(e,K)}else q=t.Matrix3.clone(t.Matrix3.IDENTITY,q),K=t.Matrix3.clone(t.Matrix3.IDENTITY,K);let Z=0,J=0;m&&g&&(Z=p/2,J=p/3,p/=2);for(let r=0;r<p;r+=3){const a=t.Cartesian3.fromArray(u,r,z);if(i.st&&!e.defined(d)){let e=t.Matrix3.multiplyByVector(q,a,L);e=f.scaleToGeodeticSurface(e,e);const o=h.projectPointOntoPlane(e,k);t.Cartesian2.subtract(o,P,o);const i=n.CesiumMath.clamp(o.x/c.width,0,1),r=n.CesiumMath.clamp(o.y/c.height,0,1);g&&(C[A+J]=i,C[A+1+J]=r),m&&(C[A]=i,C[A+1]=r),A+=2}if(i.normal||i.tangent||i.bitangent||s){const e=v+1,l=v+2;if(y){if(r+3<p){const e=t.Cartesian3.fromArray(u,r+3,N);if(Q){const o=t.Cartesian3.fromArray(u,r+p,F);_&&G(a,e,o,f),t.Cartesian3.subtract(e,a,e),t.Cartesian3.subtract(o,a,o),E=t.Cartesian3.normalize(t.Cartesian3.cross(o,e,E),E),Q=!1}t.Cartesian3.equalsEpsilon(e,a,n.CesiumMath.EPSILON10)&&(Q=!0)}(i.tangent||i.bitangent)&&(j=f.geodeticSurfaceNormal(a,j),i.tangent&&(O=t.Cartesian3.normalize(t.Cartesian3.cross(j,E,O),O)))}else E=f.geodeticSurfaceNormal(a,E),(i.tangent||i.bitangent)&&(_&&(R=t.Cartesian3.fromArray(x,v,R),M=t.Cartesian3.cross(t.Cartesian3.UNIT_Z,R,M),M=t.Cartesian3.normalize(t.Matrix3.multiplyByVector(K,M,M),M),i.bitangent&&(S=t.Cartesian3.normalize(t.Cartesian3.cross(R,M,S),S))),O=t.Cartesian3.cross(t.Cartesian3.UNIT_Z,E,O),O=t.Cartesian3.normalize(t.Matrix3.multiplyByVector(K,O,O),O),i.bitangent&&(j=t.Cartesian3.normalize(t.Cartesian3.cross(E,O,j),j)));i.normal&&(o.wall?(x[v+Z]=E.x,x[e+Z]=E.y,x[l+Z]=E.z):g&&(x[v+Z]=-E.x,x[e+Z]=-E.y,x[l+Z]=-E.z),(m&&!_||y)&&(x[v]=E.x,x[e]=E.y,x[l]=E.z)),s&&(y&&(E=f.geodeticSurfaceNormal(a,E)),I[v+Z]=-E.x,I[e+Z]=-E.y,I[l+Z]=-E.z),i.tangent&&(o.wall?(w[v+Z]=O.x,w[e+Z]=O.y,w[l+Z]=O.z):g&&(w[v+Z]=-O.x,w[e+Z]=-O.y,w[l+Z]=-O.z),m&&(_?(w[v]=M.x,w[e]=M.y,w[l]=M.z):(w[v]=O.x,w[e]=O.y,w[l]=O.z))),i.bitangent&&(g&&(T[v+Z]=j.x,T[e+Z]=j.y,T[l+Z]=j.z),m&&(_?(T[v]=S.x,T[e]=S.y,T[l]=S.z):(T[v]=j.x,T[e]=j.y,T[l]=j.z))),v+=3}}i.st&&!e.defined(d)&&(a.attributes.st=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:C})),i.normal&&(a.attributes.normal=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:x})),i.tangent&&(a.attributes.tangent=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:w})),i.bitangent&&(a.attributes.bitangent=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:T})),s&&(a.attributes.extrudeDirection=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:I}))}if(o.extrude&&e.defined(o.offsetAttribute)){const e=u.length/3;let t=new Uint8Array(e);if(o.offsetAttribute===c.GeometryOffsetAttribute.TOP)m&&g||y?t=t.fill(1,0,e/2):m&&(t=t.fill(1));else{const e=o.offsetAttribute===c.GeometryOffsetAttribute.NONE?0:1;t=t.fill(e)}a.attributes.applyOffset=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}return a}const Q=new t.Cartographic,q=new t.Cartographic,K={westOverIDL:0,eastOverIDL:0};let Z=new a.EllipsoidGeodesic;function J(i,r,s,l,u){if(u=e.defaultValue(u,new t.Rectangle),!e.defined(i)||i.length<3)return u.west=0,u.north=0,u.south=0,u.east=0,u;if(s===o.ArcType.RHUMB)return t.Rectangle.fromCartesianArray(i,r,u);Z.ellipsoid.equals(r)||(Z=new a.EllipsoidGeodesic(void 0,void 0,r)),u.west=Number.POSITIVE_INFINITY,u.east=Number.NEGATIVE_INFINITY,u.south=Number.POSITIVE_INFINITY,u.north=Number.NEGATIVE_INFINITY,K.westOverIDL=Number.POSITIVE_INFINITY,K.eastOverIDL=Number.NEGATIVE_INFINITY;const c=1/n.CesiumMath.chordLength(l,r.maximumRadius),d=i.length;let p,y=r.cartesianToCartographic(i[0],q),m=Q;for(let e=1;e<d;e++)p=m,m=y,y=r.cartesianToCartographic(i[e],p),Z.setEndPoints(m,y),$(Z,c,u,K);return p=m,m=y,y=r.cartesianToCartographic(i[0],p),Z.setEndPoints(m,y),$(Z,c,u,K),u.east-u.west>K.eastOverIDL-K.westOverIDL&&(u.west=K.westOverIDL,u.east=K.eastOverIDL,u.east>n.CesiumMath.PI&&(u.east=u.east-n.CesiumMath.TWO_PI),u.west>n.CesiumMath.PI&&(u.west=u.west-n.CesiumMath.TWO_PI)),u}const X=new t.Cartographic;function $(e,t,o,i){const r=e.surfaceDistance,a=Math.ceil(r*t),s=a>0?r/(a-1):Number.POSITIVE_INFINITY;let l=0;for(let t=0;t<a;t++){const t=e.interpolateUsingSurfaceDistance(l,X);l+=s;const r=t.longitude,a=t.latitude;o.west=Math.min(o.west,r),o.east=Math.max(o.east,r),o.south=Math.min(o.south,a),o.north=Math.max(o.north,a);const u=r>=0?r:r+n.CesiumMath.TWO_PI;i.westOverIDL=Math.min(i.westOverIDL,u),i.eastOverIDL=Math.max(i.eastOverIDL,u)}}const ee=[];function te(t,o,i,r,n,a,l,c,d,g){const h={walls:[]};let f;if(l||c){const n=y.PolygonGeometryLibrary.createGeometryFromPositions(t,o,i,r,a,d,g),s=n.attributes.position.values,m=n.indices;let b,_;if(l&&c){const t=s.concat(s);b=t.length/3,_=p.IndexDatatype.createTypedArray(b,2*m.length),_.set(m);const o=m.length,r=b/2;for(f=0;f<o;f+=3){const e=_[f]+r,t=_[f+1]+r,i=_[f+2]+r;_[f+o]=i,_[f+1+o]=t,_[f+2+o]=e}if(n.attributes.position.values=t,a&&d.normal){const e=n.attributes.normal.values;n.attributes.normal.values=new Float32Array(t.length),n.attributes.normal.values.set(e)}if(d.st&&e.defined(i)){const e=n.attributes.st.values;n.attributes.st.values=new Float32Array(2*b),n.attributes.st.values=e.concat(e)}n.indices=_}else if(c){for(b=s.length/3,_=p.IndexDatatype.createTypedArray(b,m.length),f=0;f<m.length;f+=3)_[f]=m[f+2],_[f+1]=m[f+1],_[f+2]=m[f];n.indices=_}h.topAndBottom=new u.GeometryInstance({geometry:n})}let b=n.outerRing,_=s.EllipsoidTangentPlane.fromPoints(b,t),P=_.projectPointsOntoPlane(b,ee),C=m.PolygonPipeline.computeWindingOrder2D(P);C===m.WindingOrder.CLOCKWISE&&(b=b.slice().reverse());let x=y.PolygonGeometryLibrary.computeWallGeometry(b,i,t,r,a,g);h.walls.push(new u.GeometryInstance({geometry:x}));const w=n.holes;for(f=0;f<w.length;f++){let e=w[f];_=s.EllipsoidTangentPlane.fromPoints(e,t),P=_.projectPointsOntoPlane(e,ee),C=m.PolygonPipeline.computeWindingOrder2D(P),C===m.WindingOrder.COUNTER_CLOCKWISE&&(e=e.slice().reverse()),x=y.PolygonGeometryLibrary.computeWallGeometry(e,i,t,r,a,g),h.walls.push(new u.GeometryInstance({geometry:x}))}return h}function oe(i){const r=i.polygonHierarchy,a=e.defaultValue(i.vertexFormat,g.VertexFormat.DEFAULT),s=e.defaultValue(i.ellipsoid,t.Ellipsoid.WGS84),l=e.defaultValue(i.granularity,n.CesiumMath.RADIANS_PER_DEGREE),u=e.defaultValue(i.stRotation,0),c=i.textureCoordinates,d=e.defaultValue(i.perPositionHeight,!1),p=d&&e.defined(i.extrudedHeight);let m=e.defaultValue(i.height,0),h=e.defaultValue(i.extrudedHeight,m);if(!p){const e=Math.max(m,h);h=Math.min(m,h),m=e}this._vertexFormat=g.VertexFormat.clone(a),this._ellipsoid=t.Ellipsoid.clone(s),this._granularity=l,this._stRotation=u,this._height=m,this._extrudedHeight=h,this._closeTop=e.defaultValue(i.closeTop,!0),this._closeBottom=e.defaultValue(i.closeBottom,!0),this._polygonHierarchy=r,this._perPositionHeight=d,this._perPositionHeightExtrude=p,this._shadowVolume=e.defaultValue(i.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=i.offsetAttribute,this._arcType=e.defaultValue(i.arcType,o.ArcType.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this._textureCoordinates=c,this.packedLength=y.PolygonGeometryLibrary.computeHierarchyPackedLength(r,t.Cartesian3)+t.Ellipsoid.packedLength+g.VertexFormat.packedLength+(c?y.PolygonGeometryLibrary.computeHierarchyPackedLength(c,t.Cartesian2):1)+12}oe.fromPositions=function(t){return new oe({polygonHierarchy:{positions:(t=e.defaultValue(t,e.defaultValue.EMPTY_OBJECT)).positions},height:t.height,extrudedHeight:t.extrudedHeight,vertexFormat:t.vertexFormat,stRotation:t.stRotation,ellipsoid:t.ellipsoid,granularity:t.granularity,perPositionHeight:t.perPositionHeight,closeTop:t.closeTop,closeBottom:t.closeBottom,offsetAttribute:t.offsetAttribute,arcType:t.arcType,textureCoordinates:t.textureCoordinates})},oe.pack=function(o,i,r){return r=e.defaultValue(r,0),r=y.PolygonGeometryLibrary.packPolygonHierarchy(o._polygonHierarchy,i,r,t.Cartesian3),t.Ellipsoid.pack(o._ellipsoid,i,r),r+=t.Ellipsoid.packedLength,g.VertexFormat.pack(o._vertexFormat,i,r),r+=g.VertexFormat.packedLength,i[r++]=o._height,i[r++]=o._extrudedHeight,i[r++]=o._granularity,i[r++]=o._stRotation,i[r++]=o._perPositionHeightExtrude?1:0,i[r++]=o._perPositionHeight?1:0,i[r++]=o._closeTop?1:0,i[r++]=o._closeBottom?1:0,i[r++]=o._shadowVolume?1:0,i[r++]=e.defaultValue(o._offsetAttribute,-1),i[r++]=o._arcType,e.defined(o._textureCoordinates)?r=y.PolygonGeometryLibrary.packPolygonHierarchy(o._textureCoordinates,i,r,t.Cartesian2):i[r++]=-1,i[r++]=o.packedLength,i};const ie=t.Ellipsoid.clone(t.Ellipsoid.UNIT_SPHERE),re=new g.VertexFormat,ne={polygonHierarchy:{}};return oe.unpack=function(o,i,r){i=e.defaultValue(i,0);const n=y.PolygonGeometryLibrary.unpackPolygonHierarchy(o,i,t.Cartesian3);i=n.startingIndex,delete n.startingIndex;const a=t.Ellipsoid.unpack(o,i,ie);i+=t.Ellipsoid.packedLength;const s=g.VertexFormat.unpack(o,i,re);i+=g.VertexFormat.packedLength;const l=o[i++],u=o[i++],c=o[i++],d=o[i++],p=1===o[i++],m=1===o[i++],h=1===o[i++],f=1===o[i++],b=1===o[i++],_=o[i++],P=o[i++],C=-1===o[i]?void 0:y.PolygonGeometryLibrary.unpackPolygonHierarchy(o,i,t.Cartesian2);e.defined(C)?(i=C.startingIndex,delete C.startingIndex):i++;const x=o[i++];return e.defined(r)||(r=new oe(ne)),r._polygonHierarchy=n,r._ellipsoid=t.Ellipsoid.clone(a,r._ellipsoid),r._vertexFormat=g.VertexFormat.clone(s,r._vertexFormat),r._height=l,r._extrudedHeight=u,r._granularity=c,r._stRotation=d,r._perPositionHeightExtrude=p,r._perPositionHeight=m,r._closeTop=h,r._closeBottom=f,r._shadowVolume=b,r._offsetAttribute=-1===_?void 0:_,r._arcType=P,r._textureCoordinates=C,r.packedLength=x,r},oe.computeRectangle=function(i,r){const a=e.defaultValue(i.granularity,n.CesiumMath.RADIANS_PER_DEGREE),s=e.defaultValue(i.arcType,o.ArcType.GEODESIC),l=i.polygonHierarchy,u=e.defaultValue(i.ellipsoid,t.Ellipsoid.WGS84);return J(l.positions,u,s,a,r)},oe.createGeometry=function(t){const o=t._vertexFormat,i=t._ellipsoid,a=t._granularity,g=t._stRotation,h=t._polygonHierarchy,f=t._perPositionHeight,b=t._closeTop,_=t._closeBottom,P=t._arcType,C=t._textureCoordinates,x=e.defined(C);let w=h.positions;if(w.length<3)return;const T=s.EllipsoidTangentPlane.fromPoints(w,i),I=y.PolygonGeometryLibrary.polygonsFromHierarchy(h,x,T.projectPointsOntoPlane.bind(T),!f,i),A=I.hierarchy,v=I.polygons,E=x?y.PolygonGeometryLibrary.polygonsFromHierarchy(C,!0,(function(e){return e}),!1).polygons:void 0;if(0===A.length)return;w=A[0].outerRing;const G=y.PolygonGeometryLibrary.computeBoundingRectangle(T.plane.normal,T.projectPointOntoPlane.bind(T),w,g,O),L=[],V=t._height,H=t._extrudedHeight,D={perPositionHeight:f,vertexFormat:o,geometry:void 0,tangentPlane:T,boundingRectangle:G,ellipsoid:i,stRotation:g,textureCoordinates:void 0,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:P};let N;if(t._perPositionHeightExtrude||!n.CesiumMath.equalsEpsilon(V,H,0,n.CesiumMath.EPSILON2))for(D.extrude=!0,D.top=b,D.bottom=_,D.shadowVolume=t._shadowVolume,D.offsetAttribute=t._offsetAttribute,N=0;N<v.length;N++){const e=te(i,v[N],x?E[N]:void 0,a,A[N],f,b,_,o,P);let t;b&&_?(t=e.topAndBottom,D.geometry=y.PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(t.geometry,V,H,i,f)):b?(t=e.topAndBottom,t.geometry.attributes.position.values=m.PolygonPipeline.scaleToGeodeticHeight(t.geometry.attributes.position.values,V,i,!f),D.geometry=t.geometry):_&&(t=e.topAndBottom,t.geometry.attributes.position.values=m.PolygonPipeline.scaleToGeodeticHeight(t.geometry.attributes.position.values,H,i,!0),D.geometry=t.geometry),(b||_)&&(D.wall=!1,t.geometry=j(D),L.push(t));const r=e.walls;D.wall=!0;for(let e=0;e<r.length;e++){const t=r[e];D.geometry=y.PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(t.geometry,V,H,i,f),t.geometry=j(D),L.push(t)}}else for(N=0;N<v.length;N++){const r=new u.GeometryInstance({geometry:y.PolygonGeometryLibrary.createGeometryFromPositions(i,v[N],x?E[N]:void 0,a,f,o,P)});if(r.geometry.attributes.position.values=m.PolygonPipeline.scaleToGeodeticHeight(r.geometry.attributes.position.values,V,i,!f),D.geometry=r.geometry,r.geometry=j(D),e.defined(t._offsetAttribute)){const e=r.geometry.attributes.position.values.length,o=t._offsetAttribute===c.GeometryOffsetAttribute.NONE?0:1,i=new Uint8Array(e/3).fill(o);r.geometry.attributes.applyOffset=new l.GeometryAttribute({componentDatatype:n.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}L.push(r)}const F=d.GeometryPipeline.combineInstances(L)[0];F.attributes.position.values=new Float64Array(F.attributes.position.values),F.indices=p.IndexDatatype.createTypedArray(F.attributes.position.values.length/3,F.indices);const R=F.attributes,M=r.BoundingSphere.fromVertices(R.position.values);return o.position||delete R.position,new l.Geometry({attributes:R,indices:F.indices,primitiveType:F.primitiveType,boundingSphere:M,offsetAttribute:t._offsetAttribute})},oe.createShadowVolume=function(e,t,o){const i=e._granularity,r=e._ellipsoid,n=t(i,r),a=o(i,r);return new oe({polygonHierarchy:e._polygonHierarchy,ellipsoid:r,stRotation:e._stRotation,granularity:i,perPositionHeight:!1,extrudedHeight:n,height:a,vertexFormat:g.VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},Object.defineProperties(oe.prototype,{rectangle:{get:function(){if(!e.defined(this._rectangle)){const e=this._polygonHierarchy.positions;this._rectangle=J(e,this._ellipsoid,this._arcType,this._granularity)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return e.defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=function(e){const t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];const o=e._ellipsoid,i=e._polygonHierarchy.positions,r=e.rectangle;return l.Geometry._textureCoordinateRotationPoints(i,t,o,r)}(this)),this._textureCoordinateRotationPoints}}}),function(o,i){return e.defined(i)&&(o=oe.unpack(o,i)),o._ellipsoid=t.Ellipsoid.clone(o._ellipsoid),oe.createGeometry(o)}}));
