/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.98.1
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./AttributeCompression-9d180a12","./Matrix2-c339372d","./Color-72bab6c2","./defaultValue-65031fc5","./IndexDatatype-53de8b23","./ComponentDatatype-1b227f17","./OrientedBoundingBox-59c958d0","./createTaskProcessorWorker","./RuntimeError-23f4777c","./Transforms-a48d25e5","./combine-96aed74b","./WebGLConstants-f5c279b9","./EllipsoidTangentPlane-1f1eb3e6","./AxisAlignedBoundingBox-f07e0e43","./IntersectionTests-87344d12","./Plane-3d182a08"],(function(e,t,n,a,r,o,i,s,c,f,d,l,u,h,g,p){"use strict";const b=new t.Cartesian3,m=new t.Ellipsoid,y=new t.Rectangle,C={min:void 0,max:void 0,indexBytesPerElement:void 0};function I(e,t,a){const r=t.length,o=2+r*i.OrientedBoundingBox.packedLength+1+function(e){const t=e.length;let a=0;for(let r=0;r<t;++r)a+=n.Color.packedLength+3+e[r].batchIds.length;return a}(a),s=new Float64Array(o);let c=0;s[c++]=e,s[c++]=r;for(let e=0;e<r;++e)i.OrientedBoundingBox.pack(t[e],s,c),c+=i.OrientedBoundingBox.packedLength;const f=a.length;s[c++]=f;for(let e=0;e<f;++e){const t=a[e];n.Color.pack(t.color,s,c),c+=n.Color.packedLength,s[c++]=t.offset,s[c++]=t.count;const r=t.batchIds,o=r.length;s[c++]=o;for(let e=0;e<o;++e)s[c++]=r[e]}return s}const x=new t.Cartesian3,w=new t.Cartesian3,A=new t.Cartesian3,E=new t.Cartesian3,N=new t.Cartesian3,T=new t.Cartographic,B=new t.Rectangle;return s((function(s,c){let f;!function(e){const n=new Float64Array(e);let a=0;C.indexBytesPerElement=n[a++],C.min=n[a++],C.max=n[a++],t.Cartesian3.unpack(n,a,b),a+=t.Cartesian3.packedLength,t.Ellipsoid.unpack(n,a,m),a+=t.Ellipsoid.packedLength,t.Rectangle.unpack(n,a,y)}(s.packedBuffer),f=2===C.indexBytesPerElement?new Uint16Array(s.indices):new Uint32Array(s.indices);const d=new Uint16Array(s.positions),l=new Uint32Array(s.counts),u=new Uint32Array(s.indexCounts),h=new Uint32Array(s.batchIds),g=new Uint32Array(s.batchTableColors),p=new Array(l.length),k=b,L=m;let O=y;const U=C.min,P=C.max;let F,S,D,R=s.minimumHeights,M=s.maximumHeights;a.defined(R)&&a.defined(M)&&(R=new Float32Array(R),M=new Float32Array(M));const _=d.length/2,G=d.subarray(0,_),V=d.subarray(_,2*_);e.AttributeCompression.zigZagDeltaDecode(G,V);const Y=new Float64Array(3*_);for(F=0;F<_;++F){const e=G[F],n=V[F],a=o.CesiumMath.lerp(O.west,O.east,e/32767),r=o.CesiumMath.lerp(O.south,O.north,n/32767),i=t.Cartographic.fromRadians(a,r,0,T),s=L.cartographicToCartesian(i,x);t.Cartesian3.pack(s,Y,3*F)}const v=l.length,H=new Array(v),W=new Array(v);let z=0,Z=0;for(F=0;F<v;++F)H[F]=z,W[F]=Z,z+=l[F],Z+=u[F];const j=new Float32Array(3*_*2),q=new Uint16Array(2*_),J=new Uint32Array(W.length),K=new Uint32Array(u.length);let Q=[];const X={};for(F=0;F<v;++F)D=g[F],a.defined(X[D])?(X[D].positionLength+=l[F],X[D].indexLength+=u[F],X[D].batchIds.push(F)):X[D]={positionLength:l[F],indexLength:u[F],offset:0,indexOffset:0,batchIds:[F]};let $,ee=0,te=0;for(D in X)if(X.hasOwnProperty(D)){$=X[D],$.offset=ee,$.indexOffset=te;const e=2*$.positionLength,t=2*$.indexLength+6*$.positionLength;ee+=e,te+=t,$.indexLength=t}const ne=[];for(D in X)X.hasOwnProperty(D)&&($=X[D],ne.push({color:n.Color.fromRgba(parseInt(D)),offset:$.indexOffset,count:$.indexLength,batchIds:$.batchIds}));for(F=0;F<v;++F){D=g[F],$=X[D];const e=$.offset;let n=3*e,r=e;const o=H[F],s=l[F],c=h[F];let d=U,b=P;a.defined(R)&&a.defined(M)&&(d=R[F],b=M[F]);let m=Number.POSITIVE_INFINITY,y=Number.NEGATIVE_INFINITY,C=Number.POSITIVE_INFINITY,I=Number.NEGATIVE_INFINITY;for(S=0;S<s;++S){const e=t.Cartesian3.unpack(Y,3*o+3*S,x);L.scaleToGeodeticSurface(e,e);const a=L.cartesianToCartographic(e,T),i=a.latitude,s=a.longitude;m=Math.min(i,m),y=Math.max(i,y),C=Math.min(s,C),I=Math.max(s,I);const f=L.geodeticSurfaceNormal(e,w);let l=t.Cartesian3.multiplyByScalar(f,d,A);const u=t.Cartesian3.add(e,l,E);l=t.Cartesian3.multiplyByScalar(f,b,l);const h=t.Cartesian3.add(e,l,N);t.Cartesian3.subtract(h,k,h),t.Cartesian3.subtract(u,k,u),t.Cartesian3.pack(h,j,n),t.Cartesian3.pack(u,j,n+3),q[r]=c,q[r+1]=c,n+=6,r+=2}O=B,O.west=C,O.east=I,O.south=m,O.north=y,p[F]=i.OrientedBoundingBox.fromRectangle(O,U,P,L);let _=$.indexOffset;const G=W[F],V=u[F];for(J[F]=_,S=0;S<V;S+=3){const t=f[G+S]-o,n=f[G+S+1]-o,a=f[G+S+2]-o;Q[_++]=2*t+e,Q[_++]=2*n+e,Q[_++]=2*a+e,Q[_++]=2*a+1+e,Q[_++]=2*n+1+e,Q[_++]=2*t+1+e}for(S=0;S<s;++S){const t=S,n=(S+1)%s;Q[_++]=2*t+1+e,Q[_++]=2*n+e,Q[_++]=2*t+e,Q[_++]=2*t+1+e,Q[_++]=2*n+1+e,Q[_++]=2*n+e}$.offset+=2*s,$.indexOffset=_,K[F]=_-J[F]}Q=r.IndexDatatype.createTypedArray(j.length/3,Q);const ae=ne.length;for(let e=0;e<ae;++e){const t=ne[e].batchIds;let n=0;const a=t.length;for(let e=0;e<a;++e)n+=K[t[e]];ne[e].count=n}const re=I(2===Q.BYTES_PER_ELEMENT?r.IndexDatatype.UNSIGNED_SHORT:r.IndexDatatype.UNSIGNED_INT,p,ne);return c.push(j.buffer,Q.buffer,J.buffer,K.buffer,q.buffer,re.buffer),{positions:j.buffer,indices:Q.buffer,indexOffsets:J.buffer,indexCounts:K.buffer,batchIds:q.buffer,packedBuffer:re.buffer}}))}));
