import Vue from "vue";
import Router from "vue-router";
//import Layout from "../layout/index";
import HomeLayout from "../layout/home";
import HomeLayout2 from "../layout/home2";

Vue.use(Router);

export const constantRouterMap = [
	{
        path: "/plus/login",
        meta: { title: "登录login", noCache: true },
        component: (resolve) => {
			require(["@/views/system/user/login"], resolve)
        },
        hidden: true
    },
    {
        path: "/404",
		redirect: "/dashboard",
        component: resolve => require(["@/views/features/404"], resolve),
        hidden: true
    },
    {
        path: "/401",
        component: resolve => require(["@/views/features/401"], resolve),
        hidden: true
    },
    {
		path: "/redirect",
		//component: Layout,
		component: HomeLayout,
		hidden: true,
		children: [
			{
				path: "/redirect/:path*",
				component: resolve => require(["@/views/features/redirect"], resolve)
			}
		]
	},
    {
		path: "/user",
		//component: Layout,
		component: HomeLayout,
		hidden: true,
		redirect: "noredirect",
		children: [
			{
				path: "center",
				component: resolve => require(["@/views/system/user/center"], resolve),
				name: "个人中心",
				meta: { title: "个人中心" }
			}
		]
    },
	{
		path: "/home",
		//component: Layout,
		component: HomeLayout,
		redirect: "noredirect",
		hidden:false,
		children: [
			{
				path: "enterprise",
				component: resolve => require([localStorage.getItem('groupIdByloginType')*1 === 1 ? "@/views/system/home/enterprise" : "@/views/system/home/tech"], resolve),
				name: "首页-企业",
				meta: { title: "首页", affix:true , icon: "index"}
			},
			// {
			// 	path: "tech",
			// 	component: resolve => require(["@/views/system/home/tech"], resolve),
			// 	name: "首页-科技局",
			// 	meta: { title: "首页", affix:true , icon: "index"}
			// },
			{
				path: "overview",
				component: resolve => require(["@/views/system/home/overview"], resolve),
				name: "概览",
				hidden: true,
				meta: { title: "数据概览", icon: "index"}
			}
		]
    },
	// {
	// 	path: "/home",
	// 	//component: Layout,
	// 	component: HomeLayout,
	// 	redirect: "noredirect",
	// 	hidden:true,
	// 	children: [
			
	// 	]
    // },
    {
		path: "/edge/Screen",
		component: (resolve) => {
			return require(["@/views/Screen/index"], resolve)
		},
		hidden: true
	},

	// 纯表单		
	{
		path: "/business/achievement",
		component: (resolve) => {
			return require(["@/views/business/iframe"], resolve)
		},
		hidden: true
	},
	{
		path: "/business/product",
		component: (resolve) => {
			return require(["@/views/business/iframe"], resolve)
		},
		hidden: true
	},
	
	{
		path: "/",
		//redirect: "/edge/Screen",
		component: (resolve) => {
			window.location.href = '/edge/Screen'
		},
		hidden: true
	},
];

if(process.env.NODE_ENV === 'development'){
	constantRouterMap.push({
		path: "/edge/ScreenTest",
		component: (resolve) => {
			return require(["@/views/Screen/indexTest"], resolve)
		},
		hidden: true
	});
};

export default new Router({
    // mode: 'hash',
    mode:"history",
	//base: '/mobile/',
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRouterMap
});
