import { FormRules } from "naive-ui";

// 用户
export const userRules: FormRules = {
    name: [
      {
        type: 'string',
        required: true,
        message: '请输入用户名',
        trigger: 'blur'
      }
    ],
    username: [
      {
        type: 'string',
        required: true,
        message: '请输入用户姓名',
        trigger: 'blur'
      }
    ],
    depId: [
      {
        type: 'string',
        required: true,
        message: '请选择部门名称',
        trigger: 'blur'
      }
    ],
    posId: [
      {
        type: 'string',
        required: true,
        message: '请选择岗位名称',
        trigger: 'blur'
      }
    ],
    roleId: [
      {
        type: 'string',
        required: true,
        message: '请选择角色名称',
        trigger: 'blur'
      }
    ],
    password: [
      {
        type: 'string',
        required: true,
        message: '请输入密码',
        trigger: 'blur'
      }
    ],
    phone: [
      {
        type: 'string',
        required: true,
        message: '请输入手机号',
        trigger: 'blur'
      }
    ]
  };

// 角色
export const roleRules : FormRules =  {
  roleName: [
    {
      type: 'string',
      required: true,
      message: '请输入角色',
      trigger: 'blur'
    }
  ],
  roleRemark: [
    {
      type: 'string',
      required: true,
      message: '请输入角色描述',
      trigger:  'blur'
    }
  ],
  permissionIds: [
    {
      type: 'string',
      required: true,
      message: '请选择权限',
      trigger:  'blur'
    }
  ]
};

// 岗位
export const posRules : FormRules = {
  name: [
    {
      type: 'string',
      required: true,
      message: '请输入岗位名称',
      trigger: 'blur'
    }
  ]
};

// 部门
export const depRules = {
  name: [
    {
      type: 'string',
      required: true,
      message: '请输入部门名称',
      trigger: 'blur'
    }
  ]
};