export const create3D = async (viewer: any, url: any, height = 0) => {
  const tiles = await Cesium.Cesium3DTileset.fromUrl(url,
    {
      maximumScreenSpaceError: 1,
      pickable: true,
    }
  );

  create3D.id && viewer.scene.primitives.remove(create3D.id);
  var boundingSphere = tiles.boundingSphere;
  var cartographic = Cesium.Cartographic.fromCartesian(boundingSphere.center);
  var longitude = cartographic.longitude;
  var latitude = cartographic.latitude;
  var alt = cartographic.height;
  var origin = Cesium.Cartesian3.fromRadians(
    cartographic.longitude,
    cartographic.latitude,
    cartographic.height
  );
  var alt1 = alt + height;
  var offset = Cesium.Cartesian3.fromRadians(
    longitude,
    latitude,
    alt1
  );
  var translate = Cesium.Cartesian3.subtract(
    offset,
    origin,
    new Cesium.Cartesian3()
  );

  tiles.modelMatrix = Cesium.Matrix4.fromTranslation(translate);
  create3D.id = viewer.scene.primitives.add(tiles);
  viewer.zoomTo(tiles);
}