export function cesiumToLongitudeAndLatitude(cartesian: any){
  var ellipsoid = Cesium.Ellipsoid.WGS84; // 使用WGS84椭球体
  var cartographic = ellipsoid.cartesianToCartographic(cartesian); // 转换为地理坐标（弧度表示）
console.log('111',cartographic);

  // 将弧度转换为度
  var longitude = Cesium.Math.toDegrees(cartographic.longitude); // 经度
  var latitude = Cesium.Math.toDegrees(cartographic.latitude); // 纬度
  var height = cartographic.height; // 高度（可选）

  return {
    x: longitude,
    y: latitude,
    z: height
  }
}
// ===================== 经纬度转投影
export let toProjectionCoordinates = (x: number, y: number) => {
  if (!proj4) return null;
  var wgs84 = '+proj=longlat +datum=WGS84 +no_defs';
  var cgcs2000 = '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +datum=CGCS2000 +units=m +no_defs';
  var lon = x;
  var lat = y;
  var convertedCoords = proj4(wgs84, cgcs2000, [lon, lat]);
  return convertedCoords;
}

// ===================== 投影转经纬度
export const toConvertLongitudeAndLatitude = (x, y) => {
  var wgs84 = '+proj=longlat +datum=WGS84 +no_defs';
  var cgcs2000 = '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +datum=CGCS2000 +units=m +no_defs';
  var x = x;
  var y = y;
  var convertedLonLat = proj4(cgcs2000, wgs84, [x, y]);
  return convertedLonLat;
}