// 全局保存当前选中窗口
let g_iWndIndex = 0; //可以不用设置这个变量，有窗口参数的接口中，不用传值，开发包会默认使用当前选择窗口
let g_oLocalConfig = null; //本地配置

//错误码
//通用错误
let ERROR_CODE_UNKNOWN = 1000; //未知错误
let ERROR_CODE_NETWORKERROR = 1001; //网络错误
let ERROR_CODE_PARAMERROR = 1002; //缺少插件元素

//登录模块
let ERROR_CODE_LOGIN_NOLOGIN = 2000; // 未登录
let ERROR_CODE_LOGIN_REPEATLOGIN = 2001; //设备已登录，重复登录
let ERROR_CODE_LOGIN_NOSUPPORT = 2002; //当前设备不支持Digest登录

//预览播放
let ERROR_CODE_PLAY_PLUGININITFAIL = 3000; //插件初始化失败
let ERROR_CODE_PLAY_NOREPEATPLAY = 3001; //当前窗口已经在预览
let ERROR_CODE_PLAY_PLAYBACKABNORMAL = 3002; //回放异常
let ERROR_CODE_PLAY_PLAYBACKSTOP = 3003; //回放停止
let ERROR_CODE_PLAY_NOFREESPACE = 3004; //录像过程中，硬盘容量不足

//对讲
let ERROR_CODE_TALK_FAIL = 5000; //语音对讲失败

let rtsp = {
  ip: "",
  user: "",
  password: "",
  port: "80",
};

export function switchVideo(data: any) {
  rtsp = data;
  let szDeviceIdentify = rtsp.ip + "_" + rtsp.port

  WebVideoCtrl.I_Stop({
    szDeviceIdentify: szDeviceIdentify, // 例：192.168.1.64_80
    iWndIndex: g_iWndIndex,               // 0~35
    success: function () {
      console.log("停播成功");
      // 停完再播
      startPreview();
    },
    error: function () {
      console.log("停播失败，直接销毁插件");
      WebVideoCtrl.I_DestroyPlugin();
      startPreview()
    }
  });
  login()
}

function login() {
  // 初始化插件
  WebVideoCtrl.I_InitPlugin({
    szContainerID: "videoLayout",
    iWndowType: 1, // 改为1表示单个窗口
    cbSelWnd: function (xmlDoc) {
      console.log("选择了窗口：");
    },
    cbInitPluginComplete: function () {
      WebVideoCtrl.I_InsertOBJECTPlugin("videoLayout").then(() => {
        console.log("插件初始化成功！");
        clickLogin(1)
      }, (err) => {
        console.log("插件初始化失败");
      });
    }
  });

  clickLogout()
}

// 登录
function clickLogin(szProtoType) {
  let szIP = rtsp.ip
  let szPort = rtsp.port
  let szUsername = rtsp.user
  let szPassword = rtsp.password

  if ("" == szIP || "" == szPort) {
    return;
  }

  var szDeviceIdentify = szIP + "_" + szPort;

  WebVideoCtrl.I_Login(szIP, szProtoType, szPort, szUsername, szPassword, {
    timeout: 3000,
    success: function (xmlDoc) {
      console.log("登陆成功");
      startPreview();
    },
    error: function (oError) {
      if (ERROR_CODE_LOGIN_REPEATLOGIN === status) {
        console.log(" 已登录过！");
      } else {
        if (oError.errorCode === 401) {
          console.log(" 登录失败，已自动切换认证方式！");

        } else {
          console.log(" 登录失败");
        }
      }
    }
  });
}

 // 退出
 function clickLogout() {
  var szDeviceIdentify = rtsp.ip;
  if (null == szDeviceIdentify) {
    return;
  }
  WebVideoCtrl.I_Logout(szDeviceIdentify).then(() => {
    console.log("退出成功");
  }, () => {
    console.log("退出失败");
  });
}

// 开始预览
function startPreview() {
  let deviceIdentify = rtsp.ip + "_" + rtsp.port
  WebVideoCtrl.I_StartRealPlay(deviceIdentify, {
    iWndIndex: g_iWndIndex,
    iStreamType: 1, // 主码流
    iChannelID: 1,
    bZeroChannel: false,
    success: function () {
      // showOPInfo(`摄像头 ${cameraIndex} (${deviceIdentify}) 在窗口 ${windowIndex} 预览成功！`);
      console.log("预览成功！");
    },
    error: function (err) {
      // showOPInfo(`摄像头 ${cameraIndex} (${deviceIdentify}) 在窗口 ${windowIndex} 预览失败：${err ? (err.errorCode + " - " + err.errorMsg) : "未知错误"}`);
      console.log("预览失败！",err);
    }
  });
}
