import { h, nextTick, ref } from 'vue';
import { NButton, NCol, NRow, NSpace, NTag } from 'naive-ui';
import { router } from '@/router';
import { localStg } from './storage';
import { AudioPlayer } from './common';
let ws: any = null;
const severName = 'home';
// 定义WebSocket连接的URL
const webSocketUrl = `ws://192.168.2.53:8080/ws/${severName}`;
// 存储活动通知实例的数组，用于限制通知数量
const activeNotifications: any[] = [];
const MAX_NOTIFICATIONS = 3;
const htmlStr = ref('');

// JSON字符串转对象函数
function parseDetectionRecord(jsonString: string): DetectionRecord {
  try {
    // 注意：需要先清理字符串中的额外反引号
    const cleanedString = jsonString.replace(/^\s*`|`\s*$/g, '');
    return JSON.parse(cleanedString);
  } catch (error) {
    console.error('JSON解析错误:', error);
    throw new Error('无效的JSON格式');
  }
}

// 处理通知创建，确保不超过最大数量限制
function createLimitedNotification(options: any) {
  // 如果当前通知数量已达上限，移除最早的通知
  if (activeNotifications.length >= MAX_NOTIFICATIONS) {
    const oldestNotification = activeNotifications.shift();
    oldestNotification?.destroy();
  }

  // 创建新通知
  const notification = window.$notification?.create(options);

  // 添加到活动通知列表
  if (notification) {
    activeNotifications.push(notification);

    // 监听通知关闭事件，从列表中移除
    const originalDestroy = notification.destroy;
    notification.destroy = function () {
      const index = activeNotifications.indexOf(notification);
      if (index > -1) {
        activeNotifications.splice(index, 1);
      }
      originalDestroy.call(this);
    };
  }

  return notification;
}
const playAudio = async (id: any) => {
  const player = new AudioPlayer(`http://192.168.2.53:9995/v1/play/${id}`);

  player.play().catch(err => console.error('播放失败',err));
};
export function connect() {
  if ('WebSocket' in window) {
    ws = new WebSocket(webSocketUrl);
    // 连接成功时触发
    ws.onopen = function (event) {
      console.log('WebSocket连接成功');
      // 可以在这里发送消息给服务器
      // websocket.send('消息内容');
    };
    // 接收到消息时触发
    ws.onmessage = function (event) {
      const recordObject: DetectionRecord = parseDetectionRecord(event.data);
      if (event.data == 401) {
        localStorage.removeItem('token');
        router.push('/login');
      } else {
        // 处理接收到的数据
        const data = recordObject;
        if (true) {
          playAudio(data.algorithmId);
        }
        // 使用有限制的通知创建函数
        createLimitedNotification({
          duration: 2000,
          position: 'right-top',
          title: () =>
            h('div', [
              h(NSpace, { justify: 'space-between' }, [
                h(NSpace, { align: 'center' }, [
                  // 报警等级标签
                  data.algorithmGrade === 0
                    ? h(NTag, { type: 'error' }, () => '一级')
                    : data.algorithmGrade === 1
                      ? h(NTag, { type: 'warning' }, () => '二级')
                      : data.algorithmGrade === 2
                        ? h(NTag, { type: 'info' }, () => '三级')
                        : data.algorithmGrade === 3
                          ? h(NTag, { type: 'success' }, () => '四级')
                          : h(NTag, () => '五级'),
                  // 算法名称和ID
                  h('span', data.algorithmName),
                  h('span', data.id)
                ])
              ]),
              h(NRow, { gutter: 10, style: { marginTop: '10px' } }, [
                h(NCol, { span: 7 },[
                  h('div', { style: { fontSize: '14px', textAlign: 'center' } }, [
                    h('span', '报警图片：')
                  ])
                ]),
                h(NCol, { span: 15 }, [
                  h('img', {
                    style: { height: '100px', width: '200px' },
                    src: 'http://192.168.2.53:9995/image/979fc62b9f3a4097933e6e0a0aed489d.jpg'
                  })
                ]),
                // h(NCol, { span: 12 }, [
                //   h(NSpace, { vertical: true, justify: 'space-between' }, [
                //     // h('div', [
                //     //   h(NButton, { quaternary: true, round: true }, () => data.cameraName || ''),
                //     //   h('div', { style: { fontSize: '14px' } }, [
                //     //     h(
                //     //       NButton,
                //     //       {
                //     //         quaternary: true,
                //     //         round: true,
                //     //         type: 'info',
                //     //         onClick: () => toLogPage(data)
                //     //       },
                //     //       () => '查看详情'
                //     //     )
                //     //   ])
                //     // ]),
                //     // h('div', { style: { display: 'flex', justifyContent: 'space-between', marginTop: '20px' } }, [
                //     //   h(
                //     //     NButton,
                //     //     {
                //     //       strong: true,
                //     //       secondary: true,
                //     //       size: 'small',
                //     //       // onClick: () => modifyAlramStatus(data.id, '1')
                //     //       style: {
                //     //         color: 'white',
                //     //         backgroundColor: '#2196f3'
                //     //       }
                //     //     },
                //     //     () => '正确报警'
                //     //   ),
                //     //   h(
                //     //     NButton,
                //     //     {
                //     //       strong: true,
                //     //       secondary: true,
                //     //       size: 'small',
                //     //       style: { marginLeft: '20px', color: 'white', backgroundColor: '#f57b70' }
                //     //       // onClick: () => modifyAlramStatus(data.id, '2')
                //     //     },
                //     //     () => '错误报警'
                //     //   )
                //     // ])
                //   ])
                // ])
              ])
            ])
        });
      }
      // 处理收到的消息
    };

    // 连接关闭时触发
    ws.onclose = function (event) {
      console.log('WebSocket连接关闭');
      // 连接关闭后可以进行重连等操作
    };

    // 连接发生错误时触发
    ws.onerror = function (event) {
      console.error('WebSocket连接发生错误:', event);
    };
  } else {
    console.error('当前浏览器不支持WebSocket');
  }
}

export function sendMsg(msg: string) {
  ws.send(msg);
}
