let severName = 'ai';
let ws = null;
// 定义WebSocket连接的URL
var webSocketUrl = `ws://192.168.2.53:8080/ws/${severName}`;

export function connect() {
  if ('WebSocket' in window) {
    ws = new WebSocket(webSocketUrl);
    // 连接成功时触发
    ws.onopen = function (event) {
      console.log('WebSocket连接成功');
      // 可以在这里发送消息给服务器
      // websocket.send('消息内容');
    };
    // 接收到消息时触发
    ws.onmessage = function (event) {
      console.log('收到服务器消息:', event.data);
      // 处理收到的消息
    };

    // 连接关闭时触发
    ws.onclose = function (event) {
      console.log('WebSocket连接关闭');
      // 连接关闭后可以进行重连等操作
    };

    // 连接发生错误时触发
    ws.onerror = function (event) {
      console.error('WebSocket连接发生错误:', event);
    };
  } else {
    console.error('当前浏览器不支持WebSocket');
  }
}
export function sendMsg(msg) {
  ws.send(msg);
}
