
import { Notification } from 'element-ui';
import request from '@/utils/request';
import { Tools } from './common';

//var baseAPI = process.env.VUE_APP_LOCAL_API + '/';
var baseAPI = process.env.NODE_ENV === 'development' ? process.env.VUE_APP_LOCAL_API + '/' : (VUE_APP_API.ServiceURL || process.env.VUE_APP_LOCAL_API) + '/';
var DownloadUrl = process.env.VUE_APP_Download + '/';

var reqPublic = function(url, type, param, opts){
	type = type.toLowerCase();
	var paramKey = type === 'get' ? 'params' : 'data', opts = opts || {};
	var reqConfig = {
		url: url,
		method: type,
	};
	reqConfig[paramKey] = param;
	opts.responseType && (reqConfig['responseType'] = opts.responseType);
	opts.key && (reqConfig['token'] = opts.key);
	return request(reqConfig)
};

var reqApis = function(){
	return {
		getRules: function (baseInfo) {
			var rules = {};
			for (var key in baseInfo) {
				var item = baseInfo[key];
				if (item.must) {
					var typeStr = item.type ? '请选择' : '请输入';
					var rule = { required: true, message: typeStr + item.name, trigger: 'blur' };
					item.ruleType && (rule.type = item.ruleType)
					rules[key] = [rule];
				};
			}; return Object.keys(rules)[0] ? rules : void 0;
		},
		getBaseParams: function (searchItem) {
			var searchItem = reqApi.common.getSearchParam(this.form, searchItem) || {};
			var param = searchItem || {};
			param.page = this.table.page - 1;
			param.size = this.table.size;
			param.sort = 'date,desc';
			return param;
		},
		common:{
			requst:function(type, url, param){
				var param = param || {};
				var opts = this.query || {};
				return qf.Async.Promise((resolve, reject) => {
					reqPublic(url, type, param, opts).then((res)=>{
						return resolve(res)
					}).catch(function(error) {
						console.log('requst catch ________________ ', error);
						return reject(error);
					});
				});
			},
			getRequst: function (searchItem) {
				var param = reqApi.getBaseParams.call(this, searchItem);
				this.table.loading = true;
				return this.pageApi.request('get', param).then((res) => {
					this.table.loading = false;
					if (res && res.code) {
						var body = res.body || {};
						var list = body.list || [];
						this.table.dataList = list;
						this.table.total = body.total * 1;
						this.table.body = body;
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};return body
				}).catch(function (error) {
					this.table.loading = false;
				})
			},
			requstEdge:function(type, url, param){
				var param = param || {};
				return new Promise((resolve, reject) => {
					reqPublic(url, type, param).then((res)=>{
						if(res && (res.code === 200 || res.status === 200)){
							return resolve(res)
						}else{
							Notification({
								title: res.status + ': ' + (res.msg || res.message),
								type: 'error',
								duration: 2500
							});
							return reject(res);
						};
					}).catch(function(error) {
						console.log('catch ________________ ', error);
						return reject(error);
					});
				})
			},
			addRequst: function (item) {
				return this.pageApi.request('post', item).then((res) => {
					this.form.visible = false;
					if (res.code === 200) {
						this.$notify({
							title: '添加成功！',
							type: 'success',
							duration: 2500
						});
						this.loadData(this.baseParams || void 0)
					} else {
						this.$notify({
							type: 'error',
							title: res.msg,
							duration: 2500
						})
					};
				}).catch(function (error) {
					this.form.status.cu = 0
				});
			},
			removeRequst: function (item) {
				var table = this.table;
				return this.pageApi.request('delete', item).then((res) => {
					if (res.code === 200) {
						this.$notify({
							title: '删除成功！',
							type: 'success',
							duration: 2500
						});

						// 为空时返回前一页
						(table.dataList.length === 1) && table.page--;
						this.loadData(this.baseParams || void 0)
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				});
			},
			putRequst: function (item) {
				return this.pageApi.request('put', item).then((res) => {
					this.form.visible = false;
					if (res.code === 200) {
						this.$notify({
							title: '修改成功！',
							type: 'success',
							duration: 2500
						});
						this.loadData(this.baseParams || void 0)
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				}).catch(function (error) {
					this.form.status.cu = 0
				});
			},
			upload: function (e, pathName, file) {
				var that = this, tag = e.target || e.srcElement;
				var file = file || tag.files[0];
				if (file) {
					this.fullLoading = this.$loading({
						lock: true,
						text: 'Loading',
						spinner: 'el-icon-loading',
						background: 'rgba(0, 0, 0, 0.7)'
					});
					var data = new FormData();
					data.append('file', file);
					data.append('modelName', pathName);
					return this.pageApi.upload(data).then((res) => {
						this.fullLoading.close();
						if (res.code === 200) {
							tag && (tag.value = '');
							this.$notify({
								title: '提示',
								message: '文件上传成功',
								type: 'success',
								duration: 5000
							}); return res.body;
						};
					}).catch(function (error) {
						that.form.status.cu = 0
					});
				};
			},
			getSearchParam: function (form, searchItem) {
				var search = form.config.search, query = form.query, searchItem = searchItem || {};
				if (Object.prototype.toString.call(search) === '[object Array]' && Object.keys(query || [])[0]) {
					for (var item of search) {
						var queryVal = query[item.word];
						if ((queryVal || typeof queryVal === 'number') && item.type !== "button") {
							var key = item.mode === 0 ? 'vague' : 'exact';
							if (item.type.indexOf('date') > -1) {
								if(item.datetype === 'year'){
									var groub = searchItem[key] || (searchItem[key] = {});
									groub[item.word] = queryVal.split('-')[0];
								}else{
									searchItem[item.word || item.type] = queryVal.join(',');
								};
							} else {
								var groub = searchItem[key] || (searchItem[key] = {});
								groub[item.word] = queryVal;
							};
						};
					};
				}; return searchItem
			},
			toSearch: function (form) {
				this.table.page = 1;
				var searchItem = {
					searchName: form.search.key,
					searchValue: form.query[form.search.key],
					limit: form.search.mode
				}
				this.loadData(searchItem)
			},
			toDownload: function (item) {
				var download = this.pageApi.download;
				var filePath = download.filePath;
				var fileName = item[download.keyName].indexOf('.') > 0 ? item[download.keyName] : '';
				if (filePath && fileName) {
					window.open(DownloadUrl + filePath + fileName);
				} else {
					this.$notify({
						title: '提示',
						message: '未找到要下载的文件！',
						type: 'warning',
						duration: 5000
					})
				};
			},
			toAdd: function (data) {		// 添加表单
				this.$refs['form1'] && this.$refs['form1'].clearValidate();
				this.form.title = '添加' + this.form.config.title;
				this.form.status.cu = 0;
				this.form.visible = true;
				this.form.reqType = 'add';
				var item = data || {}, Dict = this.Dict;
				for (var key in Dict.baseInfo) {
					var obj = Dict.baseInfo[key];
					item[key] = obj.default || obj.dataType || '';
				};
				this.form.item = item;
				Dict.addFormItem && Dict.addFormItem.call(this, item);
			},
			toEdit: function (item) {		// 添加表单
				var form = this.form, Dict = this.Dict;
				var cuForm = this.$refs['cuForm'];
				cuForm.$refs['form1'] && cuForm.$refs['form1'].clearValidate();
				form.title = '编辑' + form.config.title;
				form.status.cu = 0;
				form.visible = true;
				form.reqType = 'edit';
				form.item = item;
				Dict.editFormItem && Dict.editFormItem.call(this, item);
			},
			toDelete: function (item, opts) {		// 删除表单
				opts = opts || {};
				var text = opts.text || '确认删除该条数据吗?';
				this.$confirm(text, '提示', {
					confirmButtonText: '确定',
					cancelButtonText: '取消',
					type: 'warning'
				}).then((e) => {
					reqApi.common.removeRequst.call(this, item);
				}).catch((e) => {
				})
			},
			submitForm: function (form, item) {
				if (!this.form.status.cu) {
					form.validate(valid => {
						if (valid) {
							this.form.status.cu = 2;
							if (this.form.reqType === 'add') {
								reqApi.common.addRequst.call(this, item);
							} else {
								reqApi.common.putRequst.call(this, item);
							}
						} else {
							this.form.status.cu = 0
						}
					});
				};
			},
			toExports: function (item) {
				this.$confirm('您确认要导出该页数据吗?', '提示', {
					confirmButtonText: '确定',
					cancelButtonText: '取消',
					type: 'warning'
				}).then((e) => {
					var loading = this.$loading({
						lock: true,
						text: '请稍后.....',
						spinner: 'el-icon-loading',
						background: 'rgba(0, 0, 0, 0.7)'
					});
					var param = reqApi.getBaseParams.call(this);
					this.pageApi.download(param).then((res) => {
						loading.close();
						var name = this.pageApi.name + '数据' + Tools.Dates.format('yyyy-MM-dd HH:mm:ss');
						Tools.downloadFile(res, name, 'xlsx')
					})
				})
			},
			getPermission: function (item) {
				var list = item.permission || [];
				var username = this.$store.state.user.user.username;
				return list.includes(username);
			},
		},

		business: {
			incubator: {		// 孵化器管理
				name: '孵化器管理',
				Dict: {
					baseInfo: {
						"incubatorName": {name:"孵化器名称", must:true },
						"operatingAgency": {name:"运营机构", must:true},
						"contactPerson": {name:"联系人", must:true },
						"contactPhone": {name:"联系电话", must:true },
						"incubatorImage": {name:"孵化器图片", type:'img', 
							'src': function (row, key) {
								var path = row[key];
								return path ? baseAPI + 'file/' + row[key] : ''
							},
							'change': function (e, key) {
								var tag = e.target || e.srcElement, that = this;
								reqApi.common.upload.call(this, e, 'incubator').then(function(res){
									that.form.item[key] = res;
								});
							},
							'click': function(src){
								qf.UI.popupLayer({
									html: '<div style="position:relative;width:13rem;height:80vh;display:flex;justify-content:center;"></div>',
									onload: function (el) {
										var box = el.firstElementChild;
										var url = baseAPI + 'file/' + src;
										box.innerHTML = '<img style="margin-top:25px;max-width:100%;" src="'+url+'"/>';
									},
								})
							},
						},
						"totalArea": {name:"孵化器使用总面积（㎡）", table:0, },
						"incubationArea": {name:"用于企业孵化的面积（㎡）", table:0, },
						"address":{
							name:"孵化器地址",/* must:true, */disabled: true, type:'map', style:"display:flex",
							mapHeight:'260px',
							mapConfig: {
								options: {
									zoom: 12,
									center: [122.04789902023334, 37.50932209221578],
									//showLabel: true,
									//pitch: 40,
									onload: function (cmap) {
										var item = this.form.item, self = this;
										this.Dict.cmap = cmap;
										if (item.longitude && item.latitude) {
											cmap.setCenter([item.longitude, item.latitude]);

											// 添加标记
											cmap.addMarker({
												lnglat: [item.longitude, item.latitude],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
														self.$forceUpdate();
													});
												},
											});
										};
									},
									click: function (e, cmap) {
										var that = this, lnglat = e.lnglat, form = this.form, item = form.item;
										// 如果为添加
										if (this.form.reqType === 'add') {
											cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
												form.item.address = addr;
												form.item.longitude = lnglat.lng;
												form.item.latitude = lnglat.lat;
											});

											cmap.marker && cmap.removeMarker();

											// 添加标记
											cmap.addMarker({
												lnglat: [lnglat.lng, lnglat.lat],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
													});
												},
											});
										};
									},
								},
							},
						},
						"longitude":{name:"经度", table:0, form:0 },
						"latitude":{name:"纬度", table:0, form:0 },
						"createTime":{name:"添加时间", table:0, form:0},
					},
					selectList: {
					},
				},
				config: {
					formWidth: '900px',
					labelWidth: '120',
					operWidth: '220',
					title: '孵化器',
					buttons: [
						{
							'type': 'primary', 'icon': 'el-icon-view', name: '查看收入', 'callback': function (item) {
								//window.location.href = '/business/income';
								var id = item.id;
								var popupTabel = this.$parent.popupTabel;
								popupTabel.status.cu = 1;
								popupTabel.close = function(){
									popupTabel.status.cu = 0;
								};
								reqPublic('/api/incubator/incubatorRevenue', 'get', {page:0,size:100, id:id}).then(function (res) {
									var list = res.list || [];
									if(list[0]){
										popupTabel.dataList = list;
									};
								});
							}
						},
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加孵化器', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '孵化器名称', 'word': 'incubatorName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('api/incubator', type, param)
				},
				upload: function (data) {
					return reqPublic('api/file/upload', 'post', data)
				},
			},
			income: {		// 孵化器收入管理
				name: '孵化器管理',
				Dict: {
					baseInfo: {
						"incubatorId": {name:"孵化器名称", must:true, 'type':'select', val:'id', key:'name', showYN: Tools.isHighTech()},
						"year": {
							name:"年度", must:true, 'type':'date', 'datetype':'year','format':'yyyy'
						},
						"totalRevenue": {name:"孵化器总收入（万元）", must:true },
						"serviceRevenue": {name:"综合服务收入(万元)", },
						// "rentRevenue": {name:"房租及物业收入(万元)", },
						"propertyRevenue": {name:"物业费收入(万元)", },
						"rentRevenue": {name:"房租费收入(万元)", },
						"investmentRevenue": {name:"投资收入（万元）", },
						"policyRevenue": {name:"政策性收入（万元）", },
						"otherRevenue": {name:"其他收入（万元）", },
						"createBy": {name:"创建人", table:0, form:0},
						"createTime": {name:"创建日期", table:0, form:0},
					},
					selectList: {
						incubatorId: function () {
							return reqPublic('/api/incubator/list', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '900px',
					labelWidth: '120',
					operWidth: '140',
					title: '孵化器收入',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加收入信息', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '孵化器名称', 'word': 'incubatorName', 'mode': 0, 'width': '180px',  showYN: Tools.isHighTech(), 'clear': function () {
								this.loadData()
							}
						},
						{ 
							'type': 'date', 'datetype':'year','defaultTime': ['2024'], 'name': '年度', 'word': 'year', 'mode': 0, 'width':'140px',
							'change': function(a, b){
							},
						},
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('api/incubatorRevenue', type, param)
				},
			},
			basicInfo: {		// 企业基本信息  mode:7(默认元素隐藏，通过其他元素改变主动触发显示)
				name: '企业基本信息',
				Dict: {
					baseInfo: {
						"companyName": {name:"企业名称", must:true,width: 215},
						"incubatorId": {name:"所属孵化器", must:true, 'type':'select', key:'name', showYN: Tools.isHighTech()},
						"technicalField": {name:"所属技术领域", must:true, 'type':'select', key:'name', },

						"entryDate": {
							name:"入驻时间", must:true, 'type':'date', 'format':'yyyy-MM-dd', 
						},
						"founderCharacteristics": {name:"主要负责人创业特征", must:true, table:0, 'type':'select', key:'name', },
						"companyType": {name:"企业类型", must:true, 'type':'select', key:'name', },
						"legalPerson": { 'type': '', 'name': '法人', table:0, width: 215  },
						"address":{
							name:"位置",/* must:true, disabled: true,type:'map',style:"display:flex",*/ table:0, width: 215,
							mapConfig: {
								options: {
									zoom: 12,
									center: [122.050189, 37.515189],
									//showLabel: true,
									//pitch: 40,
									onload: function (cmap) {
										var item = this.form.item, self = this;
										this.Dict.cmap = cmap;
										var center = cmap.options.center;
										var lng = item.longitude || center[0], lat = item.latitude || center[1];
										if (lng && lat) {
											cmap.setCenter([lng, lat]);

											// 添加标记
											cmap.addMarker({
												lnglat: [lng, lat],
												title: '',
												draggable: true,
												dragend: function (e) {
													item = self.form.item;
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
														self.$forceUpdate();
													});
												},
											});
										};
									},
									click: function (e, cmap) {
										var that = this, lnglat = e.lnglat, form = this.form, item = form.item;
										// 如果为添加
										if (this.form.reqType === 'add') {
											cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
												form.item.address = addr;
												form.item.longitude = lnglat.lng;
												form.item.latitude = lnglat.lat;
											});
											cmap.marker && cmap.removeMarker();

											// 添加标记
											cmap.addMarker({
												lnglat: [lnglat.lng, lnglat.lat],
												title: '', 
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
													});
												},
											});
										};
									},
								},
							},
						},
						// "longitude": {name:"经度", must:true, table:0, form:0 },
						// "latitude": {name:"纬度", must:true, table:0, form:0 },
						"mentorId": {name:"全职导师", table:0, 'type':'select', key:'name',},
						"parMentorId": { 'type': 'select', 'name': '兼职导师', table:0, width: 215  },
						"outsideIncubation": { 'type': 'select', 'name': '是否体外孵化', table:0, },
						"occupiedArea": {name:"占用孵化场地面积", table:0,width: 215 },
						"principal": {name:"联系人", must:true ,width: 215},
						"contactPhone": {name:"联系方式", must:true ,width: 215},
						// "intellectualProperty": {name:"知识产权", table:0, 'type':'select', key:'name',},
						"totalFunding": {name:"累计获得融资总额(万元)", table:0,width: 215},
						"registeredCapital": { 'type': '', 'name': '注册资金(万元)', table:0, width: 215 },
						"incubationStatus": {name:"企业孵化状态", 'type':'select',
							change: function (val){
								var Dict = this.Dict, slist = Dict.selectList, fitem = this.form.item;
								Dict.baseInfo.graduationDate.form = ~~(val === 2);
							}
						},
						"graduationDate": {name:"毕业日期", type:"date", table:0, form:0},
						// 新增字段
						"companyLevel": { 'type': 'select', 'name': '企业级别', table:0 },
						"technicalField": { 'type': 'select', 'name': '所属技术领域',  },
					
						"inventionPatentsNumber": { 'type': '', 'name': '发明专利数(件)', table:0, width: 215 },
						"inventionApplicationsNumber": { 'type': '', 'name': '发明申请数(件)', table:0, width: 215  },
						"utilityModelsNumber": { 'type': '', 'name': '实用新型数(件)', table:0, width: 215  },
						"softwareCopyrightNumber": { 'type': '', 'name': '软件著作权数（件）', table:0, width: 215  },
						// 新增字段
					
					
						// 后台没有这个字段，目前有联系方式这个字段，是否为同一个。还是说新增的为导师的联系方式？
						// "legalPerson": { 'type': '', 'name': '联系电话', table:0,  },
						// 字段已有！
						// "registeredCapital": { 'type': 'date', 'name': '注册资金', table:0,  },
					
						"investorsName": { 'type': '', 'name': '投资方名称', table:0, width: 215  },
						"investmentArea": { 'type': '', 'name': '投资地区', table:0, width: 215  },
						"registerDate": { 'type': 'date', 'name': '注册时间', table:0, width: 215  },
						



						
						
						"isTechSme": { 'type': 'select', 'name': '是否科技型中小企业', table:0, inputCombine_1:'Y', inputCombineArr_1: {
								"isTechSme":{'name': '是否科技型中小企业','type':'select'},
								"techSmeDate":{'name':'最新评选日期'},
							},
						}, // inputCombine_1 组合框中的父输入框
						"techSmeDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7, inputCombine_2:'Y',inputCombineArr_2: {}},
					
						"isHighTech": { 'type': 'select', 'name': '是否高新技术企业', table:0, inputCombine_1:'Y' , inputCombineArr_1: {
							"isHighTech":{'name': '是否高新技术企业','type':'select'},
							"highTechDate":{'name':'最新评选日期'},
						}},
						"highTechDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7, inputCombine_2:'Y',inputCombineArr_2: {}},
						
						"isSpecializedSpecialEnterprises": { 'type': 'select', 'name': '是否专精特新企业', table:0, inputCombine_1:'Y' , inputCombineArr_1: {
							"isSpecializedSpecialEnterprises":{'name': '是否专精特新企业','type':'select'},
							"specializedSpecialEnterprisesDate":{'name':'最新评选日期'},
						}},
						"specializedSpecialEnterprisesDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7, inputCombine_2:'Y',inputCombineArr_2: {}},
						
						"isGazelle": { 'type': 'select', 'name': '是否瞪羚企业', table:0, inputCombine_1:'Y' , inputCombineArr_1: {
							"isGazelle":{'name': '是否瞪羚企业','type':'select'},
							"gazelleDate":{'name':'最新评选日期'},
						}},
						"gazelleDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7,  inputCombine_2:'Y',inputCombineArr_2: {}},
						
						"isLittleGiant": { 'type': 'select', 'name': '是否小巨人企业', table:0, inputCombine_1:'Y' , inputCombineArr_1: {
							"isLittleGiant":{'name': '是否小巨人企业','type':'select'},
							"littleGiantDate":{'name':'最新评选日期'},
						}},
						"littleGiantDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7,  inputCombine_2:'Y',inputCombineArr_2: {}},
						
						"isHighGrowthInnovative": { 'type': 'select', 'name': '是否创新性中小企业', table:0, inputCombine_1:'Y', inputCombineArr_1: {
							"isHighGrowthInnovative":{'name': '是否创新性中小企业','type':'select'},
							"highGrowthInnovativeDate":{'name':'最新评选日期'},
						}},
						"highGrowthInnovativeDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7, inputCombine_2:'Y',inputCombineArr_2: {}},
						
						"isAdvancedTechService": { 'type': 'select', 'name': '是否技术先进型服务企业', table:0, inputCombine_1:'Y', inputCombineArr_1: {
							"isAdvancedTechService":{'name': '是否技术先进型服务企业','type':'select'},
							"advancedTechServiceDate":{'name':'最新评选日期'},
						}},
						"advancedTechServiceDate": { 'type': 'date', 'name': '最新评选日期', table:0, mode:7,  inputCombine_2:'Y',inputCombineArr_2: {}},
						"introduction": {
							name:"企业介绍", table:0, style:"display:block", 'type':'editor',
							'change': function (file, pathBack) {
								reqApi.common.upload.call(this, file, 'introduction', file).then(function(res){
									var url = baseAPI + 'file/' + res;
									pathBack(url, '', '')
								});
							}
						},
					

				

						

						//"createBy": {name:"创建人ID", table:0},
						//"createTime": {name:"创建时间", },
					},
					selectList: {
						incubatorId: function () {
							var slist = this.selectList;
							return reqPublic('api/company/dic', 'get', {}).then(function (res) {
								var body = res.body || {};
								for (var key in body) {
									var val = body[key];
									slist[key] = val
								}; return body.incubatorId;
							});
						},
						isHighTech: [{ name: '是', value: true, }, { name: '否', value: false, },],
						isTechSme: [{ name: '是', value: true, }, { name: '否', value: false, },],
						isHighGrowthInnovative: [{ name: '是', value: true, }, { name: '否', value: false, },],
						isAdvancedTechService: [{ name: '是', value: true, }, { name: '否', value: false, },],

						isGazelle: [{ name: '是', value: true, }, { name: '否', value: false, },],

						isLittleGiant: [{ name: '是', value: true, }, { name: '否', value: false, },],
						isSpecializedSpecialEnterprises: [{ name: '是', value: true, }, { name: '否', value: false, },],

						
						companyType:[{"name":"服务企业","value":2},{"name":"中介机构","value":1}],
						incubationStatus:[{"name":"在孵化企业","value":1},{"name":"毕业企业","value":2}],
						// 新增 241103
						outsideIncubation:  [{ name: '是', value: true, }, { name: '否', value: false, },],
					},
				},
				config: {
					formWidth: '900px',
					labelWidth: '150',
					operWidth: '210',
					title: '企业信息',
					buttons: [
						{
							'fn': 'toSee', 'type': 'primary', 'icon': 'el-icon-edit', name: '查看', 'callback': function(item) {
								item = Object.assign({}, item);
								this.$parent.basicActv = true;
								// for( let key in item){
								// 	if(item[key] === false){
								// 	  item[key] = true
								// 	}
								// 	// if(key.indexOf('Date')>-1){
								// 	//   item[key] = ''
								// 	// }
								//   }
								this.$parent.catchItem = item;
								// 标签索引复位
								this.$parent.tabindex = 0;
							}
						},
						// {
						// 	'fn': 'toEdit', 'type': 'primary', name: '经营信息管理', 'callback': function (item) {
						// 		item = Object.assign({}, item);
						// 		var that = this.$parent;
						// 		tha// t.iframeSrc = '/business/achievement?companyId=1';
						// 		that.popupTabel.status.cu = 1;
						// 	}
						// },
						// {
						// 	'fn': 'toEdit', 'type': 'primary', name: '产品管理', 'callback': function (item) {
						// 		item = Object.assign({}, item);
						// 	}
						// },
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							type: 'primary', icon: 'el-icon-document', name: '导出企业基本信息', showYN: true, 'callback': function () {
								// reqApi.common.toExports.call(this);
								this.$confirm('您确认要导出该页数据吗?', '提示', {
									confirmButtonText: '确定',
									cancelButtonText: '取消',
									type: 'warning'
								}).then((e) => {
									var loading = this.$loading({
										lock: true,
										text: '请稍后.....',
										spinner: 'el-icon-loading',
										background: 'rgba(0, 0, 0, 0.7)'
									});
									var param = reqApi.getBaseParams.call(this);
									this.pageApi.downloadEnterpriseExcelBasic(param).then((res) => {
										loading.close();
										var name = '企业基本信息数据' + Tools.Dates.format('yyyy-MM-dd HH:mm:ss');
										Tools.downloadFile(res, name, 'xlsx')
									})
								})
							}
						},
						{
							type: 'primary', icon: 'el-icon-document', name: '导出企业经营信息', showYN: true, 'callback': function () {
								// reqApi.common.toExports.call(this);
								this.$confirm('您确认要导出该页数据吗?', '提示', {
									confirmButtonText: '确定',
									cancelButtonText: '取消',
									type: 'warning'
								}).then((e) => {
									var loading = this.$loading({
										lock: true,
										text: '请稍后.....',
										spinner: 'el-icon-loading',
										background: 'rgba(0, 0, 0, 0.7)'
									});
									var param = reqApi.getBaseParams.call(this);
									this.pageApi.downloadEnterpriseExcelJy(param).then((res) => {
										loading.close();
										var name = '企业经营信息数据' + Tools.Dates.format('yyyy-MM-dd HH:mm:ss');
										Tools.downloadFile(res, name, 'xlsx')
									})
								})
							}
						},
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加企业', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						},
						{
							type: 'primary', icon: 'el-icon-folder-add', name: '导入企业基础信息', showYN: !Tools.isHighTech(), 'callback':function(){
								var m = this;
								m.uploadView = qf.UI.popWindow({
									cover:true,
									coverFull: true,
									className:'qyzz-dialog',
									//container:b0_e,		// id || Element对象
									//backgroundColor:'rgba(0,0,0,.4);backdrop-filter:blur(15px);',
									closeEvent:true,
									html:`
										<div role="dialog" aria-modal="true" aria-label="信息导入" class="el-dialog" style="width:500px;">
										<div class="el-dialog__header"><span class="el-dialog__title">信息导入</span><button type="button" aria-label="Close" class="el-dialog__headerbtn"><i class="el-dialog__close el-icon el-icon-close"></i></button></div>
										<div class="el-dialog__body">
											<div class="el-form-item el-form-item--small">
												<label for="incubatorImage" class="el-form-item__label" style="width: 120px;">上传企业信息</label>
												<div class="el-form-item__content">
													<div class="img-upload">
														<input type="file" id="kimUpload" accept=".xls,.xlsx" >
													</div>
												</div>
											</div>
											<div class="el-form-item el-form-item--small">
												<div class="el-form-item__content">
														<input type="checkbox" id="updateJCYN" value="yes"> 是否更新已存在企业基础信息数据
												</div>
											</div>
											<div style="color:red;">仅允许导入xls、xlsx格式文件</div>
											
										</div>
										<div class="el-dialog__footer"><div class="dialog-footer"><button type="button" class="el-button el-button--text el-button--small cancel">取消</button><button type="button" class="el-button el-button--primary el-button--small confirm">确认</button></div></div>
										</div>
									`,
									onload: function(v){
										m.loginView = v;
										var el = v.el;
										v.file = el.querySelector("#kimUpload");
										v.updateJCYN = el.querySelector("#updateJCYN");
									},
									click: function(tag){
										if(tag.classList.contains('el-icon-close')){	// 移除
											m.uploadView.remove()
										}else if(tag.classList.contains('confirm')){
											var file = m.loginView.file.files[0];
											m.uploadView.remove();
											if(file){
												m.fullLoading = m.$loading({
													lock: true,
													text: 'Loading',
													spinner: 'el-icon-loading',
													background: 'rgba(0, 0, 0, 0.7)'
												});
												var data = new FormData();
												data.append('file', file);
												data.append('flag', m.loginView.updateJCYN.checked) // 是否更新
												return m.pageApi.uploadfile(data).then((res) => {
													m.fullLoading.close();
													if(res.code === 200){
														//m.loginView.file.value = '';
														m.loadData()
													};
													m.$notify({
														title: '提示',
														message: res.msg,
														type: 'success',
														duration: 5000,
														zIndex:2000,
													})
												}).catch(function(error) {
												});
											};
										}else if(tag.classList.contains('cancel')){		// 取消
											m.uploadView.remove()
										};
									},
									close: function(e){
									},
								});
							}
						},
						{
							type: 'primary', icon: 'el-icon-folder-add', name: '导入企业经营信息', 'callback':function(){
								var m = this;
								m.uploadView = qf.UI.popWindow({
									cover:true,
									coverFull: true,
									className:'qyzz-dialog',
									//container:b0_e,		// id || Element对象
									//backgroundColor:'rgba(0,0,0,.4);backdrop-filter:blur(15px);',
									closeEvent:true,
									html:`
										<div role="dialog" aria-modal="true" aria-label="经营信息导入" class="el-dialog" style="width:500px;">
										<div class="el-dialog__header"><span class="el-dialog__title">经营信息导入</span><button type="button" aria-label="Close" class="el-dialog__headerbtn"><i class="el-dialog__close el-icon el-icon-close"></i></button></div>
										<div class="el-dialog__body">
											<div class="el-form-item el-form-item--small">
												<label for="incubatorImage" class="el-form-item__label" style="width: 120px;">上传经营信息</label>
												<div class="el-form-item__content">
													<div class="img-upload">
														<input type="file" id="kimUpload1" accept=".xls,.xlsx" >
													</div>
												</div>
											</div>
											<div class="el-form-item el-form-item--small">
												<div class="el-form-item__content">
														<input type="checkbox" id="updateJYYN" value="yes"> 是否更新已存在企业经营信息数据(同年份同企业)
												</div>
											</div>
											<div style="color:red;">仅允许导入xls、xlsx格式文件</div>
										</div>
										<div class="el-dialog__footer"><div class="dialog-footer"><button type="button" class="el-button el-button--text el-button--small cancel">取消</button><button type="button" class="el-button el-button--primary el-button--small confirm">确认</button></div></div>
										</div>
									`,
									onload: function(v){
										m.loginView = v;
										var el = v.el;
										v.file = el.querySelector("#kimUpload1");
										v.updateJYYN = el.querySelector("#updateJYYN");
									},
									click: function(tag){
										// console.log(m.loginView.updateJYYN.checked)

										if(tag.classList.contains('el-icon-close')){	// 移除
											m.uploadView.remove()
										}else if(tag.classList.contains('confirm')){
											var file = m.loginView.file.files[0];
											m.uploadView.remove();
											if(file){
												m.fullLoading = m.$loading({
													lock: true,
													text: 'Loading',
													spinner: 'el-icon-loading',
													background: 'rgba(0, 0, 0, 0.7)'
												});
												var data = new FormData();
												data.append('file', file);
												data.append('flag', m.loginView.updateJYYN.checked) // 是否更新
												return m.pageApi.uploadjyfile(data).then((res) => {
													m.fullLoading.close();
													if(res.code === 200){
														//m.loginView.file.value = '';
														m.loadData()
													};
													m.$notify({
														title: '提示',
														message: res.msg,
														type: 'success',
														duration: 5000,
														zIndex:2000,
													})
												}).catch(function(error) {
												});
											};
										}else if(tag.classList.contains('cancel')){		// 取消
											m.uploadView.remove()
										};
									},
									close: function(e){
									},
								});
							}
						},
					],
					rightBtn: [
						{
							fn:'download', type:'primary', name:'下载企业基础信息模板', 'callback':function(){
								window.open(baseAPI + 'api/company/exportTemplate');
							}
						},
						{
							fn:'download', type:'primary', name:'下载企业经营信息模板', 'callback':function(){
								window.open(baseAPI + 'api/companyAnnualInfo/exportTemplate');
							}
						},
					],
					search: [
						{
							'type': 'string', 'name': '企业名称', 'word': 'companyName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'string', 'name': '孵化器名称', 'word': 'incubatorName', 'mode': 0, 'width': '180px',  showYN: Tools.isHighTech(), 'clear': function () {
								this.loadData()
							}
						},
						{ 'type': 'select', 'name': '在孵状态', 'word': 'incubationStatus', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '企业类型', 'word': 'companyType', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '企业级别', 'word': 'companyLevel', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '所属技术领域', 'word': 'technicalField', 'mode': 9, 'width': '140px' },
						{ 'type': 'select', 'name': '创新创业类型', 'word': 'innovationEntrepreneurship', 'mode': 1, 'width': '140px' },
						{ 'type': 'daterange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '300px', format: 'yyyy-MM-dd' },
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('api/company', type, param)
				},
				upload: function (data) {
					return reqPublic('api/file/upload', 'post', data)
				},
				uploadfile: function (data) {
					return reqPublic('api/company/import', 'post', data)
				},
				uploadjyfile: function (data) {
					return reqPublic('api/companyAnnualInfo/import', 'post', data)
				},
				downloadEnterpriseExcelBasic: function (param) {
					return reqPublic('api/company/exportExcel', 'get', param, { responseType: 'blob' })
				},
				downloadEnterpriseExcelJy: function (param) {
					return reqPublic('api/companyAnnualInfo/exportExcel', 'get', param, { responseType: 'blob' })
				},
			},
			product: {		// 产品信息
				name: '企业产品信息',
				Dict: {
					baseInfo: {
						"productName": {name:"产品名称", must:true},
						"image": {
							name:"图片", must:true, type:'img', 
							'src': function (row, key) {
								var path = row[key];
								return path ? baseAPI + 'file/' + row[key] : ''
							},
							'change': function (e, key) {
								var tag = e.target || e.srcElement, that = this;
								reqApi.common.upload.call(this, e, 'product').then(function(res){
									that.form.item[key] = res;
								});
							}
						},
						"description": {name:"简介", must:true, type:'textarea', width:300, rows:4},
						// "isDisplayed": {name:"是否在大屏显示", must:true, 'type':'select', },
					},
					selectList: {
						isDisplayed: [{ name: '是', value: true, }, { name: '否', value: false, },],
					},
				},
				config: {
					formWidth: '600px',
					labelWidth: '120',
					operWidth: '140',
					title: '添加产品',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加产品', 'callback': function () {
								reqApi.common.toAdd.call(this, {companyId:this.companyId});
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '产品名称', 'word': 'productName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								var param = new URLSearchParams(window.location.search);
								var companyId = param.get('companyId');
								this.loadData({exact:{companyId:companyId}})
							}
						},
					],
				},
				request: function (type, param) {
					var searchParam = new URLSearchParams(window.location.search);
					var companyId = searchParam.get('companyId');
					if(companyId){
						if(param.exact){ // 有exact则直接追加companyId 没有则新增值
							param.exact.companyId = companyId
						}else{ 
							param.exact = {
								companyId
							}
						}
					}
					return reqPublic('api/companyProduct', type, param)
				},
				upload: function (data) {
					return reqPublic('api/file/upload', 'post', data)
				},
			},
			achievement: {		// 经营信息
				name: '企业经营信息',
				Dict: {
					baseInfo: {
						"year": {name:"年度", must:true, 'type':'date', 'datetype':'year','format':'yyyy', },
						"totalEmployees": {name:"从业人数", must:true },
						"phdEmployees": {name:"博士从业人数",  },
						"overseasEmployees": {name:"留学人数",  },
						"masterEmployees": { 'name': '硕士人数',  },
						"undergraduateEmployees": { 'name': '本科人数', },
						// "revenueLastYear": {name:"上年营收收入(万元)", must:true},
						"netProfit": {name:"净利润(万元)", must:true},
						"taxesPaid": {name:"上缴税费(万元)"},
						"grossIncome": {name:"总收入(万元)", table:0,},
						"researchInput": {name:"研发投入(万元)"},
						"investmentProportion": {name:"研发投入占比", disabled:true},
						
					},
					selectList: {
						incubatorId: function () {
							return reqPublic('/api/incubator/list', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '600px',
					labelWidth: '120',
					operWidth: '140',
					title: '经营信息',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加经营信息', 'callback': function () {
								reqApi.common.toAdd.call(this, {companyId:this.companyId});
							}
						}
					],
					rightBtn: [
					],
					search: [
						{ 
							'type': 'date', 'datetype':'year','defaultTime': ['2024'], 'name': '年度', 'word': 'year', 'mode': 0, 'width':'140px',
							'change': function(a, b){
							},
						},
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								var param = new URLSearchParams(window.location.search);
								var companyId = param.get('companyId');
								this.loadData({exact:{companyId:companyId}})
							}
						},
					],
				},
				request: function (type, param) {
					var searchParam = new URLSearchParams(window.location.search);
					var companyId = searchParam.get('companyId');
					if(companyId){
						if(param.exact){ // 有exact则直接追加companyId 没有则新增值
							param.exact.companyId = companyId
						}else{ 
							param.exact = {
								companyId
							}
						}
					}
					
					return reqPublic('api/companyAnnualInfo', type, param)
				},
			},
			mentor: {		// 导师管理
				name: '导师管理',
				Dict: {
					baseInfo: {
						"mentorName": {name:"导师姓名", must:true},
						"incubatorId": {name:"所属孵化器", must:true, 'type':'select', key:'name', showYN: Tools.isHighTech()},
						"education": {name:"学历", must:true },
						"graduationSchool": {name:"毕业学校",  },
						"contactPhone": {name:"联系电话",  },
						"photo": {
							name:"照片", type:'img', 
							'src': function (row, key) {
								var path = row[key];
								return path ? baseAPI + 'file/' + row[key] : ''
							},
							'change': function (e, key) {
								var tag = e.target || e.srcElement, that = this;
								reqApi.common.upload.call(this, e, 'mentor').then(function(res){
									that.form.item[key] = res;
								});
							}
						},
						"introduction": {
							name:"导师介绍", table:0, style:"display:block", 'type':'editor',
							'change': function (file, pathBack) {
								reqApi.common.upload.call(this, file, 'introduction', file).then(function(res){
									var url = baseAPI + 'file/' + res;
									pathBack(url, '', '')
								});
							}
						},
						"createTime": {name:"创建时间", form:0},
					},
					selectList: {
						incubatorId: function () {
							var slist = this.selectList;
							return reqPublic('api/company/dic', 'get', {}).then(function (res) {
								var body = res.body || {};
								for (var key in body) {
									var val = body[key];
									slist[key] = val
								}; return body.incubatorId;
							});
						},
						
						
					},
				},
				config: {
					formWidth: '600px',
					labelWidth: '120',
					operWidth: '140',
					title: '导师',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加导师', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '导师姓名', 'word': 'mentorName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'string', 'name': '孵化器名称', 'word': 'incubatorName', 'mode': 0, 'width': '180px',  showYN: Tools.isHighTech(), 'clear': function () {
								this.loadData()
							}
						},
						{ 'type': 'daterange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '300px', format: 'yyyy-MM-dd' },
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('api/mentor', type, param)
				},
				upload: function (data) {
					return reqPublic('api/file/upload', 'post', data)
				},
			},
			statistics: {		// 信息统计
				name: '信息统计',
				Dict: {
					baseInfo: {
						"companyName": {name:"企业名称", must:true, 'width': '300px', fixed: true,},
						
						"incubatorName": {name:"所属孵化器", must:true,  key:'name', 'width': '180px',  fixed: true,},
						"entryDate": {name:"入驻时间", 'width': '180px', },
						"companyType": {name:"企业类型", 'type':'select', key:'name','width': '180px', },
						"incubationStatus": {name:"企业孵化状态", 'type':'select', key:'name','width': '180px', },
						
						"principal": {name:"企业负责人",  key:'name', 'width': '200px',},
						"contactPhone": {name:"联系方式",'width': '180px', },
						"technicalFieldName": {name:"企业所属技术领域", must:true, key:'name', 'width': '180px'},
						"inventionPatentsNumber": {name:"发明专利数（件）", must:true, key:'name', 'width': '180px', },
						"inventionApplicationsNumber": {name:"发明申请数（件)", must:true, key:'name', 'width': '180px', },

						"utilityModelsNumber": {name:"实用新型数（件)", must:true, key:'name', 'width': '180px',},

						"softwareCopyrightNumber": {name:"软件著作权数（件)", must:true, key:'name', 'width': '180px',},
						// "companyLevel": {name:"企业级别", must:true, 'type':'select', key:'name', 'width': '180px',},
						"companyLevelName": {name:"企业级别", must:true,  key:'name', 'width': '180px',},
						"totalEmployees": {name:"今年从业人数（人）", must:true, key:'name', 'width': '180px',},
						"phdEmployees": {name:"博士人数（人）", must:true, key:'name', 'width': '180px',},
						"overseasEmployees": {name:"留学人数（人）", must:true, key:'name', 'width': '180px',},
						// "revenueLastYear": {name:"上年营业收入（万元）", must:true, key:'name', 'width': '180px',},
						"netProfit": {name:"净利润（万元）", must:true, key:'name', 'width': '180px',},
						"taxesPaid": {name:"上缴税费（万元）", must:true, key:'name', 'width': '180px',},
						"investmentProportion": {name:"研发投入占比", must:true, key:'name', 'width': '180px',},
						"grossIncome": {name:"总收入（万元）", must:true, key:'name', 'width': '180px',},
						"researchInput": {name:"研发投入（万元）", must:true, key:'name', 'width': '180px',},

						// "mentorId": {name:"创业导师", 'type':'select', key:'name','width': '180px',},
					
						"totalEmployees": {name:"今年从业人数（人）", must:true, key:'name', 'width': '180px',},
						"phdEmployees": {name:"博士人数（人）", must:true, key:'name', 'width': '180px',},
						"overseasEmployees": {name:"留学人数（人）", must:true, key:'name', 'width': '180px',},
						//"revenueLastYear": {name:"上年营业收入（万元）", must:true, key:'name', 'width': '180px',},
						"netProfit": {name:"净利润（万元）", must:true, key:'name', 'width': '180px',},
						"taxesPaid": {name:"上缴税费（万元）", must:true, key:'name', 'width': '180px',},
						"investmentProportion": {name:"研发投入占比", must:true, key:'name', 'width': '180px',},
						"grossIncome": {name:"总收入（万元）", must:true, key:'name', 'width': '180px',},
						"researchInput": {name:"研发投入（万元）", must:true, key:'name', 'width': '180px',},

						// "mentorId": {name:"创业导师", 'type':'select', key:'name','width': '180px',},
					},
					selectList: {
						incubatorId: function(slist) {
							return reqPublic('api/company/dic', 'get', {}).then(function (res) {
								var body = res.body || {};
								for (var key in body) {
									var val = body[key];
									slist[key] = val;
								}; return body.incubatorId;
							});
						},
						companyType:[{"name":"服务企业","value":2},{"name":"中介机构","value":1}],

					},
				},
				config: {
					formWidth: '600px',
					labelWidth: '120',
					operWidth: '140',
					title: '信息统计',
					buttons: [
					],
					otherBtn: [
					],
					rightBtn: [
						{
							type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
								reqApi.common.toExports.call(this);
							}
						},
					],
					search: [
						{
							'type': 'string', 'name': '孵化器名称', 'word': 'incubatorName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'string', 'name': '企业名称', 'word': 'companyName', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{ 'type': 'select', 'name': '在孵状态', 'word': 'incubationStatus', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '企业类型', 'word': 'companyType', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '企业级别', 'word': 'companyLevel', 'mode': 1, 'width': '140px' },
						{ 'type': 'select', 'name': '所属技术领域', 'word': 'technicalField', 'mode': 9, 'width': '140px' },
						{ 'type': 'select', 'name': '创新创业类型', 'word': 'innovationEntrepreneurship', 'mode': 1, 'width': '140px' },
						{ 'type': 'daterange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '300px', format: 'yyyy-MM-dd' },
						{
							'type': 'button', 'label': '查询', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('api/company/incubatorStats', type, param)
				},
				download: function (param) {
					return reqPublic('api/company/exportIncubatorStats', 'get', param, { responseType: 'blob' })
				},
			},
		}
	};
};

// 配制信息
var Config = function () {
	// 获取单元信息
	var getModuleInfo = function (that) {
		var path = that.$route.path || '';
		var parts = path.replace('/', '').split('/');
		var i = 0;
		// 递归遍历
		return (function loop(json) {
			var key = parts[i]; i++;
			return json[key] ? loop(json[key]) : json;
		})(reqApi);
	};
	return { getModuleInfo: getModuleInfo }
};


//export var tailingPond = tailingPond();
export var reqApi = reqApis();
export var Config = Config();

// WEBPACK FOOTER //
// ./src/common/js/common.js