import axios from 'axios';
import { localStg } from '@/utils/storage';

axios.defaults.baseURL = '/v1';

axios.interceptors.request.use(
  req => {
    const token = localStorage.getItem('token');
    if (token) req.headers.token = `${token}`;

    return req;
  },
  e => Promise.reject(e)
);

axios.interceptors.response.use(
  res => {
    if (res.status == 401) {
      window.location.href = '/login';
    }
    return res;
  },
  e => {
    window.location.href = '/login';
  }
);

export const api_loginPost = async (data: any): Promise<any> => await axios.post('/login', data);

// token
export const api_tokenGet = async (): Promise<any> => await axios.get(`/api/token`);

// ------------------- 菜单管理接口 ------------------
export const api_menuPageGet = async (data: any): Promise<any> =>
  await axios.get(`/menu/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`);

// ------------------- 用户管理接口 ------------------
export const api_userPageGet = async (data: any): Promise<any> =>
  await axios.get(`/user/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&startTime=${data.startTime}&endTime=${data.endTime}&username=${data.username}&depName=${data.depname}`);

export const api_addUser = async (data: any): Promise<any> => await axios.post('/user', data);

export const api_updateUser = async (data: any): Promise<any> => await axios.put('/user', data);

export const api_deleteUser = async (ids: any): Promise<any> => await axios.delete(`/user/${ids}`);

export const api_exportUserData = async (ids: any): Promise<any> => await axios.get(`/user/export/${ids}`, { responseType: 'blob' })

export const api_getUserById = async (id: any): Promise<any> => await axios.get(`/user/${id}`);

export const api_getPosList = async (): Promise<any> => await axios.get('/pos/list');

export const api_getRoleList = async (): Promise<any> => await axios.get('/role/list');

export const api_getDepList = async (): Promise<any> => await axios.get('/dep/list');

export const api_putPassword = async (data:any): Promise<any> => await axios.put(`/user/password/${data.id}/${data.password}`);

// ------------------- 角色管理接口 ------------------
export const api_rolePage = async (data: any): Promise<any> =>
  await axios.get(`/role/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&roleName=${data.rolename}&startTime=${data.startTime}&endTime=${data.endTime}`);

export const api_addRole = async (data: any): Promise<any> => await axios.post('/role', data);

export const api_updateRole = async (data: any): Promise<any> => await axios.put('/role', data);

export const api_deleteRole = async (ids: any): Promise<any> => await axios.delete(`/role/${ids}`);

export const api_exportRoleData = async (ids: any): Promise<any> => await axios.get(`/role/export/${ids}`, { responseType: 'blob' })

export const api_getUserRole = async (id: any): Promise<any> => await axios.get(`/role/${id}`);


//  ------------------- 岗位管理接口 ------------------
export const api_posPage = async (data: any): Promise<any> =>
  await axios.get(`/pos/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&posName=${data.posname}&startTime=${data.startTime}&endTime=${data.endTime}`);

export const api_addPos = async (data: any): Promise<any> => await axios.post('/pos', data);

export const api_updatePos = async (data: any): Promise<any> => await axios.put('/pos', data);

export const api_deletePos = async (ids: any): Promise<any> => await axios.delete(`/pos/${ids}`);

export const api_exportPosData = async (ids: any): Promise<any> => await axios.get(`/pos/export/${ids}`, { responseType: 'blob' })

export const api_getUserPos = async (id: any): Promise<any> => await axios.get(`/pos/${id}`);

//  ------------------- 部门管理接口 ------------------
export const api_depPage = async (data: any): Promise<any> =>
  await axios.get(`/dep/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&depName=${data.depName}&startTime=${data.startTime}&endTime=${data.endTime}`);

export const api_addDep = async (data: any): Promise<any> => await axios.post('/dep', data);

export const api_updateDep = async (data: any): Promise<any> => await axios.put('/dep', data);

export const api_deleteDep = async (ids: any): Promise<any> => await axios.delete(`/dep/${ids}`);

export const api_exportDepData = async (ids: any): Promise<any> => await axios.get(`/dep/export/${ids}`, { responseType: 'blob' })

export const api_getUserDep = async (id: any): Promise<any> => await axios.get(`/dep/${id}`);


//  ------------------- 登录日志接口 ------------------
export const api_loginLog = async (data: any): Promise<any> => await axios.get(`/login/log/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&startTime=${data.startTime}&endTime=${data.endTime}&username=${data.username}`);

//  ------------------- 日志接口 ------------------
export const api_operatePage = async (data: any): Promise<any> => await axios.get(`/operate/log/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&startTime=${data.startTime}&endTime=${data.endTime}&username=${data.username}`);

export const api_operateLog = async (id: any): Promise<any> => await axios.get(`/operate/log/${id}`);

//  ------------------- 越界开采接口 ------------------
export const api_fenceCarPage = async (data: any): Promise<any> => await axios.get(`/fence/page/car?pageNum=${data.pageNum}&pageSize=${data.pageSize}&rangeName=${data.rangeName}`);

export const api_fencePersonPage = async (data: any): Promise<any> => await axios.get(`/fence/page/person?pageNum=${data.pageNum}&pageSize=${data.pageSize}&rangeName=${data.rangeName}`);

export const userLoginAPI = async (data: any): Promise<any> => await axios.post('/login', data);

export const addFenceApi = async (data: any): Promise<any> => await axios.post('/fence', data);

export const getTreeNodeApi = async (): Promise<any> => await axios.get('/fence/tree');

export const deleteFenceApi = async (id: string): Promise<any> => await axios.delete(`/fence/${id}`);

export const getFenceByIdApi = async (id: string): Promise<any> => await axios.get(`/fence/${id}`);

export const updateFenceApi = async (id: any, rangeName: any): Promise<any> => await axios.put(`/fence/${id}/${rangeName}`)

export const getFenceListApi = async (ids: any): Promise<any> => await axios.get(`/fence/list/${ids}`);

//   ------------------- 地形图接口 ------------------
export const getPageApi = async (data: any): Promise<any> => await axios.get(`/information/image/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`);

export const postImageApi = async (data: any): Promise<any> => await axios.post('/information/image', data);

export const postuploadApi = async (file: any): Promise<any> => await axios.post('/information/image/upload/iamge', file);

export const deleteImageApi = async (id: any): Promise<any> => await axios.delete(`/information/image/${id}`);

//   ------------------- 模型接口 ------------------
export const getModelPageApi = async (data: any): Promise<any> => await axios.get(`/information/model/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`);

export const postModelApi = async (data: any): Promise<any> => await axios.post('/information/model', data);

export const postModeluploadApi = async (file: any): Promise<any> => await axios.post('/information/model/file', file);

export const deleteModelApi = async (id: any): Promise<any> => await axios.delete(`/information/model/${id}`);

//   ------------------- 人员定位 ------------------
export const getPersonRealApi = async (id: any): Promise<any> => await axios.delete(`/person/real/getPersonRealById`, id);

export const getPersonRealListApi = async (data: any): Promise<any> => await axios.delete(`/person/real/getPersonRealList`, data);

// 电子围栏
export const getFenceListsApi = async (): Promise<any> => await axios.get(`/fence/list`);

// 查询最新模型
export const getModelNewApi = async (): Promise<any> => await axios.get(`/information/model/new`);

// 获取所有人员信息
export const getModelAllApi = async (): Promise<any> => await axios.get(`/person/point/all/person`);

// 查询所有人员实时位置
export const getPointAllPersonApi = async (): Promise<any> => await axios.get(`/person/point/all/person/location`);

// 查询人员轨迹
export const getPersonPointApi = async (data:any): Promise<any> => await axios.post(`/person/point/trajectory`,data);


//   ------------------- 越界开采报警接口 ------------------

export const getFencePageApi = async (data:any): Promise<any> => await axios.get(`/fence/log/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&username=${data.username}&carNumber=${data.carNumber}&startTime=${data.startTime}&endTime=${data.endTime}`);

export const getFenceeExportApi = async (ids:any): Promise<any> => await axios.get(`/fence/log/export/${ids}`, { responseType: 'blob' });

export const putFenceeLogApi = async (data:any): Promise<any> => await axios.put(`/fence/log/${data.id}/${data.status}`);

export const delFenceLogApi = async (ids:any): Promise<any> => await axios.delete(`/fence/log/${ids}`,);

// 大屏信息
export const getCarPointAllCarApi = async (): Promise<any> => await axios.get(`/car/point/all/car/location`);

export const getHomeCarApi = async (carNumber:any): Promise<any> => await axios.get(`/home/car/${carNumber}`);

export const getCemeraPointApi = async (): Promise<any> => await axios.get(`/home/camera/point`);

export const getCameraIdApi = async (id:any): Promise<any> => await axios.get(`/home/camera/${id}`);

export const getMonitorPointApi = async (): Promise<any> => await axios.get(`/home/monitor/point`);

export const getMonitorIdApi = async (id:any): Promise<any> => await axios.get(`/home/monitor/${id}`);


// 卡调
export const getCarPointCarNumberApi = async (): Promise<any> => await axios.get(`/car/point/carNumber`,);
// 查询车辆轨迹
export const getCarPointApi = async (data:any): Promise<any> => await axios.post(`/car/point/trajectory`,data);
// 摄像头
export const getPointListApi = async (): Promise<any> => await axios.get(`/cameras/point/list`,);
