/* eslint-disable */
/* prettier-ignore */
// Generated by elegant-router
// Read more: https://github.com/soybeanjs/elegant-router

declare module "@elegant-router/types" {
  type ElegantConstRoute = import('@elegant-router/vue').ElegantConstRoute;

  /**
   * route layout
   */
  export type RouteLayout = "base" | "blank";

  /**
   * route map
   */
  export type RouteMap = {
    "root": "/";
    "not-found": "/:pathMatch(.*)*";
    "403": "/403";
    "404": "/404";
    "500": "/500";
    "ai": "/ai";
    "ai_home": "/ai/home";
    "ai_jieguo": "/ai/jieguo";
    "ai_shexiang": "/ai/shexiang";
    "ai_shipin": "/ai/shipin";
    "ai_suanfa": "/ai/suanfa";
    "ai_tixing": "/ai/tixing";
    "ai_tuisong": "/ai/tuisong";
    "casting": "/casting";
    "casting_data": "/casting/data";
    "casting_data_detection": "/casting/data/detection";
    "casting_data_rainfall": "/casting/data/rainfall";
    "casting_home": "/casting/home";
    "casting_monitor": "/casting/monitor";
    "casting_monitor_entering": "/casting/monitor/entering";
    "casting_monitor_manage": "/casting/monitor/manage";
    "casting_police": "/casting/police";
    "casting_police_list": "/casting/police/list";
    "casting_police_setting": "/casting/police/setting";
    "casting_polling": "/casting/polling";
    "casting_polling_manage": "/casting/polling/manage";
    "casting_polling_result": "/casting/polling/result";
    "casting_polling_typemanage": "/casting/polling/typemanage";
    "casting_system": "/casting/system";
    "casting_system_casting": "/casting/system/casting";
    "casting_system_equipment": "/casting/system/equipment";
    "casting_system_modeldata": "/casting/system/modeldata";
    "casting_system_modelmanage": "/casting/system/modelmanage";
    "casting_system_monitor": "/casting/system/monitor";
    "cesiumdeom": "/cesiumdeom";
    "home": "/home";
    "home_police": "/home/police";
    "home_rail": "/home/rail";
    "home_rail_car": "/home/rail/car";
    "home_rail_person": "/home/rail/person";
    "iframe-page": "/iframe-page/:url";
    "login": "/login/:module(pwd-login|code-login|register|reset-pwd|bind-wechat)?";
    "monitoring": "/monitoring";
    "monitoring_data": "/monitoring/data";
    "monitoring_data_detection": "/monitoring/data/detection";
    "monitoring_data_rainfall": "/monitoring/data/rainfall";
    "monitoring_home": "/monitoring/home";
    "monitoring_monitor": "/monitoring/monitor";
    "monitoring_monitor_entering": "/monitoring/monitor/entering";
    "monitoring_monitor_manage": "/monitoring/monitor/manage";
    "monitoring_police": "/monitoring/police";
    "monitoring_police_list": "/monitoring/police/list";
    "monitoring_police_setting": "/monitoring/police/setting";
    "monitoring_polling": "/monitoring/polling";
    "monitoring_polling_manage": "/monitoring/polling/manage";
    "monitoring_polling_result": "/monitoring/polling/result";
    "monitoring_polling_typemanage": "/monitoring/polling/typemanage";
    "monitoring_system": "/monitoring/system";
    "monitoring_system_equipment": "/monitoring/system/equipment";
    "monitoring_system_modeldata": "/monitoring/system/modeldata";
    "monitoring_system_modelmanage": "/monitoring/system/modelmanage";
    "monitoring_system_monitor": "/monitoring/system/monitor";
    "orientation": "/orientation";
    "orientation_monitor": "/orientation/monitor";
    "orientation_monitor_facility": "/orientation/monitor/facility";
    "orientation_monitor_history": "/orientation/monitor/history";
    "orientation_video": "/orientation/video";
    "personnel": "/personnel";
    "personnel_facility": "/personnel/facility";
    "personnel_manage": "/personnel/manage";
    "personnel_manage_personnel": "/personnel/manage/personnel";
    "personnel_manage_staff": "/personnel/manage/staff";
    "personnel_manage_visitor": "/personnel/manage/visitor";
    "personnel_realtime": "/personnel/realtime";
    "personnel_sos": "/personnel/sos";
    "personnel_statistics": "/personnel/statistics";
    "personnel_statistics_distribution": "/personnel/statistics/distribution";
    "personnel_statistics_police": "/personnel/statistics/police";
    "personnel_statistics_sheet": "/personnel/statistics/sheet";
    "personnel_statistics_statis": "/personnel/statistics/statis";
    "personnel_track": "/personnel/track";
    "truck": "/truck";
    "truck_area": "/truck/area";
    "truck_area_classes": "/truck/area/classes";
    "truck_area_message": "/truck/area/message";
    "truck_car": "/truck/car";
    "truck_car_cartype": "/truck/car/cartype";
    "truck_car_fault": "/truck/car/fault";
    "truck_car_maintain": "/truck/car/maintain";
    "truck_car_message": "/truck/car/message";
    "truck_car_playback": "/truck/car/playback";
    "truck_car_track": "/truck/car/track";
    "truck_car_type": "/truck/car/type";
    "truck_safety": "/truck/safety";
    "truck_safety_report": "/truck/safety/report";
    "truck_safety_security": "/truck/safety/security";
    "truck_smart": "/truck/smart";
    "truck_vehicle": "/truck/vehicle";
    "truck_video": "/truck/video";
    "truck_video_history": "/truck/video/history";
    "truck_video_monitoring": "/truck/video/monitoring";
    "user": "/user";
    "user_bumen": "/user/bumen";
    "user_caidan": "/user/caidan";
    "user_gangwei": "/user/gangwei";
    "user_juese": "/user/juese";
    "user_log": "/user/log";
    "user_log_loginlog": "/user/log/loginlog";
    "user_log_operatelog": "/user/log/operatelog";
    "user_model": "/user/model";
    "user_model_dixing": "/user/model/dixing";
    "user_model_kuangqu": "/user/model/kuangqu";
    "user_yonghu": "/user/yonghu";
  };

  /**
   * route key
   */
  export type RouteKey = keyof RouteMap;

  /**
   * route path
   */
  export type RoutePath = RouteMap[RouteKey];

  /**
   * custom route key
   */
  export type CustomRouteKey = Extract<
    RouteKey,
    | "root"
    | "not-found"
  >;

  /**
   * the generated route key
   */
  export type GeneratedRouteKey = Exclude<RouteKey, CustomRouteKey>;

  /**
   * the first level route key, which contain the layout of the route
   */
  export type FirstLevelRouteKey = Extract<
    RouteKey,
    | "403"
    | "404"
    | "500"
    | "ai"
    | "casting"
    | "cesiumdeom"
    | "home"
    | "iframe-page"
    | "login"
    | "monitoring"
    | "orientation"
    | "personnel"
    | "truck"
    | "user"
  >;

  /**
   * the custom first level route key
   */
  export type CustomFirstLevelRouteKey = Extract<
    CustomRouteKey,
    | "root"
    | "not-found"
  >;

  /**
   * the last level route key, which has the page file
   */
  export type LastLevelRouteKey = Extract<
    RouteKey,
    | "403"
    | "404"
    | "500"
    | "cesiumdeom"
    | "iframe-page"
    | "login"
    | "ai_home"
    | "ai_jieguo"
    | "ai_shexiang"
    | "ai_shipin"
    | "ai_suanfa"
    | "ai_tixing"
    | "ai_tuisong"
    | "casting_data_detection"
    | "casting_data"
    | "casting_data_rainfall"
    | "casting_home"
    | "casting_monitor_entering"
    | "casting_monitor"
    | "casting_monitor_manage"
    | "casting_police"
    | "casting_police_list"
    | "casting_police_setting"
    | "casting_polling"
    | "casting_polling_manage"
    | "casting_polling_result"
    | "casting_polling_typemanage"
    | "casting_system_casting"
    | "casting_system_equipment"
    | "casting_system"
    | "casting_system_modeldata"
    | "casting_system_modelmanage"
    | "casting_system_monitor"
    | "home"
    | "home_police"
    | "home_rail_car"
    | "home_rail"
    | "home_rail_person"
    | "monitoring_data_detection"
    | "monitoring_data"
    | "monitoring_data_rainfall"
    | "monitoring_home"
    | "monitoring_monitor_entering"
    | "monitoring_monitor"
    | "monitoring_monitor_manage"
    | "monitoring_police"
    | "monitoring_police_list"
    | "monitoring_police_setting"
    | "monitoring_polling"
    | "monitoring_polling_manage"
    | "monitoring_polling_result"
    | "monitoring_polling_typemanage"
    | "monitoring_system_equipment"
    | "monitoring_system"
    | "monitoring_system_modeldata"
    | "monitoring_system_modelmanage"
    | "monitoring_system_monitor"
    | "orientation_monitor_facility"
    | "orientation_monitor_history"
    | "orientation_monitor"
    | "orientation_video"
    | "personnel_facility"
    | "personnel_manage"
    | "personnel_manage_personnel"
    | "personnel_manage_staff"
    | "personnel_manage_visitor"
    | "personnel_realtime"
    | "personnel_sos"
    | "personnel_statistics_distribution"
    | "personnel_statistics"
    | "personnel_statistics_police"
    | "personnel_statistics_sheet"
    | "personnel_statistics_statis"
    | "personnel_track"
    | "truck_area_classes"
    | "truck_area"
    | "truck_area_message"
    | "truck_car_cartype"
    | "truck_car_fault"
    | "truck_car"
    | "truck_car_maintain"
    | "truck_car_message"
    | "truck_car_playback"
    | "truck_car_track"
    | "truck_car_type"
    | "truck_safety"
    | "truck_safety_report"
    | "truck_safety_security"
    | "truck_smart"
    | "truck_vehicle"
    | "truck_video_history"
    | "truck_video"
    | "truck_video_monitoring"
    | "user_bumen"
    | "user_caidan"
    | "user_gangwei"
    | "user_juese"
    | "user_log"
    | "user_log_loginlog"
    | "user_log_operatelog"
    | "user_model_dixing"
    | "user_model"
    | "user_model_kuangqu"
    | "user_yonghu"
  >;

  /**
   * the custom last level route key
   */
  export type CustomLastLevelRouteKey = Extract<
    CustomRouteKey,
    | "root"
    | "not-found"
  >;

  /**
   * the single level route key
   */
  export type SingleLevelRouteKey = FirstLevelRouteKey & LastLevelRouteKey;

  /**
   * the custom single level route key
   */
  export type CustomSingleLevelRouteKey = CustomFirstLevelRouteKey & CustomLastLevelRouteKey;

  /**
   * the first level route key, but not the single level
  */
  export type FirstLevelRouteNotSingleKey = Exclude<FirstLevelRouteKey, SingleLevelRouteKey>;

  /**
   * the custom first level route key, but not the single level
   */
  export type CustomFirstLevelRouteNotSingleKey = Exclude<CustomFirstLevelRouteKey, CustomSingleLevelRouteKey>;

  /**
   * the center level route key
   */
  export type CenterLevelRouteKey = Exclude<GeneratedRouteKey, FirstLevelRouteKey | LastLevelRouteKey>;

  /**
   * the custom center level route key
   */
  export type CustomCenterLevelRouteKey = Exclude<CustomRouteKey, CustomFirstLevelRouteKey | CustomLastLevelRouteKey>;

  /**
   * the center level route key
   */
  type GetChildRouteKey<K extends RouteKey, T extends RouteKey = RouteKey> = T extends `${K}_${infer R}`
    ? R extends `${string}_${string}`
      ? never
      : T
    : never;

  /**
   * the single level route
   */
  type SingleLevelRoute<K extends SingleLevelRouteKey = SingleLevelRouteKey> = K extends string
    ? Omit<ElegantConstRoute, 'children'> & {
        name: K;
        path: RouteMap[K];
        component: `layout.${RouteLayout}$view.${K}`;
      }
    : never;

  /**
   * the last level route
   */
  type LastLevelRoute<K extends GeneratedRouteKey> = K extends LastLevelRouteKey
    ? Omit<ElegantConstRoute, 'children'> & {
        name: K;
        path: RouteMap[K];
        component: `view.${K}`;
      }
    : never;
  
  /**
   * the center level route
   */
  type CenterLevelRoute<K extends GeneratedRouteKey> = K extends CenterLevelRouteKey
    ? Omit<ElegantConstRoute, 'component'> & {
        name: K;
        path: RouteMap[K];
        children: (CenterLevelRoute<GetChildRouteKey<K>> | LastLevelRoute<GetChildRouteKey<K>>)[];
      }
    : never;

  /**
   * the multi level route
   */
  type MultiLevelRoute<K extends FirstLevelRouteNotSingleKey = FirstLevelRouteNotSingleKey> = K extends string
    ? ElegantConstRoute & {
        name: K;
        path: RouteMap[K];
        component: `layout.${RouteLayout}`;
        children: (CenterLevelRoute<GetChildRouteKey<K>> | LastLevelRoute<GetChildRouteKey<K>>)[];
      }
    : never;
  
  /**
   * the custom first level route
   */
  type CustomSingleLevelRoute<K extends CustomFirstLevelRouteKey = CustomFirstLevelRouteKey> = K extends string
    ? Omit<ElegantConstRoute, 'children'> & {
        name: K;
        path: RouteMap[K];
        component?: `layout.${RouteLayout}$view.${LastLevelRouteKey}`;
      }
    : never;

  /**
   * the custom last level route
   */
  type CustomLastLevelRoute<K extends CustomRouteKey> = K extends CustomLastLevelRouteKey
    ? Omit<ElegantConstRoute, 'children'> & {
        name: K;
        path: RouteMap[K];
        component?: `view.${LastLevelRouteKey}`;
      }
    : never;

  /**
   * the custom center level route
   */
  type CustomCenterLevelRoute<K extends CustomRouteKey> = K extends CustomCenterLevelRouteKey
    ? Omit<ElegantConstRoute, 'component'> & {
        name: K;
        path: RouteMap[K];
        children: (CustomCenterLevelRoute<GetChildRouteKey<K>> | CustomLastLevelRoute<GetChildRouteKey<K>>)[];
      }
    : never;

  /**
   * the custom multi level route
   */
  type CustomMultiLevelRoute<K extends CustomFirstLevelRouteNotSingleKey = CustomFirstLevelRouteNotSingleKey> =
    K extends string
      ? ElegantConstRoute & {
          name: K;
          path: RouteMap[K];
          component: `layout.${RouteLayout}`;
          children: (CustomCenterLevelRoute<GetChildRouteKey<K>> | CustomLastLevelRoute<GetChildRouteKey<K>>)[];
        }
      : never;

  /**
   * the custom route
   */
  type CustomRoute = CustomSingleLevelRoute | CustomMultiLevelRoute;

  /**
   * the generated route
   */
  type GeneratedRoute = SingleLevelRoute | MultiLevelRoute;

  /**
   * the elegant route
   */
  type ElegantRoute = GeneratedRoute | CustomRoute;
}
