export function carSpeed(data:any) {
    // 路程
    let totalDistance = 0;
    // 时间
    let totalTimeMs = 0;
    for (let i = 0; i < data.points.length - 1; i++) {
        const point1 = Cesium.Cartesian3.fromDegrees(data.points[i].lon, data.points[i].lat);
        const point2 = Cesium.Cartesian3.fromDegrees(data.points[i + 1].lon, data.points[i + 1].lat);
        totalDistance += Cesium.Cartesian3.distance(point1, point2);
        const time1 = new Date(data.points[i].createTime).getTime();
        const time2 = new Date(data.points[i + 1].createTime).getTime();
        const timeDiff = Math.abs(time2 - time1);  // 使用绝对值确保时间为正
        totalTimeMs += timeDiff;
    }
    const totalTimeHours = totalTimeMs / (1000 * 60 * 60);  // 转换为小时
    const totalDistanceKm = totalDistance / 1000;
    // 平均时速 (公里/小时)
    const averageSpeed = totalTimeHours > 0 ? totalDistanceKm / totalTimeHours : 0;

    return averageSpeed;
}