// 创建自定义圆形大头针的函数（使用 Canvas 动态生成）
export function createCustomPinImage() {
  const canvas = document.createElement('canvas');
  const size = 48; // 图标大小
  canvas.width = size;
  canvas.height = size * 2; // 包括杆子部分

  const context = canvas.getContext('2d');

  // 绘制红色圆圈（带白边）
  context.beginPath();
  context.arc(size / 2, size / 2, size / 2 - 4, 0, 2 * Math.PI); // 圆圈
  context.fillStyle = 'white'; // 白色边框
  context.fill();
  context.beginPath();
  context.arc(size / 2, size / 2, size / 2 - 8, 0, 2 * Math.PI); // 红色填充
  context.fillStyle = 'red';
  context.fill();

  // 绘制杆子（白色）
  context.fillStyle = 'white';
  context.fillRect(size / 2 - 2, size, 4, size); // 杆子从圆圈底部向下延伸

  return canvas.toDataURL('image/png'); // 返回 Base64 编码的图片
}

export async function getElevationFromRay(cartographic: any, viewer: any) {
  let ellipsoid;
  let startPoint;
  let surfaceNormal;
  let direction;
  let ray;
  return new Promise((resolve, reject) => {
    ellipsoid = viewer.scene.globe.ellipsoid;
    startPoint = Cesium.Cartesian3.fromRadians(
      cartographic.longitude,
      cartographic.latitude,
      200
    );

    surfaceNormal =
      viewer.scene.globe.ellipsoid.geodeticSurfaceNormal(startPoint);
    direction = Cesium.Cartesian3.negate(
      surfaceNormal,
      new Cesium.Cartesian3()
    );
    ray = new Cesium.Ray(startPoint, direction);
    const intersection = viewer.scene.pickFromRay(ray);
    if (intersection) {
      const cartographicPosition = Cesium.Cartographic.fromCartesian(
        intersection.position
      );
      resolve(cartographicPosition.height); // 返回高程
    } else {
      reject("未检测到交点");
    }
  })
}


export function deletePin(viewer: any, data: any){
  console.log(data);
  viewer.entities.remove(data.pin);
}

export function deletePins(viewer: any, data: any){
  for(let item of data){
    viewer.entities.remove(item.pin);
  }
}