export function cesiumToLongitudeAndLatitude(cartesian: any){
  var ellipsoid = Cesium.Ellipsoid.WGS84; // 使用WGS84椭球体
  var cartographic = ellipsoid.cartesianToCartographic(cartesian); // 转换为地理坐标（弧度表示）

  // 将弧度转换为度
  var longitude = Cesium.Math.toDegrees(cartographic.longitude); // 经度
  var latitude = Cesium.Math.toDegrees(cartographic.latitude); // 纬度
  var height = cartographic.height; // 高度（可选）

  return {
    x: longitude,
    y: latitude,
    z: height
  }
}