const fullScreen = (type) => {
  /**
   *  @name    fullScreen (全屏展现)
   *  @params  type[boolean] 标识
   *  @return !type[boolean] 将标识取反
   *  @description
   *          使用将控制全屏的相应数据即可， 例 this.fullType = FullScreen(this.fullType)。
   *  @author  cui cheng
   */

  let doc = document.documentElement,
    fullEvent = [
      "exitFullscreen",
      "webkitCancelFullScreen",
      "msExitFullscreen",
      "mozCancelFullsreen",

      "mozCancelFullScreen",
      "webkitExitFullscreen",
    ],
    resetEvent = [
      "requestFullscreen",
      "webkitRequestFullScreen",
      "mozRequestFullscreen",
      "msRequestFullscreen",
    ];

  /**
   *
   * if (document.fullscreenElement) { // 如果已经是全屏模式
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
      } else { // 如果不是全屏模式
            const element = document.documentElement;
            if (element.requestFullscreen) {
                element.requestFullscreen();
            } else if (element.mozRequestFullScreen) {
                element.mozRequestFullScreen();
            } else if (element.webkitRequestFullscreen) {
                element.webkitRequestFullscreen();
            } else if (element.msRequestFullscreen) {
                element.msRequestFullscreen();
            }
      }
   */


  /**
   *    已知放大差异：
   *        "exitFullscreen",
            "webkitCancelFullScreen",
            "msExitFullscreen",
            "mozCancelFullsreen",

        已知缩小差异：
            "requestFullscreen",
            "webkitRequestFullScreen",
            "mozRequestFullscreen",
            "msRequestFullscreen",
   */

  switch (type) {
    case true:
      fullEvent.forEach((full) => {
        document[full] && document[full]();
      });
      break;
    case false:
      resetEvent.forEach((reset) => {
        doc[reset] && doc[reset]();
      });
      break;
  }

  return !type;
};

export default fullScreen;
