import { createApp } from 'vue';
import { locale } from 'dayjs';
import './plugins/assets';
import ElementPlus from 'element-plus';
import { setupAppVersionNotification, setupDayjs, setupIconifyOffline, setupLoading, setupNProgress } from './plugins';
import { setupStore } from './store';
import { setupRouter } from './router';
import { setupI18n } from './locales';
import 'element-plus/dist/index.css';
import zhCn from 'element-plus/es/locale/lang/zh-cn';
import App from './App.vue';

async function setupApp() {
  setupLoading();

  setupNProgress();

  setupIconifyOffline();

  setupDayjs();

  const app = createApp(App);

  setupStore(app);

  await setupRouter(app);

  setupI18n(app);
  app.use(ElementPlus, { locale: zhCn });
  setupAppVersionNotification();
  app.mount('#app');
}

setupApp();
