import { ref } from 'vue';
import { getPointAllPersonApi } from '@/api';
import bluePersonIcon from '@/assets/blueperson.png';
import { getElevationFromRays } from '../cesiumUtil';

let personEntity: any;
const iconEntities = ref<any[]>([]);
const pins: any = [];
// 点位图标
export async function iconPoint(viewer: any, data: any, type: any) {
  console.log('--1--', data);

  const typeIcons = {
    person_: new URL('@/assets/blueperson.png', import.meta.url).href,
    car_: new URL('@/assets/icon15.png', import.meta.url).href,
    slope_: new URL('@/assets/icon17.png', import.meta.url).href,
    default: new URL('@/assets/blueperson.png', import.meta.url).href
  };

  // 清除所有以当前type前缀开头的实体，确保每次调用都是全新的
  const entitiesToRemove: any[] = [];
  viewer.entities.values.forEach((entity: any) => {
    if (typeof entity.id === 'string' && entity.id.startsWith(type)) {
      entitiesToRemove.push(entity);
    }
  });

  // 批量移除实体
  entitiesToRemove.forEach(entity => viewer.entities.remove(entity));

  for (let i = 0; i < data.value.length; i++) {
    const cartographic = Cesium.Cartographic.fromDegrees(data.value[i].lon, data.value[i].lat);
    const height = await getElevationFromRays(cartographic, viewer);
    // 将高度增加一些，确保标签和图标在地形上方
    const adjustedHeight = height + 1;
    const cartesian = Cesium.Cartesian3.fromRadians(cartographic.longitude, cartographic.latitude, adjustedHeight);
    const iconPath = typeIcons[type as keyof typeof typeIcons] || typeIcons.default;

    // 创建实体ID使用传入的type前缀
    const entityId = `${type}${i}`;

    // 检查是否已存在相同ID的实体，如果存在则移除
    const existingEntity = viewer.entities.getById(entityId);
    if (existingEntity) {
      viewer.entities.remove(existingEntity);
    }

    // 创建人员/车辆图标实体
    personEntity = viewer.entities.add({
      id: entityId, // 使用传入的type前缀确保唯一性
      position: cartesian,
      billboard: {
        image: iconPath,
        verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
        horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
        scale: 0.5,
        heightReference: Cesium.HeightReference.RELATIVE_TO_GROUND
      },
      properties: {
        type: data.value[i].type
      },
      // 存储人员数据
      personData: {
        index: i,
        info: data.value[i]
      }
    });

    // 创建标签框背景实体
    const entity = viewer.entities.add({
      position: cartesian,
      billboard: {
        image: new URL('../../../assets/titlePerson.png', import.meta.url).href,
        verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
        horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
        scale: 0.5,
        pixelOffset: new Cesium.Cartesian2(0, -30), // 位置在图标上方
        heightReference: Cesium.HeightReference.RELATIVE_TO_GROUND
      },
      properties: {
        type: data.value[i].type
      }
    });
    entity.billboard.width = 220; // 直接设置宽度
    entity.billboard.height = 50; // 直接设置高度

    // 创建名字标签实体
    const labelEntit = viewer.entities.add({
      position: cartesian,
      label: {
        text: data.value[i].carNumber || data.value[i].realName,
        font: 'bold 14px sans-serif',
        fillColor: Cesium.Color.WHITE,
        outlineColor: Cesium.Color.BLACK,
        outlineWidth: 2,
        style: Cesium.LabelStyle.FILL_AND_OUTLINE,
        pixelOffset: new Cesium.Cartesian2(0, -36), // 位置在标签框上方
        verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
        horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
        heightReference: Cesium.HeightReference.RELATIVE_TO_GROUND,
        scaleByDistance: new Cesium.NearFarScalar(1000, 1, 5000, 0.5),
        distanceDisplayCondition: new Cesium.DistanceDisplayCondition(0, 10000)
      },
      properties: {
        type: data.value[i].type
      }
    });

    iconEntities.value.push(personEntity, entity, labelEntit);

    pins.push({
      entity: personEntity,
      cardId: data.value[i].cardId,
      type: personEntity.id,
      position: cartesian,
      label: null,
      data: data.value[i]
    });
  }

  return pins;
}
