import axios from 'axios';
import { localStg } from '@/utils/storage';

axios.defaults.baseURL = '/v1';


axios.interceptors.request.use(
  req => {
    const token = localStorage.getItem('token');
    if (token) req.headers.token = `${token}`;

    return req;
  },
  e => Promise.reject(e)
);

axios.interceptors.response.use(
  res => {
    if (res.status === 401) {
      window.location.href = '/login';
    }
    return res;
  },
  e => {
    window.location.href = '/login';
  }
);


// ------------------- 大屏模块接口 ------------------
// 获取设备状态接口
export const getDeviceStatusInfo = async (): Promise<any> => await axios.get('/home/information/data');
// 获取SOS报警列表接口
export const getSosList = async (): Promise<any> => await axios.get('/home/sos/list');
// 获取车辆报警列表接口
export const getCarAlarmList = async (): Promise<any> => await axios.get('/home/car/alarm/list');
// 获取围栏日志列表接口
export const getFenceLogList = async (): Promise<any> => await axios.get('/home/fence/log/list');
// 获取在线报警列表接口
export const getOnlineAlarmList = async (): Promise<any> => await axios.get('/home/online/alarm/list');

// 获取雨量曲线接口
export const getRainCurve = async (): Promise<any> => await axios.get('/home/rain/curve');
// 获取环境数据接口
export const getEnvironmentData = async (): Promise<any> => await axios.get('/home/environment/data');
// 获取在线数据接口
export const getOnlineData = async (): Promise<any> => await axios.get('/home/online/data');

// 获取车辆日志列表接口
export const getCarLogList = async (): Promise<any> => await axios.get('home/car/log');


// 修改报警状态
export const setAlarmStatusApi = async (command: string): Promise<any> => await axios.post(`/home/sound/${command}`);
// 获取报警状态
export const getAlarmStatusApi = async (): Promise<any> => await axios.get('/home/alarm/status');

// export const getOnlineAlarmList = async (): Promise<any> => await axios.get('/home/online/alarm/list');
// export const getOnlineAlarmList = async (): Promise<any> => await axios.get('/home/online/alarm/list');
// export const getOnlineAlarmList = async (): Promise<any> => await axios.get('/home/online/alarm/list');





