export const create3D = async (viewer: any, url: any, height = 0) => {
  const tiles = await Cesium.Cesium3DTileset.fromUrl(url,
    {
      maximumScreenSpaceError: 1,
      pickable: true,
    }
  );

  create3D.id && viewer.scene.primitives.remove(create3D.id);
  var boundingSphere = tiles.boundingSphere;
  var cartographic = Cesium.Cartographic.fromCartesian(boundingSphere.center);
  var longitude = cartographic.longitude;
  var latitude = cartographic.latitude;
  var alt = cartographic.height;
  var origin = Cesium.Cartesian3.fromRadians(
    cartographic.longitude,
    cartographic.latitude,
    cartographic.height
  );
  var alt1 = alt + height;
  var offset = Cesium.Cartesian3.fromRadians(
    longitude,
    latitude,
    alt1
  );
  var translate = Cesium.Cartesian3.subtract(
    offset,
    origin,
    new Cesium.Cartesian3()
  );

  tiles.modelMatrix = Cesium.Matrix4.fromTranslation(translate);
  create3D.id = viewer.scene.primitives.add(tiles);
  viewer.zoomTo(tiles);
}

export function pointLine(viewer) {
  let polygonCoordList = [
    122.04454563914409,37.489284875763744,
    122.04561831986973,37.487027958982864,
    122.05006039343479,37.48821693911029,
    122.04881042851096,37.49135388724233,
  ]

  // 创建红色线圈
  viewer.entities.add({
    id: 'allTotalArea',
    name: 'allTotalArea',
    polyline: {
      positions: Cesium.Cartesian3.fromDegreesArray(polygonCoordList),
      width: 4,
      material: Cesium.Color.RED,
      clampToGround: true, // 禁用贴地
    },
  })
}