const local: App.I18n.Schema = {
  system: {
    title: '金润四化综合管理平台',
    updateTitle: '系统版本更新通知',
    updateContent: '检测到系统有新版本发布，是否立即刷新页面？',
    updateConfirm: '立即刷新',
    updateCancel: '稍后再说'
  },
  common: {
    action: '操作',
    add: '新增',
    addSuccess: '添加成功',
    backToHome: '返回首页',
    batchDelete: '批量删除',
    cancel: '取消',
    close: '关闭',
    check: '勾选',
    expandColumn: '展开列',
    columnSetting: '列设置',
    config: '配置',
    confirm: '确认',
    delete: '删除',
    deleteSuccess: '删除成功',
    confirmDelete: '确认删除吗？',
    edit: '编辑',
    warning: '警告',
    error: '错误',
    index: '序号',
    keywordSearch: '请输入关键词搜索',
    logout: '退出登录',
    logoutConfirm: '确认退出登录吗？',
    lookForward: '敬请期待',
    modify: '修改',
    modifySuccess: '修改成功',
    noData: '无数据',
    operate: '操作',
    pleaseCheckValue: '请检查输入的值是否合法',
    refresh: '刷新',
    reset: '重置',
    search: '搜索',
    switch: '切换',
    tip: '提示',
    trigger: '触发',
    update: '更新',
    updateSuccess: '更新成功',
    userCenter: '个人中心',
    yesOrNo: {
      yes: '是',
      no: '否'
    }
  },
  request: {
    logout: '请求失败后登出用户',
    logoutMsg: '用户状态失效，请重新登录',
    logoutWithModal: '请求失败后弹出模态框再登出用户',
    logoutWithModalMsg: '用户状态失效，请重新登录',
    refreshToken: '请求的token已过期，刷新token',
    tokenExpired: 'token已过期'
  },
  theme: {
    themeDrawerTitle: '主题配置',
    tabs: {
      appearance: '外观',
      layout: '布局',
      general: '通用',
      preset: '预设'
    },
    appearance: {
      themeSchema: {
        title: '主题模式',
        light: '亮色模式',
        dark: '暗黑模式',
        auto: '跟随系统'
      },
      grayscale: '灰色模式',
      colourWeakness: '色弱模式',
      themeColor: {
        title: '主题颜色',
        primary: '主色',
        info: '信息色',
        success: '成功色',
        warning: '警告色',
        error: '错误色',
        followPrimary: '跟随主色'
      },
      themeRadius: {
        title: '主题圆角'
      },
      recommendColor: '应用推荐算法的颜色',
      recommendColorDesc: '推荐颜色的算法参照',
      preset: {
        title: '主题预设',
        apply: '应用',
        applySuccess: '预设应用成功',
        default: {
          name: '默认预设',
          desc: 'Soybean 默认主题预设'
        },
        dark: {
          name: '暗色预设',
          desc: '适用于夜间使用的暗色主题预设'
        },
        compact: {
          name: '紧凑型',
          desc: '适用于小屏幕的紧凑布局预设'
        },
        azir: {
          name: 'Azir的预设',
          desc: '是 Azir 比较喜欢的莫兰迪色系冷淡风'
        }
      }
    },
    layout: {
      layoutMode: {
        title: '布局模式',
        vertical: '左侧菜单模式',
        'vertical-mix': '左侧菜单混合模式',
        'vertical-hybrid-header-first': '左侧混合-顶部优先',
        horizontal: '顶部菜单模式',
        'top-hybrid-sidebar-first': '顶部混合-侧边优先',
        'top-hybrid-header-first': '顶部混合-顶部优先',
        vertical_detail: '左侧菜单布局，菜单在左，内容在右。',
        'vertical-mix_detail': '左侧双菜单布局，一级菜单在左侧深色区域，二级菜单在左侧浅色区域。',
        'vertical-hybrid-header-first_detail':
          '左侧混合布局，一级菜单在顶部，二级菜单在左侧深色区域，三级菜单在左侧浅色区域。',
        horizontal_detail: '顶部菜单布局，菜单在顶部，内容在下方。',
        'top-hybrid-sidebar-first_detail': '顶部混合布局，一级菜单在左侧，二级菜单在顶部。',
        'top-hybrid-header-first_detail': '顶部混合布局，一级菜单在顶部，二级菜单在左侧。'
      },
      tab: {
        title: '标签栏设置',
        visible: '显示标签栏',
        cache: '标签栏信息缓存',
        cacheTip: '一键开启/关闭全局 keepalive',
        height: '标签栏高度',
        mode: {
          title: '标签栏风格',
          slider: '滑块风格',
          chrome: '谷歌风格',
          button: '按钮风格'
        },
        closeByMiddleClick: '鼠标中键关闭标签页',
        closeByMiddleClickTip: '启用后可以使用鼠标中键点击标签页进行关闭'
      },
      header: {
        title: '头部设置',
        height: '头部高度',
        breadcrumb: {
          visible: '显示面包屑',
          showIcon: '显示面包屑图标'
        }
      },
      sider: {
        title: '侧边栏设置',
        inverted: '深色侧边栏',
        width: '侧边栏宽度',
        collapsedWidth: '侧边栏折叠宽度',
        mixWidth: '混合布局侧边栏宽度',
        mixCollapsedWidth: '混合布局侧边栏折叠宽度',
        mixChildMenuWidth: '混合布局子菜单宽度'
      },
      footer: {
        title: '底部设置',
        visible: '显示底部',
        fixed: '固定底部',
        height: '底部高度',
        right: '底部居右'
      },
      content: {
        title: '内容区域设置',
        scrollMode: {
          title: '滚动模式',
          tip: '主题滚动仅 main 部分滚动，外层滚动可携带头部底部一起滚动',
          wrapper: '外层滚动',
          content: '主体滚动'
        },
        page: {
          animate: '页面切换动画',
          mode: {
            title: '页面切换动画类型',
            'fade-slide': '滑动',
            fade: '淡入淡出',
            'fade-bottom': '底部消退',
            'fade-scale': '缩放消退',
            'zoom-fade': '渐变',
            'zoom-out': '闪现',
            none: '无'
          }
        },
        fixedHeaderAndTab: '固定头部和标签栏'
      }
    },
    general: {
      title: '通用设置',
      watermark: {
        title: '水印设置',
        visible: '显示全屏水印',
        text: '自定义水印文本',
        enableUserName: '启用用户名水印',
        enableTime: '显示当前时间',
        timeFormat: '时间格式'
      },
      multilingual: {
        title: '多语言设置',
        visible: '显示多语言按钮'
      },
      globalSearch: {
        title: '全局搜索设置',
        visible: '显示全局搜索按钮'
      }
    },
    configOperation: {
      copyConfig: '复制配置',
      copySuccessMsg: '复制成功，请替换 src/theme/settings.ts 中的变量 themeSettings',
      resetConfig: '重置配置',
      resetSuccessMsg: '重置成功'
    }
  },
  route: {
    login: '登录',
    403: '无权限',
    404: '页面不存在',
    500: '服务器错误',
    'iframe-page': '外链页面',
    cesiumdeom: '综合大屏',
    home: '越界开采系统',
    home_police: '报警列表',
    home_rail: '电子围栏管理',
    home_rail_person: '人员电子围栏',
    home_rail_car: '车辆电子围栏',
    casting_data_detection: '排土场-表面位移',
    casting_data_rainfall: '排土场-降雨量',
    casting_home: '主页',
    casting_monitor_entering: '监测值录入',
    casting_monitor_manage: '监测点管理',
    casting_police_list: '报警数据列表',
    casting_police_setting: '预警值设置',
    casting_polling_manage: '检查项管理',
    casting_polling_result: '检查结果录入',
    casting_polling_typemanage: '检查项类型管理',
    casting_system_casting: '排土场管理',
    casting_system_equipment: '设备管理',
    casting_system_modeldata: '首页监测项管理',
    casting_system_modelmanage: '首页模块化配置',
    casting_system_monitor: '监测点位配置',
    casting: '排土场安全监测系统',
    casting_data: '数据监测',
    casting_monitor: '人工监测',
    casting_polling: '人工巡检',
    casting_police: '报警管理',
    casting_system: '系统管理',
    casting_system_homemanage: '首页管理',
    personnel_facility: '设备管理',
    personnel_facility_position: '定位卡管理',
    personnel_manage: '人员管理',
    personnel_manage_personnel: '人员列表',
    personnel_manage_staff: '访客管理',
    personnel_manage_visitor: '员工管理',
    personnel_realtime: '实时监控',
    personnel_realtime_location: '实时定位',
    personnel_realtime_trace: '实时追踪',
    personnel_sos: 'SOS报警管理',
    personnel_sos_record: '人员报警记录',
    personnel_statistics_distribution: '人员分布统计',
    personnel_statistics: '统计管理',
    personnel_statistics_police: '报警统计',
    personnel_statistics_sheet: '考勤记录',
    personnel_statistics_statis: '人员统计',
    personnel_track: '轨迹查询',
    personnel_track_path: '人员轨迹',
    personnel: '人员定位系统',
    orientation_ai: 'Ai分析模块',
    orientation_monitor: '环境监测',
    orientation_monitor_facility: '设备管理',
    orientation_monitor_history: '监测历史',
    orientation_monitor_rainfall: '降雨量历史',
    orientation_video: '摄像头管理',
    orientation: '全方位监测监控系统',
    monitoring_data_detection: '边坡-表面位移',
    monitoring_data_rainfall: '边坡-降雨量',
    monitoring_home: '主页',
    monitoring_monitor_entering: '监测值录入',
    monitoring_monitor_manage: '监测点管理',
    monitoring_police_list: '报警数据列表',
    monitoring_police_setting: '预警值设置',
    monitoring_polling_manage: '检查项管理',
    monitoring_polling_result: '检查结果录入',
    monitoring_polling_typemanage: '检查项类型管理',
    monitoring_system_equipment: '设备管理',
    monitoring_system_modeldata: '首页监测项管理',
    monitoring_system_modelmanage: '首页模块化配置',
    monitoring_system_monitor: '监测点配置',
    monitoring_system_monitormanage: '监测项管理',
    monitoring: '边坡在线监测系统',
    monitoring_data: '数据监测',
    monitoring_data_casting: '排土场',
    monitoring_monitor: '人工监测',
    monitoring_polling: '人工巡检',
    monitoring_police: '报警管理',
    monitoring_system: '系统管理',
    monitoring_system_homemanage: '首页管理',
    truck_video_monitoring: '视频监控',
    truck_video_history: '历史报警',
    truck_safety: '安全监测',
    truck_safety_report: '报告模版',
    truck_safety_security: '安检记录',
    truck_area: '区域管理',
    truck_area_classes: '区域类别',
    truck_area_message: '区域信息',
    truck_video: '视频监控',
    truck_smart: '智能派单',
    truck_car_fault: '车辆故障',
    truck_car: '车辆管理',
    truck_car_maintain: '车辆维修',
    truck_car_message: '车辆信息',
    truck_car_playback: '车队管理',
    truck_car_track: '车辆轨迹',
    truck_car_type: '故障类型',
    truck_car_cartype: '车辆类型',
    truck_vehicle_baojing: '实时报警',
    truck_vehicle: '车载终端',
    truck_vehicle_lishi: '历史报警',
    truck_vehicle_shezhi: '设备设置',
    truck_drivermessage: '司机管理',
    truck: '卡车调度系统',
    ai: 'AI视频监控系统',
    ai_home: '首页',
    ai_jieguo: '报警结果',
    ai_shexiang: '摄像头配置',
    ai_shipin: '视频分析任务',
    ai_suanfa: '算法配置',
    ai_tixing: '报警提醒',
    ai_tuisong: '报警推送',
    user: '用户管理系统',
    user_bumen: '部门管理',
    user_caidan: '菜单管理',
    user_gangwei: '岗位管理',
    user_juese: '角色管理',
    user_log: '日志管理',
    user_model_dixing: '无人机模型管理',
    user_model: '模型管理',
    user_model_kuangqu: '地形图管理',
    user_yonghu: '用户管理',
    user_log_loginlog: '登录日志',
    user_log_operatelog: '操作日志'
  },
  page: {
    login: {
      common: {
        loginOrRegister: '登录 / 注册',
        userNamePlaceholder: '请输入用户名',
        phonePlaceholder: '请输入手机号',
        codePlaceholder: '请输入验证码',
        passwordPlaceholder: '请输入密码',
        confirmPasswordPlaceholder: '请再次输入密码',
        codeLogin: '验证码登录',
        confirm: '确定',
        back: '返回',
        validateSuccess: '验证成功',
        loginSuccess: '登录成功',
        welcomeBack: '欢迎回来，{userName} ！'
      },
      pwdLogin: {
        title: '密码登录',
        rememberMe: '记住我',
        forgetPassword: '忘记密码？',
        register: '注册账号',
        otherAccountLogin: '其他账号登录',
        otherLoginMode: '其他登录方式',
        superAdmin: '超级管理员',
        admin: '管理员',
        user: '普通用户'
      },
      codeLogin: {
        title: '验证码登录',
        getCode: '获取验证码',
        reGetCode: '{time}秒后重新获取',
        sendCodeSuccess: '验证码发送成功',
        imageCodePlaceholder: '请输入图片验证码'
      },
      register: {
        title: '注册账号',
        agreement: '我已经仔细阅读并接受',
        protocol: '《用户协议》',
        policy: '《隐私权政策》'
      },
      resetPwd: {
        title: '重置密码'
      },
      bindWeChat: {
        title: '绑定微信'
      }
    },
    home: {
      branchDesc:
        '为了方便大家开发和更新合并，我们对main分支的代码进行了精简，只保留了首页菜单，其余内容已移至example分支进行维护。预览地址显示的内容即为example分支的内容。',
      greeting: '早安，{userName}, 今天又是充满活力的一天!',
      weatherDesc: '今日多云转晴，20℃ - 25℃!',
      projectCount: '项目数',
      todo: '待办',
      message: '消息',
      downloadCount: '下载量',
      registerCount: '注册量',
      schedule: '作息安排',
      study: '学习',
      work: '工作',
      rest: '休息',
      entertainment: '娱乐',
      visitCount: '访问量',
      turnover: '成交额',
      dealCount: '成交量',
      projectNews: {
        title: '项目动态',
        moreNews: '更多动态',
        desc1: 'Soybean 在2021年5月28日创建了开源项目 soybean-admin!',
        desc2: 'Yanbowe 向 soybean-admin 提交了一个bug，多标签栏不会自适应。',
        desc3: 'Soybean 准备为 soybean-admin 的发布做充分的准备工作!',
        desc4: 'Soybean 正在忙于为soybean-admin写项目说明文档！',
        desc5: 'Soybean 刚才把工作台页面随便写了一些，凑合能看了！'
      },
      creativity: '创意'
    }
  },
  form: {
    required: '不能为空',
    userName: {
      required: '请输入用户名',
      invalid: '用户名格式不正确'
    },
    phone: {
      required: '请输入手机号',
      invalid: '手机号格式不正确'
    },
    pwd: {
      required: '请输入密码',
      invalid: '密码格式不正确，6-18位字符，包含字母、数字、下划线'
    },
    confirmPwd: {
      required: '请输入确认密码',
      invalid: '两次输入密码不一致'
    },
    code: {
      required: '请输入验证码',
      invalid: '验证码格式不正确'
    },
    email: {
      required: '请输入邮箱',
      invalid: '邮箱格式不正确'
    }
  },
  dropdown: {
    closeCurrent: '关闭',
    closeOther: '关闭其它',
    closeLeft: '关闭左侧',
    closeRight: '关闭右侧',
    closeAll: '关闭所有'
  },
  icon: {
    themeConfig: '主题配置',
    themeSchema: '主题模式',
    lang: '切换语言',
    fullscreen: '全屏',
    fullscreenExit: '退出全屏',
    reload: '刷新页面',
    collapse: '折叠菜单',
    expand: '展开菜单',
    pin: '固定',
    unpin: '取消固定'
  },
  datatable: {
    itemCount: '共 {total} 条'
  }
};

export default local;
