import request from '@/utils/request'

// 查询人员信息列表
export function listInfo(query) {
  return request({
    url: '/person/info/getPersonList',
    method: 'get',
    params: query
  })
}
// 解绑卡
export function unbindCard(data) {
  return request({
    url: '/person/info/unbindCard',
    method: 'put',
    data: data
  })
}

// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info/addPerson',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updatePerson',
    method: 'put',
    data: data
  })
}


// 离开
export function leave(data) {
  return request({
    url: '/person/info/visitorLeave',
    method: 'put',
    data: data
  })
}

export function getInfo(id) {
  return request({
    url: '/person/info/getPersonById/' + id,
    method: 'get'
  })
}

// 删除人员信息
export function delInfo(id) {
  return request({
    url: '/person/info/deletePerson/' + id,
    method: 'delete',
  })
}
