import request from '@/utils/request'

// 查询人员定位卡列表
export function listCard(query) {
  return request({
    url: '/person/card/getCardList',
    method: 'GET',
    // data: query
    params: query
    
  })
}

// 查询人员定位卡详细
export function getCard(id) {
  return request({
    url: '/person/card/getCardById/' + id,
    method: 'get',
  })
}

// 新增人员定位卡
export function addCard(data) {
  return request({
    url: '/person/card/addCard',
    method: 'post',
    data: data
  })
}

// 修改人员定位卡
export function updateCard(data) {
  return request({
    url: '/person/card/updateCard',
    method: 'put',
    data: data
  })
}

// 删除人员定位卡
export function delCard(id) {
  return request({
    url: '/person/card/deleteCard/' + id,
    method: 'delete',
  })
}
