/**
 * localStorage 操作工具库
 * 提供完整的增删改查功能，支持类型转换、错误处理和过期时间设置
 */

/**
 * 存储数据到 localStorage
 * @param {string} key 存储键名
 * @param {*} value 要存储的值
 * @param {number} expire 过期时间（毫秒），0表示永不过期
 * @returns {boolean} 是否存储成功
 */
export const set = (key, value) => {
  localStorage.setItem(key, value);
};

/**
 * 从 localStorage 获取数据
 * @param {string} key 存储键名
 * @param {*} defaultValue 默认值，当键不存在或已过期时返回
 * @returns {*} 存储的值或默认值
 */
export const get = (key, defaultValue = null) => {
   const itemStr = localStorage.getItem(key);
    return itemStr;
};


// 默认导出所有方法
export const localStg = {
  set,
  get,
}