import request from '@/utils/request'

// 查询公安武警列表
export function listPsap(query) {
  return request({
    url: '/gq/psap/list',
    method: 'get',
    params: query
  })
}

export function getAllDept(query) {
  return request({
    url: '/gq/psap/getAllDept',
    method: 'get',
    params: query
  })
}




// 查询公安武警详细
export function getPsap(id) {
  return request({
    url: '/gq/psap/' + id,
    method: 'get'
  })
}

// 新增公安武警
export function addPsap(data) {
  return request({
    url: '/gq/psap',
    method: 'post',
    data: data
  })
}

// 修改公安武警
export function updatePsap(data) {
  return request({
    url: '/gq/psap',
    method: 'put',
    data: data
  })
}

// 删除公安武警
export function delPsap(id) {
  return request({
    url: '/gq/psap/' + id,
    method: 'delete'
  })
}
