import request from "@/utils/request";

// 查询岗位列表
export function listInfo(query) {
	return request({
		url: "/gq/merchant/list",
		method: "get",
		params: query,
	});
}

// 查询岗位详细
export function getInfo(postId) {
	return request({
		url: "/gq/merchant/" + postId,
		method: "get",
	});
}

// 新增岗位
export function addInfo(data) {
	return request({
		url: "/gq/merchant",
		method: "post",
		data: data,
	});
}

// 修改岗位
export function updateInfo(data) {
	return request({
		url: "/gq/merchant",
		method: "put",
		data: data,
	});
}

// 删除岗位
export function delInfo(postId) {
	return request({
		url: "/gq/merchant/remove/" + postId,
		method: "delete",
	});
}

// 获取二维码地址
export function getImgUrl(query) {
	return request({
		url: "/gq/merchant/getQrCode/" + query,
		method: "get",
		params: query,
	});
}

// 获取街道list
export function deptList(query) {
	return request({
		url: "/system/user/streetTree",
		method: "get",
		params: query,
	});
}



export function getJiuxiaochangsuoTypeList(query) {
	return request({
		url: "/gq/merchant/industry-category",
		method: "get",
		params: query,
	});
}

export function getHangyeTypeList(query) {
	return request({
		url: "/gq/merchant/industry-dic",
		method: "get",
		params: query,
	});
}
