import request from '@/utils/request'

// 查询报警设置列表
export function listInfo(query) {
  return request({
    url: '/sos/alarm/getAlarmList',
    method: 'get',
    params: query
  })
}

// 查询报警设置详细
export function getAlarmById(id) {
  return request({
    url: '/sos/alarm/getAlarmById'+id,
    method: 'get'
  })
}

// 新增报警设置
export function addAlarm(data) {
  return request({
    url: '/sos/alarm/addAlarm',
    method: 'post',
    data: data
  })
}

// 修改报警设置
export function update(data) {
  return request({
    url: '/sos/alarm/updateAlarm',
    method: 'put',
    data: data
  })
}


// 删除报警设置
export function deleteAlarm(id) {
  return request({
    url: '/sos/alarm/deleteAlarm'+id,
    method: 'delete'
  })
}



// 添加聚集远程报警设置
export function addJujiSetting(id) {
  return request({
    url: '/sos/alarm/addRemoteGatherAlarmSetting',
    method: 'post'
  })
}


// 更新聚集远程报警设置
export function updateJujiSetting(id) {
  return request({
    url: '/sos/alarm/updateRemoteGatherAlarmSetting',
    method: 'put'
  })
}

// 删除聚集远程报警设置
export function deleteJujiSetting(id) {
  return request({
    url: '/sos/alarm/deleteRemoteGatherAlarmSetting',
    method: 'delete'
  })
}


// 查询聚集报警设置列表
export function getRemoteGatherAlarmSettingList(query) {
  return request({
    url: '/sos/alarm/getRemoteGatherAlarmSettingList',
    method: 'get',
    params: query
  })
}
