import request from '@/utils/request'

// 查询人员信息列表
export function listInfo(query) {
  return request({
    url: '/person/info/getRemotePersonInfoList',
    method: 'post',
    params: query
  })
}

// 查询人员信息详细
export function getInfo(data) {
  return request({
    url: '/person/info/getRemotePersonInfoById',
    method: 'post',
    data: data
  })
}

// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info/addRemotePersonInfo',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updateRemotePersonInfo',
    method: 'post',
    data: data
  })
}

// 删除人员信息
export function delInfo(data) {
  return request({
    url: '/person/info/deleteRemoteVisitorInfo',
    method: 'post',
     data: data
  })
}
