import request from '@/utils/request'

// 查询报警设置列表
export function listInfo(query) {
  return request({
    url: '/sos/alarm/getAlarmList',
    method: 'get',
    params: query
  })
}

// 查询报警设置详细
export function getAlarmById(id) {
  return request({
    url: '/sos/alarm/getAlarmById'+id,
    method: 'get'
  })
}

// 新增报警设置
export function addAlarm(data) {
  return request({
    url: '/sos/alarm/addAlarm',
    method: 'post',
    data: data
  })
}

// 修改报警设置
export function update(data) {
  return request({
    url: '/sos/alarm/updateAlarm',
    method: 'put',
    data: data
  })
}


// 删除报警设置
export function deleteAlarm(id) {
  return request({
    url: '/sos/alarm/deleteAlarm/'+id,
    method: 'delete'
  })
}
