import request from '@/utils/request'

// 查询人员定位卡列表
export function listCard(query) {
  return request({
    url: '/person/card/getRemoteCardList',
    method: 'post',
    data: query
    // params: query
    
  })
}

// 查询人员定位卡详细
export function getCard(data) {
  return request({
    url: '/person/card/getRemoteCardById',
    method: 'post',
    data: data
    
  })
}

// 新增人员定位卡
export function addCard(data) {
  return request({
    url: '/person/card/addRemoteCard',
    method: 'post',
    data: data
  })
}

// 修改人员定位卡
export function updateCard(data) {
  return request({
    url: '/person/card/updateRemoteCard',
    method: 'post',
    data: data
  })
}

// 删除人员定位卡
export function delCard(data) {
  return request({
    url: '/person/card/deleteRemoteCard',
    method: 'post',
    data: data
  })
}
