import request from '@/utils/request'

// 查询人员信息列表
export function listInfo(query) {
  return request({
    url: '/person/info/getRemotePersonInfoListt',
    method: 'get',
    params: query
  })
}

// 查询人员信息详细
export function getInfo(personId) {
  return request({
    url: '/person/info/' + personId,
    method: 'get'
  })
}

// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info',
    method: 'put',
    data: data
  })
}

// 删除人员信息
export function delInfo(personId) {
  return request({
    url: '/person/info/' + personId,
    method: 'delete'
  })
}
