import request from '@/utils/request'

// 查询系统字典列表
export function listDict(query) {
  return request({
    url: '/sys/dict/getDictList',
    method: 'get',
    params: query
  })
}

// 查询系统字典详细
export function getDict(dictId) {
  return request({
    url: '/sys/dict/getDictById/' + dictId,
    method: 'get'
  })
}

// 新增系统字典
export function addDict(data) {
  return request({
    url: '/sys/dict/addDict',
    method: 'post',
    data: data
  })
}

// 修改系统字典
export function updateDict(data) {
  return request({
    url: '/sys/dict/updateDict',
    method: 'put',
    data: data
  })
}

// 删除系统字典
export function delDict(dictId) {
  return request({
    url: '/sys/dict/deleteDict/' + dictId,
    method: 'delete'
  })
}
