import request from '@/utils/request'

// 查询报警设置列表
export function listSetting(query) {
  return request({
    url: '/alarm/setting/getRemoteAlarmSettingList',
    method: 'get',
    params: query
  })
}

// 查询报警设置详细
export function getSetting(id) {
  return request({
    url: '/alarm/setting/getRemoteAlarmSettingById',
    method: 'get'
  })
}

// 新增报警设置
export function addSetting(data) {
  return request({
    url: '/alarm/setting/addRemoteAlarmSetting',
    method: 'post',
    data: data
  })
}

// 修改报警设置
export function updateSetting(data) {
  return request({
    url: '/alarm/setting/updateRemoteAlarmSetting',
    method: 'put',
    data: data
  })
}


// 删除报警设置
export function delSetting(id) {
  return request({
    url: '/alarm/setting/deleteRemoteAlarmSetting',
    method: 'delete'
  })
}



// 添加聚集远程报警设置
export function addJujiSetting(id) {
  return request({
    url: '/alarm/setting/addRemoteGatherAlarmSetting',
    method: 'post'
  })
}


// 更新聚集远程报警设置
export function updateJujiSetting(id) {
  return request({
    url: '/alarm/setting/updateRemoteGatherAlarmSetting',
    method: 'put'
  })
}

// 删除聚集远程报警设置
export function deleteJujiSetting(id) {
  return request({
    url: '/alarm/setting/deleteRemoteGatherAlarmSetting',
    method: 'delete'
  })
}


// 查询聚集报警设置列表
export function getRemoteGatherAlarmSettingList(query) {
  return request({
    url: '/alarm/setting/getRemoteGatherAlarmSettingList',
    method: 'get',
    params: query
  })
}
