import request from '@/utils/request'

// 查询人员信息列表
export function listInfo(query) {
  return request({
    url: '/person/info/getPersonList',
    method: 'get',
    params: query
  })
}

// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info/addRemotePersonInfo',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updateRemotePersonInfo',
    method: 'put',
    data: data
  })
}

// 删除人员信息
export function delInfo(data) {
  return request({
    url: '/person/info/deleteRemotePersonInfo',
    method: 'delete',
     data: data
  })
}
