import request from '@/utils/request'

// 查询安全常识列表
export function listKnowledge(query) {
  return request({
    url: '/gq/knowledge/list',
    method: 'get',
    params: query
  })
}

// 查询安全常识详细
export function getKnowledge(id) {
  return request({
    url: '/gq/knowledge/' + id,
    method: 'get'
  })
}

// 新增安全常识
export function addKnowledge(data) {
  return request({
    url: '/gq/knowledge',
    method: 'post',
    data: data
  })
}

// 修改安全常识
export function updateKnowledge(data) {
  return request({
    url: '/gq/knowledge',
    method: 'put',
    data: data
  })
}

// 删除安全常识
export function delKnowledge(id) {
  return request({
    url: '/gq/knowledge/' + id,
    method: 'delete'
  })
}

//查询安全检查数据排行
export function getlistranking(query) {
  return request({
    url: '/gq/checkRecord/ranking',
    method: 'get',
    params: query
  })
}