import request from '@/utils/request'

// 查询人员信息列表
// 查询人员信息详细
export function getDict(data) {
  return request({
    url: '/sys/dict/findDictType',
    method: 'get',
    params: data
  })
}

// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info/addRemotePersonInfo',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updateRemotePersonInfo',
    method: 'put',
    data: data
  })
}

// 删除人员信息
export function delInfo(data) {
  return request({
    url: '/person/info/deleteRemoteVisitorInfo',
    method: 'delete',
     data: data
  })
}
