import request from '@/utils/request'

// 查询人员信息列表
export function listInfo(query) {
  return request({
    url: '/person/info/getRemoteVisitorInfoList',
    method: 'get',
    params: query
  })
}

// 解绑卡
export function unbindCard(data) {
  return request({
    url: '/person/info/giveback',
    method: 'put',
    data: data
  })
}


// 新增人员信息
export function addInfo(data) {
  return request({
    url: '/person/info/addRemoteVisitorInfo',
    method: 'post',
    data: data
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updateRemoteVisitorInfo',
    method: 'put',
    data: data
  })
}

// 删除人员信息
export function delInfo(data) {
  return request({
    url: '/person/info/deleteRemoteVisitorInfo',
    method: 'delete',
     data: data
  })
}
