import request from '@/utils/request-zk'

// 查询部门列表
export function getDept(data) {
  return request({
    url: '/dep/list',
    method: 'get',
    params: data
  })
}

// 新增人员信息
export function getPosition(data) {
  return request({
    url: '/pos/list',
    method: 'get',
     params: data
  })
}

// 人员定位路由切换
export function getGuijiRouter(cardId) {
  return request({
    url: '/home/person/route/' + cardId,
    method: 'get',
  })
}

// 修改人员信息
export function updateInfo(data) {
  return request({
    url: '/person/info/updateRemotePersonInfo',
    method: 'put',
    data: data
  })
}

// 删除人员信息
export function delInfo(data) {
  return request({
    url: '/person/info/deleteRemoteVisitorInfo',
    method: 'delete',
     data: data
  })
}
